<?php
session_start();
if (strlen($_SESSION['uid']) == 0) {
    header('location:../index.php');
    exit;
}

include('../includes/config.php');

// Handle form submission
if (isset($_POST['submit'])) {
    $supplierCode = $_POST['supplier_code'];
    $supplierName = $_POST['supplier_name'];
    $contactPerson = $_POST['contact_person'];
    $phone = $_POST['phone'];
    $address = $_POST['address'];
    $city = $_POST['city'];
    $notes = $_POST['notes'];
    $createdBy = $_SESSION['uid'];

    $sql = "INSERT INTO suppliers (supplier_code, supplier_name, contact_person, phone, address, city, notes, created_by) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $con->prepare($sql);
    $stmt->bind_param("sssssssi", $supplierCode, $supplierName, $contactPerson, $phone, $address, $city, $notes, $createdBy);
    
    if ($stmt->execute()) {
        echo "<script>alert('Supplier added successfully');</script>";
    } else {
        echo "<script>alert('Error adding supplier');</script>";
    }
}

// Handle edit form submission
if (isset($_POST['update'])) {
    $supplierId = $_POST['supplier_id'];
    $supplierCode = $_POST['supplier_code'];
    $supplierName = $_POST['supplier_name'];
    $contactPerson = $_POST['contact_person'];
    $phone = $_POST['phone'];
    $address = $_POST['address'];
    $city = $_POST['city'];
    $notes = $_POST['notes'];

    $sql = "UPDATE suppliers SET supplier_code=?, supplier_name=?, contact_person=?, phone=?, address=?, city=?, notes=? WHERE id=?";
    $stmt = $con->prepare($sql);
    $stmt->bind_param("sssssssi", $supplierCode, $supplierName, $contactPerson, $phone, $address, $city, $notes, $supplierId);
    
    if ($stmt->execute()) {
        echo "<script>alert('Supplier updated successfully'); window.location.href='index.php';</script>";
    } else {
        echo "<script>alert('Error updating supplier');</script>";
    }
}

// Handle delete
if (isset($_GET['delete'])) {
    $supplierId = $_GET['delete'];
    $sql = "UPDATE suppliers SET status='inactive' WHERE id=?";
    $stmt = $con->prepare($sql);
    $stmt->bind_param("i", $supplierId);
    $stmt->execute();
    echo "<script>alert('Supplier deactivated successfully'); window.location.href='index.php';</script>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Supplier Management - Vegetable Shop</title>
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">
    <div id="wrapper">
        <?php include('../includes/sidebar.php'); ?>
        
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include('../includes/topbar.php'); ?>
                
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Supplier Management</h1>
                        <button class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm" data-toggle="modal" data-target="#addSupplierModal">
                            <i class="fas fa-plus fa-sm text-white-50"></i> Add New Supplier
                        </button>
                    </div>

                    <!-- Suppliers Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">All Suppliers</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Code</th>
                                            <th>Supplier Name</th>
                                            <th>Contact Person</th>
                                            <th>Phone</th>
                                            <th>City</th>
                                            <th>Outstanding</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM suppliers WHERE status='active' ORDER BY supplier_name";
                                        $result = mysqli_query($con, $sql);
                                        while ($row = mysqli_fetch_assoc($result)) {
                                        ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row['supplier_code']); ?></td>
                                            <td><?php echo htmlspecialchars($row['supplier_name']); ?></td>
                                            <td><?php echo htmlspecialchars($row['contact_person']); ?></td>
                                            <td><?php echo htmlspecialchars($row['phone']); ?></td>
                                            <td><?php echo htmlspecialchars($row['city']); ?></td>
                                            <td>₹<?php echo number_format($row['outstanding_balance'], 2); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo $row['status'] == 'active' ? 'success' : 'danger'; ?>">
                                                    <?php echo ucfirst($row['status']); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <a href="ledger.php?id=<?php echo $row['id']; ?>" class="btn btn-info btn-sm">
                                                    <i class="fas fa-book"></i> Ledger
                                                </a>
                                                <button class="btn btn-warning btn-sm" onclick="editSupplier(<?php echo $row['id']; ?>)" data-toggle="modal" data-target="#editSupplierModal">
                                                    <i class="fas fa-edit"></i> Edit
                                                </button>
                                                <a href="?delete=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm" 
                                                   onclick="return confirm('Are you sure you want to deactivate this supplier?')">
                                                    <i class="fas fa-trash"></i> Delete
                                                </a>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('../includes/footer.php'); ?>
        </div>
    </div>

    <!-- Add Supplier Modal -->
    <div class="modal fade" id="addSupplierModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Supplier</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Supplier Code *</label>
                                    <input type="text" class="form-control" name="supplier_code" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Supplier Name *</label>
                                    <input type="text" class="form-control" name="supplier_name" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Contact Person</label>
                                    <input type="text" class="form-control" name="contact_person">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" class="form-control" name="phone">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea class="form-control" name="address" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>City</label>
                                    <input type="text" class="form-control" name="city">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea class="form-control" name="notes" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" name="submit" class="btn btn-primary">Add Supplier</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Supplier Modal -->
    <div class="modal fade" id="editSupplierModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Supplier</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <input type="hidden" name="supplier_id" id="edit_supplier_id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Supplier Code *</label>
                                    <input type="text" class="form-control" name="supplier_code" id="edit_supplier_code" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Supplier Name *</label>
                                    <input type="text" class="form-control" name="supplier_name" id="edit_supplier_name" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Contact Person</label>
                                    <input type="text" class="form-control" name="contact_person" id="edit_contact_person">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" class="form-control" name="phone" id="edit_phone">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea class="form-control" name="address" id="edit_address" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>City</label>
                                    <input type="text" class="form-control" name="city" id="edit_city">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea class="form-control" name="notes" id="edit_notes" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" name="update" class="btn btn-primary">Update Supplier</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });
        
        function editSupplier(id) {
            // Get supplier data via AJAX
            $.ajax({
                url: 'get_supplier.php',
                type: 'GET',
                data: { id: id },
                dataType: 'json',
                success: function(data) {
                    $('#edit_supplier_id').val(data.id);
                    $('#edit_supplier_code').val(data.supplier_code);
                    $('#edit_supplier_name').val(data.supplier_name);
                    $('#edit_contact_person').val(data.contact_person);
                    $('#edit_phone').val(data.phone);
                    $('#edit_address').val(data.address);
                    $('#edit_city').val(data.city);
                    $('#edit_notes').val(data.notes);
                },
                error: function() {
                    alert('Error loading supplier data');
                }
            });
        }
    </script>
</body>
</html>
