<?php
// Alternative session configuration for login.php
// Add this BEFORE session_start() if you still have issues

// Set custom session save path to a more accessible location
$session_path = dirname(__FILE__) . '/sessions';
if (!file_exists($session_path)) {
    mkdir($session_path, 0777, true);
    chmod($session_path, 0777);
}
session_save_path($session_path);

// Additional session security settings
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Set to 1 if using HTTPS
ini_set('session.gc_probability', 1);
ini_set('session.gc_divisor', 1000);
ini_set('session.gc_maxlifetime', 1440);

// Now start the session
session_start();

// Test if session is working
if (!isset($_SESSION['session_test'])) {
    $_SESSION['session_test'] = 'Session is working!';
}

// Rest of your login.php code goes here...
include('includes/config.php');

// ... rest of the existing login.php code
?>
