<?php
// Test script to debug payment storage
session_start();
include_once('../includes/config.php');

// Set a test session for debugging
if (!isset($_SESSION['uid'])) {
    $_SESSION['uid'] = 1;
    $_SESSION['username'] = 'Test User';
}

echo "<h2>Payment Debug Test</h2>";

// Check if payment_history table exists
echo "<h3>1. Checking if payment_history table exists:</h3>";
$tableCheckQuery = "SHOW TABLES LIKE 'payment_history'";
$tableCheckResult = mysqli_query($con, $tableCheckQuery);

if ($tableCheckResult && mysqli_num_rows($tableCheckResult) > 0) {
    echo "✅ payment_history table exists<br>";
    
    // Check table structure
    echo "<h3>2. Payment History Table Structure:</h3>";
    $structureQuery = "DESCRIBE payment_history";
    $structureResult = mysqli_query($con, $structureQuery);
    
    if ($structureResult) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($row = mysqli_fetch_assoc($structureResult)) {
            echo "<tr>";
            echo "<td>" . $row['Field'] . "</td>";
            echo "<td>" . $row['Type'] . "</td>";
            echo "<td>" . $row['Null'] . "</td>";
            echo "<td>" . $row['Key'] . "</td>";
            echo "<td>" . $row['Default'] . "</td>";
            echo "<td>" . $row['Extra'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Check existing payment history records
    echo "<h3>3. Existing Payment History Records:</h3>";
    $paymentQuery = "SELECT * FROM payment_history ORDER BY created_date DESC LIMIT 10";
    $paymentResult = mysqli_query($con, $paymentQuery);
    
    if ($paymentResult && mysqli_num_rows($paymentResult) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Invoice ID</th><th>Date</th><th>Cash Amount</th><th>UPI Amount</th><th>Total Payment</th><th>Payment Method</th><th>Created Date</th></tr>";
        while ($row = mysqli_fetch_assoc($paymentResult)) {
            echo "<tr>";
            echo "<td>" . $row['id'] . "</td>";
            echo "<td>" . $row['invoice_id'] . "</td>";
            echo "<td>" . $row['payment_date'] . "</td>";
            echo "<td>₹" . number_format($row['cash_amount'], 2) . "</td>";
            echo "<td>₹" . number_format($row['upi_amount'], 2) . "</td>";
            echo "<td>₹" . number_format($row['total_payment'], 2) . "</td>";
            echo "<td>" . $row['payment_method'] . "</td>";
            echo "<td>" . $row['created_date'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "No payment history records found.<br>";
    }
    
} else {
    echo "❌ payment_history table does not exist<br>";
}

// Check recent invoices and their payment details
echo "<h3>4. Recent Invoices with Payment Details:</h3>";
$invoiceQuery = "SELECT id, invoice_no, invoice_date, customer_name, total_amount, cash_received, upi_received, payment_status, balance_amount, cash_tender_received 
                FROM sales_invoices 
                ORDER BY created_date DESC 
                LIMIT 5";
$invoiceResult = mysqli_query($con, $invoiceQuery);

if ($invoiceResult && mysqli_num_rows($invoiceResult) > 0) {
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Invoice No</th><th>Date</th><th>Customer</th><th>Total</th><th>Cash Received</th><th>UPI Received</th><th>Cash Tender</th><th>Status</th><th>Balance</th></tr>";
    while ($row = mysqli_fetch_assoc($invoiceResult)) {
        echo "<tr>";
        echo "<td>" . $row['invoice_no'] . "</td>";
        echo "<td>" . $row['invoice_date'] . "</td>";
        echo "<td>" . ($row['customer_name'] ?: 'Walk-in') . "</td>";
        echo "<td>₹" . number_format($row['total_amount'], 2) . "</td>";
        echo "<td>₹" . number_format($row['cash_received'], 2) . "</td>";
        echo "<td>₹" . number_format($row['upi_received'], 2) . "</td>";
        echo "<td>₹" . number_format($row['cash_tender_received'], 2) . "</td>";
        echo "<td>" . $row['payment_status'] . "</td>";
        echo "<td>₹" . number_format($row['balance_amount'], 2) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "No invoice records found.<br>";
}

// Test UPI payment simulation
echo "<h3>5. Simulate UPI Payment Test:</h3>";
echo "<form method='POST'>";
echo "Test UPI Amount: <input type='number' name='test_upi' value='100.00' step='0.01'>";
echo "<input type='submit' name='test_payment' value='Test UPI Payment Storage'>";
echo "</form>";

if (isset($_POST['test_payment'])) {
    $testUpiAmount = floatval($_POST['test_upi']);
    
    // Create a test invoice
    $testInvoiceQuery = "INSERT INTO sales_invoices 
        (invoice_no, invoice_date, customer_name, total_amount, upi_received, payment_status, created_by) 
        VALUES (
            'TEST-" . date('YmdHis') . "',
            '" . date('Y-m-d') . "',
            'UPI Test Customer',
            " . $testUpiAmount . ",
            " . $testUpiAmount . ",
            'paid',
            1
        )";
    
    if (mysqli_query($con, $testInvoiceQuery)) {
        $testInvoiceId = mysqli_insert_id($con);
        echo "✅ Test invoice created with ID: $testInvoiceId<br>";
        
        // Insert UPI payment history
        $upiPaymentQuery = "INSERT INTO payment_history 
            (invoice_id, payment_date, cash_amount, upi_amount, total_payment, payment_method, created_by) 
            VALUES (
                " . $testInvoiceId . ",
                '" . date('Y-m-d') . "',
                0.00,
                " . $testUpiAmount . ",
                " . $testUpiAmount . ",
                'upi',
                1
            )";
        
        if (mysqli_query($con, $upiPaymentQuery)) {
            echo "✅ UPI payment history record created successfully!<br>";
        } else {
            echo "❌ Failed to create UPI payment history: " . mysqli_error($con) . "<br>";
        }
    } else {
        echo "❌ Failed to create test invoice: " . mysqli_error($con) . "<br>";
    }
}

echo "<br><a href='index.php'>← Back to Sales System</a>";
?>
