<?php
session_start();
$_SESSION['uid'] = 1; // Set test session

include_once('../includes/config.php');

echo "<h2>Invoice Deletion Test - Related Records Cleanup</h2>";

// Get Kannan's invoices and their related records
$customer_name = 'Kannan';
echo "<h3>Testing invoice deletion for customer: $customer_name</h3>";

// Get customer info
$customer_stmt = $con->prepare("SELECT id, customer_name, outstanding_balance FROM customers WHERE LOWER(customer_name) = LOWER(?) AND status = 'active'");
$customer_stmt->bind_param("s", $customer_name);
$customer_stmt->execute();
$customer_result = $customer_stmt->get_result();

if ($customer_result->num_rows > 0) {
    $customer = $customer_result->fetch_assoc();
    echo "<p><strong>Customer ID:</strong> " . $customer['id'] . "</p>";
    echo "<p><strong>Customer Name:</strong> " . $customer['customer_name'] . "</p>";
    echo "<p><strong>Current Outstanding Balance:</strong> ₹" . $customer['outstanding_balance'] . "</p>";
    
    $customer_id = $customer['id'];
    
    // Show all invoices for this customer
    echo "<h4>All Invoices for this Customer:</h4>";
    $invoice_stmt = $con->prepare("
        SELECT id, invoice_no, invoice_date, invoice_type, total_amount, balance_amount, payment_status
        FROM sales_invoices 
        WHERE customer_id = ? 
        ORDER BY invoice_date DESC
    ");
    $invoice_stmt->bind_param("i", $customer_id);
    $invoice_stmt->execute();
    $invoice_result = $invoice_stmt->get_result();
    
    if ($invoice_result->num_rows > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Invoice No</th><th>Date</th><th>Type</th><th>Total</th><th>Balance</th><th>Status</th><th>Actions</th></tr>";
        
        while ($invoice = $invoice_result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $invoice['id'] . "</td>";
            echo "<td>" . $invoice['invoice_no'] . "</td>";
            echo "<td>" . $invoice['invoice_date'] . "</td>";
            echo "<td>" . strtoupper($invoice['invoice_type']) . "</td>";
            echo "<td>₹" . $invoice['total_amount'] . "</td>";
            echo "<td>₹" . $invoice['balance_amount'] . "</td>";
            echo "<td>" . strtoupper($invoice['payment_status']) . "</td>";
            echo "<td>";
            if ($invoice['invoice_type'] == 'credit') {
                echo "<button onclick='showInvoiceDetails(" . $invoice['id'] . ")'>Show Details</button>";
            }
            echo "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Show customer ledger entries
    echo "<h4>Customer Ledger Entries:</h4>";
    $ledger_stmt = $con->prepare("
        SELECT transaction_date, transaction_type, reference_no, reference_id, 
               debit_amount, credit_amount, balance, description
        FROM customer_ledger 
        WHERE customer_id = ? 
        ORDER BY created_date ASC
    ");
    $ledger_stmt->bind_param("i", $customer_id);
    $ledger_stmt->execute();
    $ledger_result = $ledger_stmt->get_result();
    
    if ($ledger_result->num_rows > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>Date</th><th>Type</th><th>Reference</th><th>Ref ID</th><th>Debit</th><th>Credit</th><th>Balance</th><th>Description</th></tr>";
        
        while ($ledger = $ledger_result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $ledger['transaction_date'] . "</td>";
            echo "<td>" . strtoupper($ledger['transaction_type']) . "</td>";
            echo "<td>" . $ledger['reference_no'] . "</td>";
            echo "<td>" . ($ledger['reference_id'] ?: '-') . "</td>";
            echo "<td>₹" . $ledger['debit_amount'] . "</td>";
            echo "<td>₹" . $ledger['credit_amount'] . "</td>";
            echo "<td>₹" . $ledger['balance'] . "</td>";
            echo "<td>" . htmlspecialchars($ledger['description']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Show payment allocations
    echo "<h4>Payment Allocations:</h4>";
    $allocation_stmt = $con->prepare("
        SELECT pa.id, pa.allocated_amount, si.invoice_no, pr.receipt_no, pr.total_amount
        FROM payment_allocations pa
        JOIN sales_invoices si ON pa.invoice_id = si.id
        JOIN payment_receipts pr ON pa.payment_receipt_id = pr.id
        WHERE si.customer_id = ?
        ORDER BY pa.id DESC
    ");
    $allocation_stmt->bind_param("i", $customer_id);
    $allocation_stmt->execute();
    $allocation_result = $allocation_stmt->get_result();
    
    if ($allocation_result->num_rows > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>Allocation ID</th><th>Invoice No</th><th>Receipt No</th><th>Allocated Amount</th><th>Receipt Total</th></tr>";
        
        while ($allocation = $allocation_result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $allocation['id'] . "</td>";
            echo "<td>" . $allocation['invoice_no'] . "</td>";
            echo "<td>" . $allocation['receipt_no'] . "</td>";
            echo "<td>₹" . $allocation['allocated_amount'] . "</td>";
            echo "<td>₹" . $allocation['total_amount'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No payment allocations found.</p>";
    }
    
} else {
    echo "<p>Customer '$customer_name' not found.</p>";
}

echo "<hr>";
echo "<h4>Testing Instructions:</h4>";
echo "<ol>";
echo "<li>Note the current outstanding balance and ledger entries above</li>";
echo "<li>Go to the sales system and find an invoice to delete</li>";
echo "<li>Delete a credit invoice that has payments allocated to it</li>";
echo "<li>Refresh this page to see the cleanup results</li>";
echo "<li>Verify that:</li>";
echo "<ul>";
echo "<li>Invoice is deleted from sales_invoices table</li>";
echo "<li>Invoice details are deleted from sales_invoice_details table</li>";
echo "<li>Related customer_ledger entries are cleaned up</li>";
echo "<li>Payment allocations are removed or adjusted</li>";
echo "<li>Customer outstanding balance is recalculated correctly</li>";
echo "</ul>";
echo "</ol>";

echo "<p><a href='index.php' target='_blank'>Open Sales System</a></p>";
echo "<p><a href='javascript:location.reload()'>Refresh This Page</a></p>";
?>

<script>
function showInvoiceDetails(invoiceId) {
    alert('Invoice ID: ' + invoiceId + '\n\nTo delete this invoice:\n1. Go to the sales system\n2. Find this invoice in the list\n3. Click the delete button\n4. Confirm deletion\n5. Come back and refresh this page to see cleanup results');
}
</script>
