<?php
include_once('../includes/config.php');

if (!$con) {
    die('Database connection failed');
}

// Read the SQL file
$sql = file_get_contents('create_tables.sql');

// Split into individual statements
$statements = explode(';', $sql);

echo "Executing SQL statements...\n";

foreach ($statements as $statement) {
    $statement = trim($statement);
    if (empty($statement) || substr($statement, 0, 2) === '--') {
        continue;
    }
    
    echo "Executing: " . substr($statement, 0, 50) . "...\n";
    
    if (!mysqli_query($con, $statement)) {
        echo "Error: " . mysqli_error($con) . "\n";
    } else {
        echo "Success!\n";
    }
}

echo "Database setup complete!\n";
?>
