<?php
session_start();
include_once('../includes/config.php');

if (!isset($_SESSION['uid'])) {
    header('location:../login.php');
    exit();
}

// Get filter parameters
$payment_status = $_GET['payment_status'] ?? '';
$date_from = $_GET['date_from'] ?? date('Y-m-01');
$date_to = $_GET['date_to'] ?? date('Y-m-t');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Sales Reports - Vegetable Shop</title>

    <!-- Fonts -->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">
    <div id="wrapper">
        <!-- Sidebar -->
        <?php include_once('../includes/sidebar.php'); ?>
        
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <!-- Topbar -->
                <?php include_once('../includes/topbar.php'); ?>
                
                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">
                            <i class="fas fa-chart-line mr-2"></i>Sales Reports
                        </h1>
                    </div>

                    <!-- Filters -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Report Filters</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-3">
                                    <label>Date From</label>
                                    <input type="date" class="form-control" name="date_from" value="<?php echo $date_from; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label>Date To</label>
                                    <input type="date" class="form-control" name="date_to" value="<?php echo $date_to; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label>Payment Status</label>
                                    <select class="form-control" name="payment_status">
                                        <option value="">All Status</option>
                                        <option value="paid" <?php echo $payment_status == 'paid' ? 'selected' : ''; ?>>Paid</option>
                                        <option value="unpaid" <?php echo $payment_status == 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                                        <option value="partial" <?php echo $payment_status == 'partial' ? 'selected' : ''; ?>>Partial</option>
                                    </select>
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search mr-1"></i>Filter
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <?php
                    // Build query based on filters
                    $whereClause = "WHERE si.status = 'active'";
                    $params = [];
                    
                    if ($date_from) {
                        $whereClause .= " AND si.invoice_date >= ?";
                        $params[] = $date_from;
                    }
                    
                    if ($date_to) {
                        $whereClause .= " AND si.invoice_date <= ?";
                        $params[] = $date_to;
                    }
                    
                    if ($payment_status) {
                        $whereClause .= " AND si.payment_status = ?";
                        $params[] = $payment_status;
                    }

                    // Get summary statistics
                    try {
                        $stmt = $pdo->prepare("
                            SELECT 
                                COUNT(*) as total_invoices,
                                SUM(total_amount) as total_sales,
                                SUM(cash_received + upi_received) as total_received,
                                SUM(balance_amount) as total_pending
                            FROM sales_invoices si 
                            $whereClause
                        ");
                        $stmt->execute($params);
                        $summary = $stmt->fetch(PDO::FETCH_ASSOC);
                    ?>

                    <!-- Summary Cards -->
                    <div class="row">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                Total Invoices</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo number_format($summary['total_invoices']); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-file-invoice fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                Total Sales</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                ₹<?php echo number_format($summary['total_sales'], 2); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                                Amount Received</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                ₹<?php echo number_format($summary['total_received'], 2); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                Pending Amount</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                ₹<?php echo number_format($summary['total_pending'], 2); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sales Data Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Sales Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Invoice No</th>
                                            <th>Date</th>
                                            <th>Customer</th>
                                            <th>Total Amount</th>
                                            <th>Cash Received</th>
                                            <th>UPI Received</th>
                                            <th>Balance</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $stmt = $pdo->prepare("
                                            SELECT 
                                                si.id, si.invoice_no, si.invoice_date, si.customer_name,
                                                si.total_amount, si.cash_received, si.upi_received, 
                                                si.balance_amount, si.payment_status
                                            FROM sales_invoices si 
                                            $whereClause
                                            ORDER BY si.invoice_date DESC, si.id DESC
                                        ");
                                        $stmt->execute($params);
                                        $invoices = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                        
                                        foreach ($invoices as $invoice) {
                                            $statusClass = '';
                                            switch($invoice['payment_status']) {
                                                case 'paid': $statusClass = 'badge-success'; break;
                                                case 'partial': $statusClass = 'badge-warning'; break;
                                                case 'unpaid': $statusClass = 'badge-danger'; break;
                                            }
                                            
                                            echo "<tr>";
                                            echo "<td>" . htmlspecialchars($invoice['invoice_no']) . "</td>";
                                            echo "<td>" . date('d/m/Y', strtotime($invoice['invoice_date'])) . "</td>";
                                            echo "<td>" . htmlspecialchars($invoice['customer_name']) . "</td>";
                                            echo "<td>₹" . number_format($invoice['total_amount'], 2) . "</td>";
                                            echo "<td>₹" . number_format($invoice['cash_received'], 2) . "</td>";
                                            echo "<td>₹" . number_format($invoice['upi_received'], 2) . "</td>";
                                            echo "<td>₹" . number_format($invoice['balance_amount'], 2) . "</td>";
                                            echo "<td><span class='badge {$statusClass}'>" . ucfirst($invoice['payment_status']) . "</span></td>";
                                            echo "<td>
                                                    <a href='print_invoice.php?id={$invoice['id']}' class='btn btn-sm btn-info' target='_blank'>
                                                        <i class='fas fa-print'></i>
                                                    </a>
                                                  </td>";
                                            echo "</tr>";
                                        }
                                    } catch (Exception $e) {
                                        echo "Error: " . $e->getMessage();
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Footer -->
            <?php include_once('../includes/footer.php'); ?>
        </div>
    </div>

    <!-- Scripts -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "order": [[ 1, "desc" ]],
                "pageLength": 25
            });
        });
    </script>
</body>
</html>
