<?php
header('Content-Type: application/json');
include_once('../../includes/config.php');

$response = ['success' => false, 'customers' => []];

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $query = trim($input['query'] ?? '');
    
    if (strlen($query) >= 2) {
        $sql = "SELECT id, customer_name, phone, email, address, gst_number, 
                       credit_limit, outstanding_balance 
                FROM customers 
                WHERE (customer_name LIKE ? OR phone LIKE ? OR customer_code LIKE ? OR gst_number LIKE ?) 
                AND status = 'active'
                ORDER BY customer_name 
                LIMIT 10";
        
        $searchTerm = '%' . $query . '%';
        $stmt = $con->prepare($sql);
        $stmt->bind_param('ssss', $searchTerm, $searchTerm, $searchTerm, $searchTerm);
        $stmt->execute();
        $result = $stmt->get_result();
        
        $customers = [];
        while ($row = $result->fetch_assoc()) {
            $customers[] = $row;
        }
        
        $response['success'] = true;
        $response['customers'] = $customers;
    }
    
} catch (Exception $e) {
    $response['message'] = 'Error searching customers: ' . $e->getMessage();
}

echo json_encode($response);
?>
