<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        echo json_encode(['success' => false, 'message' => 'Invalid JSON data']);
        exit();
    }
    
    // Generate hold number
    $holdNumberQuery = "SELECT COALESCE(MAX(CAST(SUBSTRING(hold_number, 6) AS UNSIGNED)), 0) + 1 as next_num FROM bill_holds WHERE hold_number LIKE 'HOLD-%'";
    $result = mysqli_query($con, $holdNumberQuery);
    $nextNum = 1;
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $nextNum = $row['next_num'];
    }
    $holdNumber = 'HOLD-' . str_pad($nextNum, 3, '0', STR_PAD_LEFT);
    
    // Convert amounts to integers (remove decimals)
    $subtotal = intval(round(floatval($input['subtotal'] ?? 0)));
    $discountAmount = intval(round(floatval($input['discount_amount'] ?? 0)));
    $totalAmount = intval(round(floatval($input['total_amount'] ?? 0)));
    $cashTender = intval(round(floatval($input['cash_tender_received'] ?? 0)));
    $upiAmount = intval(round(floatval($input['upi_amount'] ?? 0)));
    $cashChange = intval(round(floatval($input['cash_change'] ?? 0)));
    
    // Insert into bill_holds table
    $insertQuery = "INSERT INTO bill_holds 
        (hold_number, customer_name, customer_phone, customer_address, customer_gst,
         subtotal, discount_percent, discount_amount, total_amount, 
         payment_mode, cash_tender_received, upi_amount, cash_change, 
         notes, invoice_type, credit_days, rate_type, created_by) 
        VALUES (
            '" . mysqli_real_escape_string($con, $holdNumber) . "',
            '" . mysqli_real_escape_string($con, $input['customer_name'] ?? '') . "',
            '" . mysqli_real_escape_string($con, $input['customer_phone'] ?? '') . "',
            '" . mysqli_real_escape_string($con, $input['customer_address'] ?? '') . "',
            '" . mysqli_real_escape_string($con, $input['customer_gst'] ?? '') . "',
            " . $subtotal . ",
            " . floatval($input['discount_percent'] ?? 0) . ",
            " . $discountAmount . ",
            " . $totalAmount . ",
            '" . mysqli_real_escape_string($con, $input['payment_mode'] ?? 'cash') . "',
            " . $cashTender . ",
            " . $upiAmount . ",
            " . $cashChange . ",
            '" . mysqli_real_escape_string($con, $input['notes'] ?? '') . "',
            '" . mysqli_real_escape_string($con, $input['invoice_type'] ?? 'cash') . "',
            " . (isset($input['credit_days']) ? intval($input['credit_days']) : 'NULL') . ",
            '" . mysqli_real_escape_string($con, $input['rate_type'] ?? 'CustomerRate') . "',
            " . intval($_SESSION['uid']) . "
        )";
    
    if (!mysqli_query($con, $insertQuery)) {
        throw new Exception('Failed to create hold: ' . mysqli_error($con));
    }
    
    $holdId = mysqli_insert_id($con);
    
    // Insert hold items
    if (isset($input['items']) && is_array($input['items'])) {
        foreach ($input['items'] as $item) {
            if (empty($item['code']) || empty($item['product'])) continue;
            
            $itemRate = intval(round(floatval($item['rate'])));
            $itemAmount = intval(round(floatval($item['amount'])));
            
            $itemQuery = "INSERT INTO bill_hold_details 
                (hold_id, product_code, product_name, unit, quantity, rate, amount) 
                VALUES (
                    " . $holdId . ",
                    '" . mysqli_real_escape_string($con, $item['code']) . "',
                    '" . mysqli_real_escape_string($con, $item['product']) . "',
                    '" . mysqli_real_escape_string($con, $item['unit']) . "',
                    " . floatval($item['qty']) . ",
                    " . $itemRate . ",
                    " . $itemAmount . "
                )";
            
            if (!mysqli_query($con, $itemQuery)) {
                throw new Exception('Failed to insert hold item: ' . mysqli_error($con));
            }
        }
    }
    
    echo json_encode([
        'success' => true, 
        'message' => 'Bill held successfully',
        'hold_number' => $holdNumber,
        'hold_id' => $holdId
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
