<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    // Handle both form data and JSON input
    if (!empty($_POST)) {
        $input = $_POST;
    } else {
        $input = json_decode(file_get_contents('php://input'), true);
    }
    
    if (!$input) {
        echo json_encode(['success' => false, 'message' => 'Invalid data']);
        exit();
    }
    
    // Validate required fields
    if (empty($input['customer_name']) || empty($input['customer_code'])) {
        echo json_encode(['success' => false, 'message' => 'Customer name and code are required']);
        exit();
    }
    
    $customer_id = !empty($input['customer_id']) ? intval($input['customer_id']) : 0;
    $customer_code = mysqli_real_escape_string($con, $input['customer_code']);
    $customer_name = mysqli_real_escape_string($con, $input['customer_name']);
    $phone = mysqli_real_escape_string($con, $input['phone'] ?? '');
    $email = mysqli_real_escape_string($con, $input['email'] ?? '');
    $gst_number = mysqli_real_escape_string($con, $input['gst_number'] ?? '');
    $credit_limit = floatval($input['credit_limit'] ?? 0);
    $address = mysqli_real_escape_string($con, $input['address'] ?? '');
    $city = mysqli_real_escape_string($con, $input['city'] ?? '');
    $status = mysqli_real_escape_string($con, $input['status'] ?? 'active');
    
    if ($customer_id > 0) {
        // Update existing customer
        $checkQuery = "SELECT id FROM customers WHERE (customer_code = '$customer_code' OR phone = '$phone') AND id != $customer_id AND phone != ''";
        $checkResult = mysqli_query($con, $checkQuery);
        
        if (mysqli_num_rows($checkResult) > 0) {
            echo json_encode(['success' => false, 'message' => 'Customer code or phone number already exists']);
            exit();
        }
        
        $updateQuery = "UPDATE customers SET 
                        customer_code = '$customer_code',
                        customer_name = '$customer_name',
                        phone = '$phone',
                        email = '$email',
                        gst_number = '$gst_number',
                        credit_limit = $credit_limit,
                        address = '$address',
                        city = '$city',
                        status = '$status',
                        updated_date = NOW()
                        WHERE id = $customer_id";
        
        if (mysqli_query($con, $updateQuery)) {
            echo json_encode([
                'success' => true, 
                'message' => 'Customer updated successfully',
                'customer_id' => $customer_id
            ]);
        } else {
            throw new Exception('Failed to update customer: ' . mysqli_error($con));
        }
        
    } else {
        // Check if customer already exists
        $checkQuery = "SELECT id FROM customers WHERE customer_code = '$customer_code' OR (phone = '$phone' AND phone != '')";
        $checkResult = mysqli_query($con, $checkQuery);
        
        if (mysqli_num_rows($checkResult) > 0) {
            echo json_encode(['success' => false, 'message' => 'Customer with this code or phone number already exists']);
            exit();
        }
        
        // Insert new customer
        $insertQuery = "INSERT INTO customers (customer_code, customer_name, phone, email, gst_number, credit_limit, outstanding_balance, address, city, status, created_by, created_date, updated_date) 
                        VALUES (
                            '$customer_code',
                            '$customer_name',
                            '$phone',
                            '$email',
                            '$gst_number',
                            $credit_limit,
                            0.00,
                            '$address',
                            '$city',
                            '$status',
                            " . intval($_SESSION['uid']) . ",
                            NOW(),
                            NOW()
                        )";
        
        if (mysqli_query($con, $insertQuery)) {
            $customerId = mysqli_insert_id($con);
            
            echo json_encode([
                'success' => true, 
                'message' => 'Customer saved successfully',
                'customer_id' => $customerId,
                'customer_code' => $customer_code
            ]);
        } else {
            throw new Exception('Failed to save customer: ' . mysqli_error($con));
        }
    }
    
} catch (Exception $e) {
    error_log("Save customer error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
