<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['hold_id'])) {
        echo json_encode(['success' => false, 'message' => 'Hold ID is required']);
        exit();
    }
    
    $holdId = intval($input['hold_id']);
    
    // Check if hold exists and is active
    $checkQuery = "SELECT id FROM bill_holds WHERE id = $holdId AND status = 'active'";
    $checkResult = mysqli_query($con, $checkQuery);
    
    if (!$checkResult || mysqli_num_rows($checkResult) === 0) {
        echo json_encode(['success' => false, 'message' => 'Hold not found or already released']);
        exit();
    }
    
    // Start transaction
    mysqli_autocommit($con, false);
    
    // Delete hold details first (foreign key constraint)
    $deleteItemsQuery = "DELETE FROM bill_hold_details WHERE hold_id = $holdId";
    if (!mysqli_query($con, $deleteItemsQuery)) {
        throw new Exception('Failed to delete hold details: ' . mysqli_error($con));
    }
    
    // Delete the hold record completely
    $deleteHoldQuery = "DELETE FROM bill_holds WHERE id = $holdId";
    if (!mysqli_query($con, $deleteHoldQuery)) {
        throw new Exception('Failed to release hold: ' . mysqli_error($con));
    }
    
    // Commit transaction
    mysqli_commit($con);
    mysqli_autocommit($con, true);
    
    echo json_encode([
        'success' => true,
        'message' => 'Hold released successfully'
    ]);
    
} catch (Exception $e) {
    // Rollback transaction
    mysqli_rollback($con);
    mysqli_autocommit($con, true);
    
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
