<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['hold_id'])) {
        echo json_encode(['success' => false, 'message' => 'Hold ID is required']);
        exit();
    }
    
    $holdId = intval($input['hold_id']);
    
    // Get hold details
    $holdQuery = "SELECT * FROM bill_holds WHERE id = $holdId AND status = 'active'";
    $holdResult = mysqli_query($con, $holdQuery);
    
    if (!$holdResult || mysqli_num_rows($holdResult) === 0) {
        echo json_encode(['success' => false, 'message' => 'Hold not found']);
        exit();
    }
    
    $hold = mysqli_fetch_assoc($holdResult);
    
    // Get hold items
    $itemsQuery = "SELECT * FROM bill_hold_details WHERE hold_id = $holdId ORDER BY id";
    $itemsResult = mysqli_query($con, $itemsQuery);
    
    $items = [];
    while ($item = mysqli_fetch_assoc($itemsResult)) {
        $items[] = [
            'code' => $item['product_code'],
            'product' => $item['product_name'],
            'unit' => $item['unit'],
            'qty' => floatval($item['quantity']),
            'rate' => intval($item['rate']),
            'amount' => intval($item['amount'])
        ];
    }
    
    // Convert amounts back to display format (still integers)
    $holdData = [
        'hold' => [
            'id' => $hold['id'],
            'hold_number' => $hold['hold_number'],
            'customer_name' => $hold['customer_name'],
            'customer_phone' => $hold['customer_phone'],
            'customer_address' => $hold['customer_address'],
            'customer_gst' => $hold['customer_gst'],
            'subtotal' => intval($hold['subtotal']),
            'discount_percent' => floatval($hold['discount_percent']),
            'discount_amount' => intval($hold['discount_amount']),
            'total_amount' => intval($hold['total_amount']),
            'payment_mode' => $hold['payment_mode'],
            'cash_tender_received' => intval($hold['cash_tender_received']),
            'upi_amount' => intval($hold['upi_amount']),
            'cash_change' => intval($hold['cash_change']),
            'notes' => $hold['notes'],
            'invoice_type' => $hold['invoice_type'],
            'credit_days' => $hold['credit_days'],
            'rate_type' => $hold['rate_type']
        ],
        'items' => $items
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $holdData
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
