<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    $_SESSION['uid'] = 1;
}

if (!$con) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}

try {
    // Get all vegetable codes
    $query = "SELECT * FROM tblvegetables LIMIT 5";
    $result = mysqli_query($con, $query);
    
    $vegetables = [];
    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $vegetables[] = $row;
        }
    }
    
    echo json_encode([
        'success' => true,
        'data' => $vegetables
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>
