<?php
session_start();
if (strlen($_SESSION['uid']) == 0) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

include('../../includes/config.php');

header('Content-Type: application/json');

try {
    // Get form data
    $customer_id = intval($_POST['customer_id']);
    $credit_increase = floatval($_POST['total_amount']);
    $payment_mode = mysqli_real_escape_string($con, $_POST['payment_mode']);
    $reference_no = mysqli_real_escape_string($con, $_POST['reference_no'] ?? '');
    $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');
    $receipt_date = mysqli_real_escape_string($con, $_POST['receipt_date']);
    $created_by = $_SESSION['uid'];
    
    // Validation
    if (empty($customer_id) || $credit_increase <= 0) {
        throw new Exception('Invalid customer or credit amount');
    }
    
    // Get current customer data
    $customerSql = "SELECT customer_name, credit_limit FROM customers WHERE id = $customer_id AND status = 'active'";
    $customerResult = mysqli_query($con, $customerSql);
    
    if (!$customerResult || mysqli_num_rows($customerResult) == 0) {
        throw new Exception('Customer not found');
    }
    
    $customer = mysqli_fetch_assoc($customerResult);
    $current_credit_limit = $customer['credit_limit'];
    $new_credit_limit = $current_credit_limit + $credit_increase;
    
    // Start transaction
    mysqli_autocommit($con, false);
    
    // Update customer credit limit
    $updateCustomerSql = "UPDATE customers SET 
                         credit_limit = $new_credit_limit,
                         updated_date = NOW() 
                         WHERE id = $customer_id";
    
    if (!mysqli_query($con, $updateCustomerSql)) {
        throw new Exception('Failed to update customer credit limit: ' . mysqli_error($con));
    }
    
    // Generate receipt number for credit increase record
    $receiptNoSql = "SELECT COALESCE(MAX(CAST(SUBSTRING(receipt_no, 13) AS UNSIGNED)), 0) + 1 as next_no 
                     FROM payment_receipts 
                     WHERE receipt_no LIKE 'RCP-" . date('Ym') . "-%'";
    $receiptNoResult = mysqli_query($con, $receiptNoSql);
    $receiptNoRow = mysqli_fetch_assoc($receiptNoResult);
    $receiptNo = 'RCP-' . date('Ym') . '-' . str_pad($receiptNoRow['next_no'], 4, '0', STR_PAD_LEFT);
    
    // Insert payment receipt record for credit increase
    $insertReceiptSql = "INSERT INTO payment_receipts (
        receipt_no, receipt_date, customer_id, customer_name, payment_mode,
        cash_amount, upi_amount, cheque_amount, bank_amount, total_amount,
        cheque_no, cheque_date, bank_details, notes, created_by, created_date
    ) VALUES (
        '$receiptNo', '$receipt_date', $customer_id, '" . mysqli_real_escape_string($con, $customer['customer_name']) . "', '$payment_mode',
        0.00, 0.00, 0.00, 0.00, $credit_increase,
        '$reference_no', NULL, '', 'Credit Limit Increase: ₹$credit_increase (From ₹$current_credit_limit to ₹$new_credit_limit). $notes', 
        $created_by, NOW()
    )";
    
    if (!mysqli_query($con, $insertReceiptSql)) {
        throw new Exception('Failed to create receipt record: ' . mysqli_error($con));
    }
    
    // Get current balance from customer ledger
    $balanceSql = "SELECT COALESCE(MAX(balance), 0) as current_balance FROM customer_ledger WHERE customer_id = $customer_id";
    $balanceResult = mysqli_query($con, $balanceSql);
    $balanceRow = mysqli_fetch_assoc($balanceResult);
    $current_balance = $balanceRow['current_balance'];
    $new_balance = $current_balance + $credit_increase;
    
    // Add entry to customer ledger for credit increase
    $ledgerSql = "INSERT INTO customer_ledger (
        customer_id, transaction_date, transaction_type, reference_no, 
        debit_amount, credit_amount, balance, description, created_by, created_date
    ) VALUES (
        $customer_id, '$receipt_date', 'credit_note', '$receiptNo',
        0.00, $credit_increase, $new_balance,
        'Credit Limit Increased by ₹$credit_increase. Reference: $reference_no. $notes',
        $created_by, NOW()
    )";
    
    if (!mysqli_query($con, $ledgerSql)) {
        throw new Exception('Failed to update customer ledger: ' . mysqli_error($con));
    }
    
    // Commit transaction
    mysqli_commit($con);
    
    echo json_encode([
        'success' => true, 
        'message' => 'Credit limit increased successfully',
        'receipt_no' => $receiptNo,
        'old_credit_limit' => $current_credit_limit,
        'new_credit_limit' => $new_credit_limit,
        'credit_increase' => $credit_increase
    ]);
    
} catch (Exception $e) {
    // Rollback transaction
    mysqli_rollback($con);
    
    echo json_encode([
        'success' => false, 
        'message' => $e->getMessage()
    ]);
} finally {
    // Reset autocommit
    mysqli_autocommit($con, true);
}
?>
