<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if (!$con) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}

try {
    $query = "SELECT id, invoice_no, invoice_date, customer_name, total_amount, payment_status, invoice_type,
                     cash_received, upi_received, balance_amount
        FROM sales_invoices 
        WHERE status = 'active' 
        ORDER BY created_date DESC 
        LIMIT 20";
    
    $result = mysqli_query($con, $query);
    
    $sales = [];
    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $sales[] = $row;
        }
    }
    
    echo json_encode(['success' => true, 'data' => $sales]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
