<?php
session_start();
header('Content-Type: application/json');
include_once('../../includes/config.php');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

$response = ['success' => false, 'invoices' => [], 'debug' => []];

try {
    // Handle both JSON and POST data
    $input = null;
    $customerId = 0;
    $customerName = '';
    
    // Get raw input
    $raw_input = file_get_contents('php://input');
    
    if (!empty($raw_input)) {
        $input = json_decode($raw_input, true);
        $customerId = intval($input['customer_id'] ?? 0);
        $customerName = trim($input['customer_name'] ?? '');
    } elseif (!empty($_POST)) {
        $customerId = intval($_POST['customer_id'] ?? 0);
        $customerName = trim($_POST['customer_name'] ?? '');
    }
    
    // Debug information
    $response['debug'] = [
        'customer_id' => $customerId,
        'customer_name' => $customerName,
        'method' => $_SERVER['REQUEST_METHOD'],
        'raw_input' => $raw_input,
        'post_data' => $_POST,
        'json_decoded' => $input
    ];
    
    $invoices = [];
    $total_outstanding = 0;
    
    if ($customerId > 0) {
        // Query by customer ID - simplified and direct
        $sql = "SELECT 
                    id, invoice_no, invoice_date, due_date, 
                    total_amount, balance_amount, payment_status,
                    customer_name
                FROM sales_invoices
                WHERE customer_id = $customerId 
                AND invoice_type = 'credit'
                AND balance_amount > 0
                AND status = 'active'
                ORDER BY invoice_date ASC";
        
        $response['debug']['sql_query'] = $sql;
        
        $result = mysqli_query($con, $sql);
        
        if ($result) {
            while ($row = mysqli_fetch_assoc($result)) {
                $invoices[] = [
                    'id' => intval($row['id']),
                    'invoice_no' => $row['invoice_no'],
                    'invoice_date' => date('d-m-Y', strtotime($row['invoice_date'])),
                    'due_date' => date('d-m-Y', strtotime($row['due_date'])),
                    'total_amount' => floatval($row['total_amount']),
                    'balance_amount' => floatval($row['balance_amount']),
                    'payment_status' => $row['payment_status'],
                    'customer_name' => $row['customer_name']
                ];
                $total_outstanding += floatval($row['balance_amount']);
            }
            $response['debug']['mysql_rows'] = mysqli_num_rows($result);
        } else {
            $response['debug']['mysql_error'] = mysqli_error($con);
        }
        
        $response['debug']['query_type'] = 'by_customer_id';
        $response['debug']['rows_found'] = count($invoices);
        
    } elseif (!empty($customerName)) {
        // Query by customer name for customers without proper customer_id
        $customerName_escaped = mysqli_real_escape_string($con, $customerName);
        $sql = "SELECT id, invoice_no, invoice_date, due_date, total_amount, 
                       balance_amount, payment_status, customer_name
                FROM sales_invoices 
                WHERE customer_name = '$customerName_escaped'
                AND invoice_type = 'credit'
                AND balance_amount > 0
                AND status = 'active'
                ORDER BY invoice_date ASC";
        
        $response['debug']['sql_query'] = $sql;
        
        $result = mysqli_query($con, $sql);
        
        if ($result) {
            while ($row = mysqli_fetch_assoc($result)) {
                $invoices[] = [
                    'id' => intval($row['id']),
                    'invoice_no' => $row['invoice_no'],
                    'invoice_date' => date('d-m-Y', strtotime($row['invoice_date'])),
                    'due_date' => date('d-m-Y', strtotime($row['due_date'])),
                    'total_amount' => floatval($row['total_amount']),
                    'balance_amount' => floatval($row['balance_amount']),
                    'payment_status' => $row['payment_status'],
                    'customer_name' => $row['customer_name']
                ];
                $total_outstanding += floatval($row['balance_amount']);
            }
            $response['debug']['mysql_rows'] = mysqli_num_rows($result);
        } else {
            $response['debug']['mysql_error'] = mysqli_error($con);
        }
        
        $response['debug']['query_type'] = 'by_customer_name';
        $response['debug']['rows_found'] = count($invoices);
        
    } else {
        $response['debug']['query_type'] = 'no_valid_criteria';
        $response['message'] = 'No valid customer ID or customer name provided';
    }
    
    $response['success'] = true;
    $response['invoices'] = $invoices;
    $response['summary'] = [
        'total_outstanding' => $total_outstanding,
        'invoice_count' => count($invoices)
    ];
    
} catch (Exception $e) {
    $response['message'] = 'Error loading outstanding invoices: ' . $e->getMessage();
    $response['debug']['error'] = $e->getMessage();
}

echo json_encode($response);
?>
