<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

if (!$con) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}

try {
    $invoiceId = intval($_POST['invoice_id']);
    
    if (!$invoiceId) {
        echo json_encode(['success' => false, 'message' => 'Invalid invoice ID']);
        exit();
    }
    
    // Get invoice data
    $invoiceQuery = "SELECT * FROM sales_invoices WHERE id = " . $invoiceId;
    $invoiceResult = mysqli_query($con, $invoiceQuery);
    
    if (!$invoiceResult || mysqli_num_rows($invoiceResult) == 0) {
        echo json_encode(['success' => false, 'message' => 'Invoice not found']);
        exit();
    }
    
    $invoice = mysqli_fetch_assoc($invoiceResult);
    
    // Get invoice items
    $itemsQuery = "SELECT * FROM sales_invoice_details WHERE invoice_id = " . $invoiceId . " ORDER BY id";
    $itemsResult = mysqli_query($con, $itemsQuery);
    
    $items = [];
    if ($itemsResult) {
        while ($row = mysqli_fetch_assoc($itemsResult)) {
            $items[] = $row;
        }
    }
    
    echo json_encode([
        'success' => true, 
        'data' => [
            'invoice' => $invoice,
            'items' => $items
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
