<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

try {
    // Get active holds
    $query = "SELECT bh.*, 
                     COUNT(bhd.id) as item_count,
                     DATE_FORMAT(bh.hold_date, '%d %b %Y %H:%i') as formatted_date
              FROM bill_holds bh 
              LEFT JOIN bill_hold_details bhd ON bh.id = bhd.hold_id
              WHERE bh.status = 'active' 
              GROUP BY bh.id 
              ORDER BY bh.hold_date DESC";
    
    $result = mysqli_query($con, $query);
    
    if (!$result) {
        throw new Exception('Query failed: ' . mysqli_error($con));
    }
    
    $holds = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $holds[] = [
            'id' => $row['id'],
            'hold_number' => $row['hold_number'],
            'customer_name' => $row['customer_name'] ?: 'Walk-in Customer',
            'customer_phone' => $row['customer_phone'],
            'total_amount' => intval($row['total_amount']),
            'item_count' => intval($row['item_count']),
            'hold_date' => $row['formatted_date'],
            'payment_mode' => $row['payment_mode'],
            'invoice_type' => $row['invoice_type'],
            'notes' => $row['notes']
        ];
    }
    
    echo json_encode([
        'success' => true,
        'data' => $holds,
        'count' => count($holds)
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
