<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['customer_id'])) {
        echo json_encode(['success' => false, 'message' => 'Customer ID is required']);
        exit();
    }
    
    $customer_id = intval($input['customer_id']);
    
    // Get customer details
    $customer_query = "SELECT * FROM customers WHERE id = $customer_id";
    $customer_result = mysqli_query($con, $customer_query);
    
    if (!$customer_result || mysqli_num_rows($customer_result) == 0) {
        echo json_encode(['success' => false, 'message' => 'Customer not found']);
        exit();
    }
    
    $customer = mysqli_fetch_assoc($customer_result);
    
    // Get customer ledger summary
    $ledger_query = "SELECT 
        SUM(CASE WHEN transaction_type = 'invoice' THEN debit_amount ELSE 0 END) as total_invoices,
        SUM(CASE WHEN transaction_type = 'payment' THEN credit_amount ELSE 0 END) as total_payments,
        SUM(CASE WHEN transaction_type = 'invoice' THEN debit_amount ELSE 0 END) - 
        SUM(CASE WHEN transaction_type = 'payment' THEN credit_amount ELSE 0 END) as outstanding_balance
        FROM customer_ledger WHERE customer_id = $customer_id";
    $ledger_result = mysqli_query($con, $ledger_query);
    $ledger = mysqli_fetch_assoc($ledger_result);
    
    // Get recent transactions
    $transactions_query = "SELECT * FROM customer_ledger 
                          WHERE customer_id = $customer_id 
                          ORDER BY transaction_date DESC, created_date DESC 
                          LIMIT 10";
    $transactions_result = mysqli_query($con, $transactions_query);
    $transactions = [];
    while ($row = mysqli_fetch_assoc($transactions_result)) {
        $transactions[] = $row;
    }
    
    // Get recent invoices
    $invoices_query = "SELECT invoice_no, invoice_date, invoice_type, total_amount, payment_status 
                      FROM sales_invoices 
                      WHERE customer_id = $customer_id 
                      ORDER BY invoice_date DESC 
                      LIMIT 5";
    $invoices_result = mysqli_query($con, $invoices_query);
    $invoices = [];
    while ($row = mysqli_fetch_assoc($invoices_result)) {
        $invoices[] = $row;
    }
    
    // Build HTML content
    $html = '<div class="row">
        <div class="col-md-6">
            <h6><i class="fas fa-user mr-2"></i>Customer Information</h6>
            <table class="table table-sm">
                <tr><td><strong>Code:</strong></td><td>' . htmlspecialchars($customer['customer_code']) . '</td></tr>
                <tr><td><strong>Name:</strong></td><td>' . htmlspecialchars($customer['customer_name']) . '</td></tr>
                <tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($customer['phone'] ?: 'N/A') . '</td></tr>
                <tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($customer['email'] ?: 'N/A') . '</td></tr>
                <tr><td><strong>GST Number:</strong></td><td>' . htmlspecialchars($customer['gst_number'] ?: 'N/A') . '</td></tr>
                <tr><td><strong>Address:</strong></td><td>' . nl2br(htmlspecialchars($customer['address'] ?: 'N/A')) . '</td></tr>
                <tr><td><strong>City:</strong></td><td>' . htmlspecialchars($customer['city'] ?: 'N/A') . '</td></tr>
                <tr><td><strong>Status:</strong></td><td><span class="badge badge-' . ($customer['status'] == 'active' ? 'success' : 'danger') . '">' . ucfirst($customer['status']) . '</span></td></tr>
                <tr><td><strong>Created:</strong></td><td>' . date('d M Y', strtotime($customer['created_date'])) . '</td></tr>
            </table>
        </div>
        <div class="col-md-6">
            <h6><i class="fas fa-chart-line mr-2"></i>Financial Summary</h6>
            <table class="table table-sm">
                <tr><td><strong>Credit Limit:</strong></td><td>₹' . number_format($customer['credit_limit'], 2) . '</td></tr>
                <tr><td><strong>Total Invoices:</strong></td><td>₹' . number_format($ledger['total_invoices'] ?: 0, 2) . '</td></tr>
                <tr><td><strong>Total Payments:</strong></td><td>₹' . number_format($ledger['total_payments'] ?: 0, 2) . '</td></tr>
                <tr><td><strong>Outstanding:</strong></td><td class="' . (($ledger['outstanding_balance'] ?: 0) > 0 ? 'text-danger' : 'text-success') . '"><strong>₹' . number_format($ledger['outstanding_balance'] ?: 0, 2) . '</strong></td></tr>
            </table>
        </div>
    </div>';
    
    if (!empty($invoices)) {
        $html .= '<div class="row mt-3">
            <div class="col-12">
                <h6><i class="fas fa-file-invoice mr-2"></i>Recent Invoices</h6>
                <div class="table-responsive">
                    <table class="table table-sm table-striped">
                        <thead>
                            <tr>
                                <th>Invoice No</th>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>';
        
        foreach ($invoices as $invoice) {
            $status_class = $invoice['payment_status'] == 'paid' ? 'success' : 'warning';
            $html .= '<tr>
                <td>' . htmlspecialchars($invoice['invoice_no']) . '</td>
                <td>' . date('d M Y', strtotime($invoice['invoice_date'])) . '</td>
                <td>' . ucfirst($invoice['invoice_type']) . '</td>
                <td>₹' . number_format($invoice['total_amount'], 2) . '</td>
                <td><span class="badge badge-' . $status_class . '">' . ucfirst($invoice['payment_status']) . '</span></td>
            </tr>';
        }
        
        $html .= '</tbody></table></div></div></div>';
    }
    
    if (!empty($transactions)) {
        $html .= '<div class="row mt-3">
            <div class="col-12">
                <h6><i class="fas fa-history mr-2"></i>Recent Transactions</h6>
                <div class="table-responsive">
                    <table class="table table-sm table-striped">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Reference</th>
                                <th>Debit</th>
                                <th>Credit</th>
                                <th>Balance</th>
                            </tr>
                        </thead>
                        <tbody>';
        
        foreach ($transactions as $transaction) {
            $html .= '<tr>
                <td>' . date('d M Y', strtotime($transaction['transaction_date'])) . '</td>
                <td>' . ucfirst($transaction['transaction_type']) . '</td>
                <td>' . htmlspecialchars($transaction['reference_no']) . '</td>
                <td>' . ($transaction['debit_amount'] > 0 ? '₹' . number_format($transaction['debit_amount'], 2) : '-') . '</td>
                <td>' . ($transaction['credit_amount'] > 0 ? '₹' . number_format($transaction['credit_amount'], 2) : '-') . '</td>
                <td>₹' . number_format($transaction['balance'], 2) . '</td>
            </tr>';
        }
        
        $html .= '</tbody></table></div></div></div>';
    }
    
    echo json_encode([
        'success' => true,
        'html' => $html
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error retrieving customer details: ' . $e->getMessage()
    ]);
}
?>
