<?php
header('Content-Type: application/json');
include_once('../../includes/config.php');

$response = ['success' => false, 'message' => ''];

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $year = $input['year'] ?? date('Y');
    $month = $input['month'] ?? date('m');
    
    // Get the last receipt number for this month
    $prefix = "RCP-{$year}{$month}-";
    $sql = "SELECT receipt_no FROM payment_receipts 
            WHERE receipt_no LIKE ? 
            ORDER BY id DESC LIMIT 1";
    
    $stmt = $con->prepare($sql);
    $searchPattern = $prefix . '%';
    $stmt->bind_param('s', $searchPattern);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $nextNumber = 1;
    if ($row = $result->fetch_assoc()) {
        $lastNo = $row['receipt_no'];
        $parts = explode('-', $lastNo);
        if (count($parts) >= 3) {
            $nextNumber = intval($parts[2]) + 1;
        }
    }
    
    $receiptNo = $prefix . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
    
    $response['success'] = true;
    $response['receipt_no'] = $receiptNo;
    
} catch (Exception $e) {
    $response['message'] = 'Error generating receipt number: ' . $e->getMessage();
}

echo json_encode($response);
?>
