<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

try {
    // Generate invoice number
    $date = date('Y-m-d');
    $year = date('Y');
    $month = date('m');
    
    // Get the highest invoice number for this year-month
    $query = "SELECT invoice_no FROM sales_invoices WHERE invoice_no LIKE 'INV-" . $year . $month . "-%' ORDER BY CAST(SUBSTRING(invoice_no, -4) AS UNSIGNED) DESC LIMIT 1";
    $result = mysqli_query($con, $query);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $lastInvoice = mysqli_fetch_assoc($result);
        // Extract number from last invoice
        $lastNumber = (int)substr($lastInvoice['invoice_no'], -4);
        $newNumber = $lastNumber + 1;
    } else {
        $newNumber = 1;
    }
    
    $invoiceNo = 'INV-' . $year . $month . '-' . str_pad($newNumber, 4, '0', STR_PAD_LEFT);
    
    echo json_encode(['success' => true, 'invoice_no' => $invoiceNo]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
