<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

try {
    // Get the next customer code
    $query = "SELECT customer_code FROM customers ORDER BY id DESC LIMIT 1";
    $result = mysqli_query($con, $query);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $lastCustomer = mysqli_fetch_assoc($result);
        $lastCode = $lastCustomer['customer_code'];
        
        // Extract number from code (assuming format like CUST0001)
        if (preg_match('/CUST(\d+)/', $lastCode, $matches)) {
            $nextNumber = intval($matches[1]) + 1;
        } else {
            $nextNumber = 1;
        }
    } else {
        $nextNumber = 1;
    }
    
    // Generate new code
    $customerCode = 'CUST' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
    
    echo json_encode([
        'success' => true,
        'customer_code' => $customerCode
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error generating customer code: ' . $e->getMessage()
    ]);
}
?>
