<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['customer_id'])) {
        echo json_encode(['success' => false, 'message' => 'Customer ID is required']);
        exit();
    }
    
    $customer_id = intval($input['customer_id']);
    
    // Check if customer has transactions
    $check_ledger = "SELECT COUNT(*) as count FROM customer_ledger WHERE customer_id = $customer_id";
    $ledger_result = mysqli_query($con, $check_ledger);
    $ledger_count = mysqli_fetch_assoc($ledger_result)['count'];
    
    $check_invoices = "SELECT COUNT(*) as count FROM sales_invoices WHERE customer_id = $customer_id";
    $invoice_result = mysqli_query($con, $check_invoices);
    $invoice_count = mysqli_fetch_assoc($invoice_result)['count'];
    
    if ($ledger_count > 0 || $invoice_count > 0) {
        echo json_encode([
            'success' => false, 
            'message' => 'Cannot delete customer with existing transactions. Customer has ' . $invoice_count . ' invoices and ' . $ledger_count . ' ledger entries.'
        ]);
        exit();
    }
    
    // Delete customer
    $delete_query = "DELETE FROM customers WHERE id = $customer_id";
    
    if (mysqli_query($con, $delete_query)) {
        echo json_encode([
            'success' => true,
            'message' => 'Customer deleted successfully'
        ]);
    } else {
        throw new Exception('Failed to delete customer: ' . mysqli_error($con));
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error deleting customer: ' . $e->getMessage()
    ]);
}
?>
