<?php
include_once('../../includes/config.php');

// Simple test for outstanding invoices
$customer_id = 1; // Jeganathan

echo "<h3>Debug Outstanding Invoices for Customer ID: $customer_id</h3>";

// Test the exact query from get_outstanding_invoices.php
$sql = "SELECT 
            si.id, si.invoice_no, si.invoice_date, si.due_date, 
            si.total_amount, si.balance_amount, si.payment_status,
            si.customer_name, si.invoice_type
        FROM sales_invoices si
        WHERE si.customer_id = $customer_id 
        AND si.invoice_type = 'credit'
        AND si.balance_amount > 0
        AND si.status = 'active'
        ORDER BY si.invoice_date ASC";

echo "<h4>SQL Query:</h4>";
echo "<pre>$sql</pre>";

$result = mysqli_query($con, $sql);

if ($result) {
    echo "<h4>Query Results:</h4>";
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>Invoice No</th><th>Date</th><th>Due Date</th><th>Total</th><th>Balance</th><th>Status</th><th>Customer</th><th>Type</th></tr>";
    
    $found = false;
    while ($row = mysqli_fetch_assoc($result)) {
        $found = true;
        echo "<tr>";
        echo "<td>{$row['id']}</td>";
        echo "<td>{$row['invoice_no']}</td>";
        echo "<td>{$row['invoice_date']}</td>";
        echo "<td>{$row['due_date']}</td>";
        echo "<td>{$row['total_amount']}</td>";
        echo "<td>{$row['balance_amount']}</td>";
        echo "<td>{$row['payment_status']}</td>";
        echo "<td>{$row['customer_name']}</td>";
        echo "<td>{$row['invoice_type']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    if (!$found) {
        echo "<p style='color: red;'>No outstanding invoices found!</p>";
        
        // Let's check what invoices exist for this customer
        echo "<h4>All invoices for customer $customer_id:</h4>";
        $all_sql = "SELECT * FROM sales_invoices WHERE customer_id = $customer_id";
        $all_result = mysqli_query($con, $all_sql);
        
        if ($all_result) {
            echo "<table border='1' style='border-collapse: collapse;'>";
            echo "<tr><th>ID</th><th>Invoice No</th><th>Type</th><th>Total</th><th>Balance</th><th>Status</th><th>Payment Status</th></tr>";
            
            while ($row = mysqli_fetch_assoc($all_result)) {
                echo "<tr>";
                echo "<td>{$row['id']}</td>";
                echo "<td>{$row['invoice_no']}</td>";
                echo "<td>{$row['invoice_type']}</td>";
                echo "<td>{$row['total_amount']}</td>";
                echo "<td>{$row['balance_amount']}</td>";
                echo "<td>{$row['status']}</td>";
                echo "<td>{$row['payment_status']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    }
} else {
    echo "<p style='color: red;'>Query Error: " . mysqli_error($con) . "</p>";
}

// Test JSON output like the actual endpoint
echo "<h4>JSON Output Test:</h4>";
$json_result = mysqli_query($con, $sql);
$invoices = [];
$total_outstanding = 0;

if ($json_result) {
    while ($row = mysqli_fetch_assoc($json_result)) {
        $invoices[] = [
            'id' => $row['id'],
            'invoice_no' => $row['invoice_no'],
            'invoice_date' => date('d-m-Y', strtotime($row['invoice_date'])),
            'due_date' => date('d-m-Y', strtotime($row['due_date'])),
            'total_amount' => (float)$row['total_amount'],
            'balance_amount' => (float)$row['balance_amount'],
            'payment_status' => $row['payment_status'],
            'customer_name' => $row['customer_name']
        ];
        $total_outstanding += (float)$row['balance_amount'];
    }
}

$response = [
    'success' => true,
    'invoices' => $invoices,
    'summary' => [
        'total_outstanding' => $total_outstanding,
        'invoice_count' => count($invoices)
    ],
    'debug' => [
        'customer_id' => $customer_id,
        'query_type' => 'debug_test',
        'rows_found' => count($invoices)
    ]
];

echo "<pre>" . json_encode($response, JSON_PRETTY_PRINT) . "</pre>";
?>
