# Sales Management System - Setup Instructions

## Database Setup

1. **Execute the SQL file to create tables:**
   - Open phpMyAdmin or your MySQL client
   - Run the SQL commands from `sales/create_tables.sql`
   - This will create the following tables:
     - `customers`
     - `sales_invoices`
     - `sales_invoice_details`
     - `payment_history`

## Features

### 1. Sales Interface (VB.NET DataGridView Style)
- **Grid Navigation**: Use Enter key to move between cells
- **Product Code Entry**: Enter product code and press Enter to auto-fill product details
- **Quantity & Rate Entry**: Enter values and press Enter to calculate amount
- **Auto Row Addition**: Automatically adds new row when entering data in last row

### 2. Customer Management
- **Customer Selection**: Choose from existing customers or add new customer details
- **Customer Information**: Name, phone, address fields
- **Walk-in Customers**: Support for customers without detailed information

### 3. Invoice Features
- **Auto Invoice Numbering**: Format: INV-YYYYMM-0001
- **Real-time Calculations**: Subtotal, discount, tax, and total amount
- **Save & Print**: Save invoice and automatically open print preview
- **Edit Invoices**: Load existing invoices for modifications

### 4. Payment Management
- **Payment Status**: Unpaid, Partial, Paid
- **Multiple Payment Methods**: Cash and UPI support
- **Payment History**: Track all payment transactions

### 5. Reports & Analytics
- **Invoice Management**: View all invoices with filters
- **Sales Reports**: Date-wise and status-wise reporting
- **Pending Payments**: Quick access to unpaid invoices
- **Print Invoices**: Professional invoice printing

## File Structure

```
sales/
├── index.php              # Main sales interface
├── invoices.php           # Invoice management
├── reports.php            # Sales reports
├── print_invoice.php      # Invoice printing
├── create_tables.sql      # Database schema
├── css/
│   └── sales.css          # Sales-specific styles
├── js/
│   └── sales.js           # Sales functionality
└── ajax/
    ├── get_product.php    # Product lookup
    ├── get_customers.php  # Customer data
    ├── save_invoice.php   # Save/update invoices
    ├── get_recent_sales.php # Recent sales list
    ├── get_invoice.php    # Load invoice for editing
    └── generate_invoice_no.php # Invoice numbering
```

## Usage Instructions

### Creating a New Sale

1. **Open Sales Interface**: Navigate to Sales Management > New Sale
2. **Select/Enter Customer**: Choose existing customer or enter new customer details
3. **Add Products**:
   - Enter product code in first row
   - Press Enter to auto-fill product name, unit, and rate
   - Enter quantity and press Enter
   - Enter/modify rate if needed and press Enter
   - System automatically adds new row for next product
4. **Apply Discounts/Taxes**: Enter percentage values in summary section
5. **Add Notes**: Optional notes for the invoice
6. **Save Invoice**: Click Save to store and auto-print

### Editing Invoices

1. **Click Edit Icon**: In Recent Sales panel or Invoice Management
2. **Modify Details**: Update customer info, products, quantities, etc.
3. **Save Changes**: Updated invoice overwrites previous version

### Key Shortcuts

- **Enter**: Move to next cell/field in sales grid
- **Tab**: Alternative navigation method
- **Ctrl+S**: Save invoice (when implemented)
- **Ctrl+P**: Print invoice (when implemented)

## Technical Features

### Database Design
- **Normalized Structure**: Separate tables for invoices and invoice details
- **Payment Tracking**: Complete payment history with multiple methods
- **Data Integrity**: Foreign keys and constraints for data consistency

### Frontend Features
- **Responsive Design**: Works on desktop and tablet devices
- **Real-time Calculations**: Instant total updates
- **Ajax Operations**: Smooth data operations without page refresh
- **Print Optimization**: Clean invoice printing layout

### Security Features
- **Session Management**: User authentication required
- **SQL Injection Protection**: Prepared statements used throughout
- **Input Validation**: Client and server-side validation
- **Access Control**: User role-based access (admin features)

## Customization

### Adding Custom Fields
1. **Database**: Add columns to relevant tables
2. **Interface**: Update forms in index.php
3. **Processing**: Modify save_invoice.php to handle new fields
4. **Reports**: Update reports.php to display new data

### Styling Changes
- Modify `sales/css/sales.css` for visual customizations
- Bootstrap classes available for quick styling
- Print styles in separate section for invoice printing

### Business Logic
- Tax calculations in `sales.js` updateTotals() function
- Discount logic can be modified for different discount types
- Payment processing logic in `process_payment.php`

## Troubleshooting

### Common Issues

1. **Products Not Loading**: Check vegetable_master table has data with proper product_code field
2. **Calculations Not Working**: Ensure JavaScript is enabled and no console errors
3. **Print Issues**: Check print_invoice.php file permissions and database connection
4. **Payment Status Not Updating**: Verify payment_history table structure

### Performance Optimization
- **Database Indexes**: Already created for common query fields
- **Ajax Caching**: Implement client-side caching for product/customer data
- **Pagination**: Large datasets automatically paginated in DataTables

## Future Enhancements

1. **Barcode Scanning**: Integrate barcode scanner for product entry
2. **Mobile App**: Responsive mobile interface for sales on-the-go
3. **Inventory Integration**: Real-time stock updates with sales
4. **Advanced Reports**: Graphical charts and analytics
5. **Export Features**: Excel/PDF export for reports
6. **Email Integration**: Automatic invoice emailing to customers
