<?php
session_start();
include_once('../includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:../logout.php');
    exit();
}

// Handle CSV Export
if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    $category = $_GET['category'] ?? '';
    $stock_status = $_GET['stock_status'] ?? '';
    
    // Build query for export
    $query = "SELECT 
                vm.id,
                vm.vegetable_name,
                vm.category,
                vm.unit,
                vm.current_stock,
                vm.min_stock_level,
                vm.max_stock_level,
                vm.current_rate,
                vm.last_purchase_rate,
                vm.last_updated,
                vm.status,
                CASE 
                    WHEN vm.current_stock <= 0 THEN 'Out of Stock'
                    WHEN vm.current_stock <= vm.min_stock_level THEN 'Low Stock'
                    WHEN vm.current_stock >= vm.max_stock_level THEN 'Overstock'
                    ELSE 'Good Stock'
                END as stock_status,
                (vm.current_stock * vm.current_rate) as stock_value,
                ROUND(((vm.current_rate - vm.last_purchase_rate) / vm.last_purchase_rate * 100), 2) as margin_percentage
              FROM vegetables_master vm
              WHERE vm.status = 'active'";
    
    $conditions = [];
    if ($category) $conditions[] = "vm.category = '$category'";
    if ($stock_status) {
        switch($stock_status) {
            case 'out_of_stock': $conditions[] = "vm.current_stock <= 0"; break;
            case 'low_stock': $conditions[] = "vm.current_stock > 0 AND vm.current_stock <= vm.min_stock_level"; break;
            case 'good_stock': $conditions[] = "vm.current_stock > vm.min_stock_level AND vm.current_stock < vm.max_stock_level"; break;
            case 'overstock': $conditions[] = "vm.current_stock >= vm.max_stock_level"; break;
        }
    }
    
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }
    
    $query .= " ORDER BY vm.vegetable_name";
    $result = mysqli_query($con, $query);
    
    // Generate CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="inventory_status_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['ID', 'Vegetable Name', 'Category', 'Unit', 'Current Stock', 'Min Level', 'Max Level', 'Current Rate', 'Last Purchase Rate', 'Stock Status', 'Stock Value', 'Margin %', 'Last Updated']);
    
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, [
            $row['id'],
            $row['vegetable_name'],
            $row['category'],
            $row['unit'],
            $row['current_stock'],
            $row['min_stock_level'],
            $row['max_stock_level'],
            $row['current_rate'],
            $row['last_purchase_rate'],
            $row['stock_status'],
            $row['stock_value'],
            $row['margin_percentage'],
            $row['last_updated']
        ]);
    }
    
    fclose($output);
    exit();
}

// Get filter values
$category = $_GET['category'] ?? '';
$stock_status = $_GET['stock_status'] ?? '';

// Build main query
$query = "SELECT 
            vm.id,
            vm.vegetable_name,
            vm.category,
            vm.unit,
            vm.current_stock,
            vm.min_stock_level,
            vm.max_stock_level,
            vm.current_rate,
            vm.last_purchase_rate,
            vm.last_updated,
            vm.status,
            CASE 
                WHEN vm.current_stock <= 0 THEN 'Out of Stock'
                WHEN vm.current_stock <= vm.min_stock_level THEN 'Low Stock'
                WHEN vm.current_stock >= vm.max_stock_level THEN 'Overstock'
                ELSE 'Good Stock'
            END as stock_status,
            (vm.current_stock * vm.current_rate) as stock_value,
            ROUND(((vm.current_rate - vm.last_purchase_rate) / vm.last_purchase_rate * 100), 2) as margin_percentage
          FROM vegetables_master vm
          WHERE vm.status = 'active'";

$conditions = [];
if ($category) $conditions[] = "vm.category = '$category'";
if ($stock_status) {
    switch($stock_status) {
        case 'out_of_stock': $conditions[] = "vm.current_stock <= 0"; break;
        case 'low_stock': $conditions[] = "vm.current_stock > 0 AND vm.current_stock <= vm.min_stock_level"; break;
        case 'good_stock': $conditions[] = "vm.current_stock > vm.min_stock_level AND vm.current_stock < vm.max_stock_level"; break;
        case 'overstock': $conditions[] = "vm.current_stock >= vm.max_stock_level"; break;
    }
}

if (!empty($conditions)) {
    $query .= " AND " . implode(" AND ", $conditions);
}

$query .= " ORDER BY 
            CASE 
                WHEN vm.current_stock <= 0 THEN 1
                WHEN vm.current_stock <= vm.min_stock_level THEN 2
                WHEN vm.current_stock >= vm.max_stock_level THEN 3
                ELSE 4
            END,
            vm.vegetable_name";

$result = mysqli_query($con, $query);

// Get categories for filter dropdown
$categories = mysqli_query($con, "SELECT DISTINCT category FROM vegetables_master WHERE status = 'active' ORDER BY category");

// Get summary statistics
$summary_query = "SELECT 
                    COUNT(*) as total_items,
                    SUM(CASE WHEN current_stock <= 0 THEN 1 ELSE 0 END) as out_of_stock_count,
                    SUM(CASE WHEN current_stock > 0 AND current_stock <= min_stock_level THEN 1 ELSE 0 END) as low_stock_count,
                    SUM(CASE WHEN current_stock >= max_stock_level THEN 1 ELSE 0 END) as overstock_count,
                    SUM(current_stock * current_rate) as total_inventory_value,
                    AVG(((current_rate - last_purchase_rate) / last_purchase_rate * 100)) as avg_margin
                  FROM vegetables_master 
                  WHERE status = 'active'";

if (!empty($conditions)) {
    $summary_query .= " AND " . implode(" AND ", $conditions);
}

$summary = mysqli_fetch_assoc(mysqli_query($con, $summary_query));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Inventory Status Report | Vegetable Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .card { border: none !important; box-shadow: none !important; }
            .card-body { padding: 0 !important; }
            body { font-size: 12px !important; }
            .table th, .table td { padding: 0.3rem !important; }
            
            /* 3-inch printer styles */
            @page { size: 80mm auto; margin: 5mm; }
            body { width: 70mm; font-size: 10px; }
            .table { font-size: 9px; }
            .card-header { font-size: 11px; }
        }
        
        .out-of-stock { background-color: #f8d7da !important; }
        .low-stock { background-color: #fff3cd !important; }
        .overstock { background-color: #d1ecf1 !important; }
        .good-stock { background-color: #d4edda !important; }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('../includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('../includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4 no-print">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-boxes mr-2 text-info"></i>Inventory Status Report
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="index.php">Reports</a></li>
                                <li class="breadcrumb-item active">Inventory Status</li>
                            </ol>
                        </nav>
                    </div>

                    <!-- Filters Card -->
                    <div class="card shadow mb-4 no-print">
                        <div class="card-header py-3 bg-info text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-filter mr-2"></i>Filters & Export</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-4">
                                    <label for="category" class="form-label">Category</label>
                                    <select class="form-control" id="category" name="category">
                                        <option value="">All Categories</option>
                                        <?php while($cat = mysqli_fetch_assoc($categories)) { ?>
                                        <option value="<?php echo $cat['category']; ?>" <?php echo $category == $cat['category'] ? 'selected' : ''; ?>><?php echo $cat['category']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="stock_status" class="form-label">Stock Status</label>
                                    <select class="form-control" id="stock_status" name="stock_status">
                                        <option value="">All Status</option>
                                        <option value="out_of_stock" <?php echo $stock_status == 'out_of_stock' ? 'selected' : ''; ?>>Out of Stock</option>
                                        <option value="low_stock" <?php echo $stock_status == 'low_stock' ? 'selected' : ''; ?>>Low Stock</option>
                                        <option value="good_stock" <?php echo $stock_status == 'good_stock' ? 'selected' : ''; ?>>Good Stock</option>
                                        <option value="overstock" <?php echo $stock_status == 'overstock' ? 'selected' : ''; ?>>Overstock</option>
                                    </select>
                                </div>
                                <div class="col-md-4 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2"><i class="fas fa-search mr-1"></i>Filter</button>
                                    <a href="?" class="btn btn-secondary mr-2"><i class="fas fa-refresh mr-1"></i>Reset</a>
                                    <div class="dropdown">
                                        <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown">
                                            <i class="fas fa-download mr-1"></i>Export
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="?<?php echo http_build_query(array_merge($_GET, ['export' => 'csv'])); ?>">
                                                <i class="fas fa-file-csv mr-1"></i>Export to CSV
                                            </a>
                                            <a class="dropdown-item" href="javascript:window.print()">
                                                <i class="fas fa-print mr-1"></i>Print Report
                                            </a>
                                            <a class="dropdown-item" href="print_thermal_report.php?<?php echo http_build_query(array_merge($_GET, ['report_type' => 'inventory_status', 'title' => 'Inventory Status Report'])); ?>" target="_blank">
                                                <i class="fas fa-receipt mr-1"></i>3" Thermal Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Items</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $summary['total_items'] ?? 0; ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-boxes fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Inventory Value</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_inventory_value'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Low Stock Items</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $summary['low_stock_count'] ?? 0; ?></div>
                                            <div class="text-xs text-muted">Need restocking</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-danger shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Out of Stock</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $summary['out_of_stock_count'] ?? 0; ?></div>
                                            <div class="text-xs text-muted">Immediate action</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Alert for Critical Stock -->
                    <?php if(($summary['out_of_stock_count'] ?? 0) > 0 || ($summary['low_stock_count'] ?? 0) > 0) { ?>
                    <div class="alert alert-warning alert-dismissible fade show no-print" role="alert">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <strong>Stock Alert!</strong> 
                        <?php if($summary['out_of_stock_count'] > 0) { ?>
                            <?php echo $summary['out_of_stock_count']; ?> items are out of stock.
                        <?php } ?>
                        <?php if($summary['low_stock_count'] > 0) { ?>
                            <?php echo $summary['low_stock_count']; ?> items are running low.
                        <?php } ?>
                        Please restock immediately to avoid sales loss.
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <?php } ?>

                    <!-- Inventory Status Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-gradient-info text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-table mr-2"></i>Inventory Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="dataTable">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Vegetable</th>
                                            <th>Category</th>
                                            <th>Current Stock</th>
                                            <th>Min Level</th>
                                            <th>Max Level</th>
                                            <th>Current Rate</th>
                                            <th>Stock Value</th>
                                            <th>Status</th>
                                            <th>Margin %</th>
                                            <th class="no-print">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $total_inventory_value = 0;
                                        
                                        while($row = mysqli_fetch_assoc($result)) { 
                                            $total_inventory_value += $row['stock_value'];
                                            
                                            // Determine row class based on stock status
                                            $row_class = '';
                                            $status_badge = '';
                                            switch($row['stock_status']) {
                                                case 'Out of Stock':
                                                    $row_class = 'out-of-stock';
                                                    $status_badge = 'badge-danger';
                                                    break;
                                                case 'Low Stock':
                                                    $row_class = 'low-stock';
                                                    $status_badge = 'badge-warning';
                                                    break;
                                                case 'Overstock':
                                                    $row_class = 'overstock';
                                                    $status_badge = 'badge-info';
                                                    break;
                                                default:
                                                    $row_class = 'good-stock';
                                                    $status_badge = 'badge-success';
                                            }
                                        ?>
                                        <tr class="<?php echo $row_class; ?>">
                                            <td>
                                                <strong><?php echo htmlspecialchars($row['vegetable_name']); ?></strong>
                                                <div class="text-muted small">Updated: <?php echo date('d-m-Y', strtotime($row['last_updated'])); ?></div>
                                            </td>
                                            <td><span class="badge badge-primary"><?php echo htmlspecialchars($row['category']); ?></span></td>
                                            <td>
                                                <strong><?php echo number_format($row['current_stock'], 2); ?></strong> <?php echo $row['unit']; ?>
                                            </td>
                                            <td class="text-warning"><?php echo number_format($row['min_stock_level'], 2); ?> <?php echo $row['unit']; ?></td>
                                            <td class="text-info"><?php echo number_format($row['max_stock_level'], 2); ?> <?php echo $row['unit']; ?></td>
                                            <td>₹<?php echo number_format($row['current_rate'], 2); ?>/<?php echo $row['unit']; ?></td>
                                            <td>₹<?php echo number_format($row['stock_value'], 2); ?></td>
                                            <td>
                                                <span class="badge <?php echo $status_badge; ?>">
                                                    <?php echo $row['stock_status']; ?>
                                                </span>
                                            </td>
                                            <td>
                                                <?php if($row['margin_percentage'] !== null) { ?>
                                                <span class="badge badge-<?php echo $row['margin_percentage'] > 0 ? 'success' : 'danger'; ?>">
                                                    <?php echo number_format($row['margin_percentage'], 1); ?>%
                                                </span>
                                                <?php } else { ?>
                                                <span class="text-muted">-</span>
                                                <?php } ?>
                                            </td>
                                            <td class="no-print">
                                                <div class="btn-group" role="group">
                                                    <a href="../vegetable-master.php?edit=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary" title="Edit Item">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="../vegetable-rates-editor.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-success" title="Update Rate">
                                                        <i class="fas fa-rupee-sign"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="thead-dark">
                                        <tr>
                                            <th colspan="6">TOTAL INVENTORY VALUE</th>
                                            <th>₹<?php echo number_format($total_inventory_value, 2); ?></th>
                                            <th colspan="3" class="no-print">-</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Stock Management Tips -->
                    <div class="card shadow mb-4 no-print">
                        <div class="card-header py-3 bg-gradient-success text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-lightbulb mr-2"></i>Stock Management Tips</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 class="text-success"><i class="fas fa-check-circle mr-1"></i>Best Practices:</h6>
                                    <ul class="list-unstyled">
                                        <li><i class="fas fa-chevron-right text-success mr-2"></i>Monitor fast-moving items daily</li>
                                        <li><i class="fas fa-chevron-right text-success mr-2"></i>Set appropriate min/max levels</li>
                                        <li><i class="fas fa-chevron-right text-success mr-2"></i>Update rates based on market prices</li>
                                        <li><i class="fas fa-chevron-right text-success mr-2"></i>Track expiry dates for perishables</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6 class="text-info"><i class="fas fa-info-circle mr-1"></i>Status Indicators:</h6>
                                    <ul class="list-unstyled">
                                        <li><span class="badge badge-danger mr-2">Out of Stock</span> Zero inventory - restock immediately</li>
                                        <li><span class="badge badge-warning mr-2">Low Stock</span> Below minimum level - restock soon</li>
                                        <li><span class="badge badge-success mr-2">Good Stock</span> Optimal inventory levels</li>
                                        <li><span class="badge badge-info mr-2">Overstock</span> Above maximum - consider promotions</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('../includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
    <!-- DataTables JavaScript-->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "pageLength": 25,
                "order": [[ 7, "asc" ]], // Sort by status (out of stock first)
                "columnDefs": [
                    { "orderable": false, "targets": -1 }
                ]
            });
        });
    </script>
</body>
</html>
