<?php
session_start();
include_once('../includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:../logout.php');
    exit();
}

// Handle CSV Export
if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    $from_date = $_GET['from_date'] ?? '';
    $to_date = $_GET['to_date'] ?? '';
    
    // Build query for export
    $query = "SELECT 
                si.invoice_date,
                COUNT(si.id) as total_invoices,
                SUM(si.total_amount) as total_sales,
                SUM(si.cash_received) as total_cash,
                SUM(si.upi_received) as total_upi,
                SUM(si.balance_amount) as total_balance,
                AVG(si.total_amount) as avg_order_value,
                COUNT(DISTINCT COALESCE(si.customer_id, CONCAT('walk_', si.customer_name))) as unique_customers,
                (SELECT SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) 
                 FROM sales_invoice_details sid 
                 LEFT JOIN sales_invoices si2 ON sid.invoice_id = si2.id
                 LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
                 WHERE si2.invoice_date = si.invoice_date AND si2.status = 'active') as total_cost,
                (SUM(si.total_amount) - (SELECT SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) 
                 FROM sales_invoice_details sid 
                 LEFT JOIN sales_invoices si2 ON sid.invoice_id = si2.id
                 LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
                 WHERE si2.invoice_date = si.invoice_date AND si2.status = 'active')) as total_profit
              FROM sales_invoices si
              WHERE si.status = 'active'";
    
    $conditions = [];
    if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
    if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
    
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }
    
    $query .= " GROUP BY si.invoice_date ORDER BY si.invoice_date DESC";
    $result = mysqli_query($con, $query);
    
    // Generate CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="daily_summary_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Date', 'Total Invoices', 'Total Sales', 'Cash Received', 'UPI Received', 'Balance Due', 'Avg Order Value', 'Unique Customers', 'Total Cost', 'Total Profit', 'Profit Margin %']);
    
    while ($row = mysqli_fetch_assoc($result)) {
        $profit_margin = $row['total_sales'] > 0 ? (($row['total_profit'] / $row['total_sales']) * 100) : 0;
        fputcsv($output, [
            $row['invoice_date'],
            $row['total_invoices'],
            $row['total_sales'],
            $row['total_cash'],
            $row['total_upi'],
            $row['total_balance'],
            $row['avg_order_value'],
            $row['unique_customers'],
            $row['total_cost'],
            $row['total_profit'],
            round($profit_margin, 2) . '%'
        ]);
    }
    
    fclose($output);
    exit();
}

// Get filter values
$from_date = $_GET['from_date'] ?? date('Y-m-01'); // Default to current month start
$to_date = $_GET['to_date'] ?? date('Y-m-d'); // Default to today

// Build main query
$query = "SELECT 
            si.invoice_date,
            COUNT(si.id) as total_invoices,
            SUM(si.total_amount) as total_sales,
            SUM(si.cash_received) as total_cash,
            SUM(si.upi_received) as total_upi,
            SUM(si.balance_amount) as total_balance,
            AVG(si.total_amount) as avg_order_value,
            COUNT(DISTINCT COALESCE(si.customer_id, CONCAT('walk_', si.customer_name))) as unique_customers
          FROM sales_invoices si
          WHERE si.status = 'active'";

$conditions = [];
if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";

if (!empty($conditions)) {
    $query .= " AND " . implode(" AND ", $conditions);
}

$query .= " GROUP BY si.invoice_date ORDER BY si.invoice_date DESC";
$result = mysqli_query($con, $query);

// Get summary totals
$summary_query = "SELECT 
                    COUNT(DISTINCT si.invoice_date) as total_days,
                    COUNT(si.id) as total_invoices,
                    SUM(si.total_amount) as total_revenue,
                    SUM(si.cash_received) as total_cash,
                    SUM(si.upi_received) as total_upi,
                    SUM(si.balance_amount) as total_balance,
                    AVG(si.total_amount) as avg_order_value,
                    COUNT(DISTINCT COALESCE(si.customer_id, CONCAT('walk_', si.customer_name))) as unique_customers
                  FROM sales_invoices si
                  WHERE si.status = 'active'";

if (!empty($conditions)) {
    $summary_query .= " AND " . implode(" AND ", $conditions);
}

$summary = mysqli_fetch_assoc(mysqli_query($con, $summary_query));

// Get chart data for last 7 days
$chart_query = "SELECT 
                    si.invoice_date,
                    SUM(si.total_amount) as daily_sales
                FROM sales_invoices si
                WHERE si.status = 'active' 
                AND si.invoice_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
                GROUP BY si.invoice_date 
                ORDER BY si.invoice_date ASC";
$chart_result = mysqli_query($con, $chart_query);
$chart_data = [];
while($chart_row = mysqli_fetch_assoc($chart_result)) {
    $chart_data[] = $chart_row;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Daily Summary Report | Vegetable Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .card { border: none !important; box-shadow: none !important; }
            .card-body { padding: 0 !important; }
            body { font-size: 12px !important; }
            .table th, .table td { padding: 0.3rem !important; }
            
            /* 3-inch printer styles */
            @page { size: 80mm auto; margin: 5mm; }
            body { width: 70mm; font-size: 10px; }
            .table { font-size: 9px; }
            .card-header { font-size: 11px; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('../includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('../includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4 no-print">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-calendar-day mr-2"></i>Daily Summary Report
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="index.php">Reports</a></li>
                                <li class="breadcrumb-item active">Daily Summary</li>
                            </ol>
                        </nav>
                    </div>

                    <!-- Filters Card -->
                    <div class="card shadow mb-4 no-print">
                        <div class="card-header py-3 bg-info text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-filter mr-2"></i>Filters & Export</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-4">
                                    <label for="from_date" class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo $from_date; ?>">
                                </div>
                                <div class="col-md-4">
                                    <label for="to_date" class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo $to_date; ?>">
                                </div>
                                <div class="col-md-4 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2"><i class="fas fa-search mr-1"></i>Filter</button>
                                    <a href="?" class="btn btn-secondary mr-2"><i class="fas fa-refresh mr-1"></i>Reset</a>
                                    <div class="dropdown">
                                        <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown">
                                            <i class="fas fa-download mr-1"></i>Export
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="?<?php echo http_build_query(array_merge($_GET, ['export' => 'csv'])); ?>">
                                                <i class="fas fa-file-csv mr-1"></i>Export to CSV
                                            </a>
                                            <a class="dropdown-item" href="javascript:window.print()">
                                                <i class="fas fa-print mr-1"></i>Print Report
                                            </a>
                                            <a class="dropdown-item" href="print_thermal_report.php?<?php echo http_build_query(array_merge($_GET, ['report_type' => 'daily_summary', 'title' => 'Daily Summary Report'])); ?>" target="_blank">
                                                <i class="fas fa-receipt mr-1"></i>3" Thermal Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Days</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $summary['total_days'] ?? 0; ?></div>
                                            <div class="text-xs text-muted">Business days</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-calendar fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Revenue</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_revenue'] ?? 0, 2); ?></div>
                                            <div class="text-xs text-muted">
                                                Daily Avg: ₹<?php echo $summary['total_days'] > 0 ? number_format($summary['total_revenue'] / $summary['total_days'], 2) : 0; ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Invoices</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $summary['total_invoices'] ?? 0; ?></div>
                                            <div class="text-xs text-muted">
                                                Daily Avg: <?php echo $summary['total_days'] > 0 ? round($summary['total_invoices'] / $summary['total_days'], 1) : 0; ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-file-invoice fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Avg Order Value</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['avg_order_value'] ?? 0, 2); ?></div>
                                            <div class="text-xs text-muted"><?php echo $summary['unique_customers'] ?? 0; ?> customers</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-chart-bar fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <!-- Sales Trend Chart -->
                        <div class="col-xl-8 col-lg-7 no-print">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 bg-gradient-primary text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-chart-line mr-2"></i>Last 7 Days Sales Trend</h6>
                                </div>
                                <div class="card-body">
                                    <div class="chart-area">
                                        <canvas id="salesChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Stats -->
                        <div class="col-xl-4 col-lg-5">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 bg-gradient-info text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-info-circle mr-2"></i>Payment Summary</h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center border-bottom py-3">
                                        <div>
                                            <i class="fas fa-money-bill-wave text-success mr-2"></i>
                                            <strong>Cash Received</strong>
                                        </div>
                                        <div class="text-right">
                                            <div class="font-weight-bold">₹<?php echo number_format($summary['total_cash'] ?? 0, 2); ?></div>
                                            <div class="text-muted small">
                                                <?php echo $summary['total_revenue'] > 0 ? round(($summary['total_cash'] / $summary['total_revenue']) * 100, 1) : 0; ?>%
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="d-flex justify-content-between align-items-center border-bottom py-3">
                                        <div>
                                            <i class="fas fa-credit-card text-info mr-2"></i>
                                            <strong>UPI Received</strong>
                                        </div>
                                        <div class="text-right">
                                            <div class="font-weight-bold">₹<?php echo number_format($summary['total_upi'] ?? 0, 2); ?></div>
                                            <div class="text-muted small">
                                                <?php echo $summary['total_revenue'] > 0 ? round(($summary['total_upi'] / $summary['total_revenue']) * 100, 1) : 0; ?>%
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="d-flex justify-content-between align-items-center py-3">
                                        <div>
                                            <i class="fas fa-exclamation-triangle text-warning mr-2"></i>
                                            <strong>Outstanding</strong>
                                        </div>
                                        <div class="text-right">
                                            <div class="font-weight-bold text-danger">₹<?php echo number_format($summary['total_balance'] ?? 0, 2); ?></div>
                                            <div class="text-muted small">
                                                <?php echo $summary['total_revenue'] > 0 ? round(($summary['total_balance'] / $summary['total_revenue']) * 100, 1) : 0; ?>%
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Daily Summary Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-gradient-info text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-table mr-2"></i>Daily Sales Summary</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="dataTable">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Date</th>
                                            <th>Day</th>
                                            <th>Invoices</th>
                                            <th>Total Sales</th>
                                            <th>Cash</th>
                                            <th>UPI</th>
                                            <th>Balance</th>
                                            <th>Avg Order</th>
                                            <th>Customers</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $grand_invoices = 0;
                                        $grand_sales = 0;
                                        $grand_cash = 0;
                                        $grand_upi = 0;
                                        $grand_balance = 0;
                                        $grand_customers = 0;
                                        
                                        while($row = mysqli_fetch_assoc($result)) { 
                                            $grand_invoices += $row['total_invoices'];
                                            $grand_sales += $row['total_sales'];
                                            $grand_cash += $row['total_cash'];
                                            $grand_upi += $row['total_upi'];
                                            $grand_balance += $row['total_balance'];
                                            $grand_customers += $row['unique_customers'];
                                        ?>
                                        <tr>
                                            <td><strong><?php echo date('d-m-Y', strtotime($row['invoice_date'])); ?></strong></td>
                                            <td><span class="badge badge-secondary"><?php echo date('D', strtotime($row['invoice_date'])); ?></span></td>
                                            <td><span class="badge badge-primary"><?php echo $row['total_invoices']; ?></span></td>
                                            <td><strong>₹<?php echo number_format($row['total_sales'], 2); ?></strong></td>
                                            <td>₹<?php echo number_format($row['total_cash'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['total_upi'], 2); ?></td>
                                            <td class="<?php echo $row['total_balance'] > 0 ? 'text-danger' : 'text-muted'; ?>">
                                                ₹<?php echo number_format($row['total_balance'], 2); ?>
                                            </td>
                                            <td>₹<?php echo number_format($row['avg_order_value'], 2); ?></td>
                                            <td><span class="badge badge-info"><?php echo $row['unique_customers']; ?></span></td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="thead-dark">
                                        <tr>
                                            <th colspan="2">TOTAL</th>
                                            <th><?php echo $grand_invoices; ?></th>
                                            <th>₹<?php echo number_format($grand_sales, 2); ?></th>
                                            <th>₹<?php echo number_format($grand_cash, 2); ?></th>
                                            <th>₹<?php echo number_format($grand_upi, 2); ?></th>
                                            <th>₹<?php echo number_format($grand_balance, 2); ?></th>
                                            <th>₹<?php echo $grand_invoices > 0 ? number_format($grand_sales / $grand_invoices, 2) : 0; ?></th>
                                            <th>-</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('../includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
    <!-- DataTables JavaScript-->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "pageLength": 25,
                "order": [[ 0, "desc" ]],
                "columnDefs": [
                    { "orderable": false, "targets": [] }
                ]
            });
        });

        // Sales Chart
        const ctx = document.getElementById('salesChart').getContext('2d');
        const salesChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: [<?php 
                    $dates = [];
                    $sales = [];
                    foreach($chart_data as $chart_row) {
                        $dates[] = "'" . date('M d', strtotime($chart_row['invoice_date'])) . "'";
                        $sales[] = $chart_row['daily_sales'];
                    }
                    echo implode(',', $dates);
                ?>],
                datasets: [{
                    label: 'Daily Sales (₹)',
                    data: [<?php echo implode(',', $sales); ?>],
                    borderColor: 'rgba(78, 115, 223, 1)',
                    backgroundColor: 'rgba(78, 115, 223, 0.1)',
                    borderWidth: 2,
                    fill: true,
                    tension: 0.3
                }]
            },
            options: {
                maintainAspectRatio: false,
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function(value, index, values) {
                                return '₹' + value.toLocaleString();
                            }
                        }
                    }]
                },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            return 'Sales: ₹' + Number(tooltipItem.yLabel).toLocaleString();
                        }
                    }
                }
            }
        });
    </script>
</body>
</html>
