<?php
session_start();
include_once('../includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:../logout.php');
    exit();
}

// Handle CSV Export
if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    $from_date = $_GET['from_date'] ?? '';
    $to_date = $_GET['to_date'] ?? '';
    
    // Build query for export
    $query = "SELECT 
                v.Category,
                COUNT(DISTINCT sid.product_code) as product_count,
                SUM(sid.quantity) as total_quantity,
                SUM(sid.amount) as total_sales,
                AVG(sid.rate) as avg_rate,
                SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as total_cost,
                SUM(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as total_profit,
                COUNT(DISTINCT si.id) as invoice_count
              FROM sales_invoice_details sid
              LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
              LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
              WHERE si.status = 'active' AND v.Category IS NOT NULL";
    
    $conditions = [];
    if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
    if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
    
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }
    
    $query .= " GROUP BY v.Category ORDER BY total_sales DESC";
    $result = mysqli_query($con, $query);
    
    // Generate CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="category_wise_report_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Category', 'Product Count', 'Total Quantity', 'Total Sales', 'Average Rate', 'Total Cost', 'Total Profit', 'Profit Margin %', 'Invoice Count']);
    
    while ($row = mysqli_fetch_assoc($result)) {
        $profit_margin = $row['total_sales'] > 0 ? (($row['total_profit'] / $row['total_sales']) * 100) : 0;
        fputcsv($output, [
            $row['Category'],
            $row['product_count'],
            $row['total_quantity'],
            $row['total_sales'],
            $row['avg_rate'],
            $row['total_cost'],
            $row['total_profit'],
            round($profit_margin, 2) . '%',
            $row['invoice_count']
        ]);
    }
    
    fclose($output);
    exit();
}

// Get filter values
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

// Build main query
$query = "SELECT 
            v.Category,
            COUNT(DISTINCT sid.product_code) as product_count,
            SUM(sid.quantity) as total_quantity,
            SUM(sid.amount) as total_sales,
            AVG(sid.rate) as avg_rate,
            SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as total_cost,
            SUM(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as total_profit,
            COUNT(DISTINCT si.id) as invoice_count
          FROM sales_invoice_details sid
          LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
          LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
          WHERE si.status = 'active' AND v.Category IS NOT NULL";

$conditions = [];
if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";

if (!empty($conditions)) {
    $query .= " AND " . implode(" AND ", $conditions);
}

$query .= " GROUP BY v.Category ORDER BY total_sales DESC";
$result = mysqli_query($con, $query);

// Get summary totals
$summary_query = "SELECT 
                    SUM(sid.amount) as total_revenue,
                    SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as total_cost,
                    SUM(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as total_profit,
                    COUNT(DISTINCT v.Category) as unique_categories
                  FROM sales_invoice_details sid
                  LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
                  LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
                  WHERE si.status = 'active' AND v.Category IS NOT NULL";

if (!empty($conditions)) {
    $summary_query .= " AND " . implode(" AND ", $conditions);
}

$summary = mysqli_fetch_assoc(mysqli_query($con, $summary_query));

// Get top selling categories for chart data
$chart_query = str_replace("ORDER BY total_sales DESC", "ORDER BY total_sales DESC LIMIT 5", $query);
$chart_result = mysqli_query($con, $chart_query);
$chart_data = [];
while($chart_row = mysqli_fetch_assoc($chart_result)) {
    $chart_data[] = $chart_row;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Category Wise Report | Vegetable Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .card { border: none !important; box-shadow: none !important; }
            .card-body { padding: 0 !important; }
            body { font-size: 12px !important; }
            .table th, .table td { padding: 0.3rem !important; }
            
            /* 3-inch printer styles */
            @page { size: 80mm auto; margin: 5mm; }
            body { width: 70mm; font-size: 10px; }
            .table { font-size: 9px; }
            .card-header { font-size: 11px; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('../includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('../includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4 no-print">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-th-list mr-2"></i>Category Wise Report
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="index.php">Reports</a></li>
                                <li class="breadcrumb-item active">Category Wise Report</li>
                            </ol>
                        </nav>
                    </div>

                    <!-- Filters Card -->
                    <div class="card shadow mb-4 no-print">
                        <div class="card-header py-3 bg-info text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-filter mr-2"></i>Filters & Export</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-4">
                                    <label for="from_date" class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo $from_date; ?>">
                                </div>
                                <div class="col-md-4">
                                    <label for="to_date" class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo $to_date; ?>">
                                </div>
                                <div class="col-md-4 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2"><i class="fas fa-search mr-1"></i>Filter</button>
                                    <a href="?" class="btn btn-secondary mr-2"><i class="fas fa-refresh mr-1"></i>Reset</a>
                                    <div class="dropdown">
                                        <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown">
                                            <i class="fas fa-download mr-1"></i>Export
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="?<?php echo http_build_query(array_merge($_GET, ['export' => 'csv'])); ?>">
                                                <i class="fas fa-file-csv mr-1"></i>Export to CSV
                                            </a>
                                            <a class="dropdown-item" href="javascript:window.print()">
                                                <i class="fas fa-print mr-1"></i>Print Report
                                            </a>
                                            <a class="dropdown-item" href="print_thermal_report.php?<?php echo http_build_query(array_merge($_GET, ['report_type' => 'category_wise', 'title' => 'Category Wise Report'])); ?>" target="_blank">
                                                <i class="fas fa-receipt mr-1"></i>3" Thermal Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Revenue</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_revenue'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Total Cost</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_cost'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Profit</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_profit'] ?? 0, 2); ?></div>
                                            <div class="text-xs text-muted">
                                                <?php 
                                                $profit_margin = $summary['total_revenue'] > 0 ? (($summary['total_profit'] / $summary['total_revenue']) * 100) : 0;
                                                echo round($profit_margin, 1) . '% margin';
                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Active Categories</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $summary['unique_categories'] ?? 0; ?></div>
                                            <div class="text-xs text-muted">With sales</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-th-list fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Category Chart -->
                        <div class="col-xl-6 col-lg-7 no-print">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 bg-gradient-info text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-chart-pie mr-2"></i>Top 5 Categories</h6>
                                </div>
                                <div class="card-body">
                                    <div class="chart-pie pt-4 pb-2">
                                        <canvas id="categoryChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Stats -->
                        <div class="col-xl-6 col-lg-5">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 bg-gradient-success text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-list mr-2"></i>Quick Statistics</h6>
                                </div>
                                <div class="card-body">
                                    <?php 
                                    mysqli_data_seek($result, 0); // Reset result pointer
                                    $counter = 0;
                                    while($stat_row = mysqli_fetch_assoc($result) && $counter < 5) { 
                                        $counter++;
                                        $profit_margin = $stat_row['total_sales'] > 0 ? (($stat_row['total_profit'] / $stat_row['total_sales']) * 100) : 0;
                                    ?>
                                    <div class="d-flex justify-content-between align-items-center border-bottom py-2">
                                        <div>
                                            <strong><?php echo htmlspecialchars($stat_row['Category']); ?></strong>
                                            <div class="text-muted small"><?php echo $stat_row['product_count']; ?> products</div>
                                        </div>
                                        <div class="text-right">
                                            <div class="font-weight-bold">₹<?php echo number_format($stat_row['total_sales'], 0); ?></div>
                                            <div class="text-muted small <?php echo $profit_margin > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo number_format($profit_margin, 1); ?>% profit
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Categories Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-gradient-info text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-table mr-2"></i>Category Sales Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="dataTable">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Category</th>
                                            <th>Product Count</th>
                                            <th>Total Quantity</th>
                                            <th>Total Sales</th>
                                            <th>Avg Rate</th>
                                            <th>Total Cost</th>
                                            <th>Total Profit</th>
                                            <th>Profit %</th>
                                            <th>Invoice Count</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        mysqli_data_seek($result, 0); // Reset result pointer
                                        $grand_total_sales = 0;
                                        $grand_total_cost = 0;
                                        $grand_total_profit = 0;
                                        $grand_total_qty = 0;
                                        $grand_product_count = 0;
                                        
                                        while($row = mysqli_fetch_assoc($result)) { 
                                            $profit_margin = $row['total_sales'] > 0 ? (($row['total_profit'] / $row['total_sales']) * 100) : 0;
                                            
                                            $grand_total_sales += $row['total_sales'];
                                            $grand_total_cost += $row['total_cost'];
                                            $grand_total_profit += $row['total_profit'];
                                            $grand_total_qty += $row['total_quantity'];
                                            $grand_product_count += $row['product_count'];
                                        ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="category-icon mr-2">
                                                        <i class="fas fa-leaf text-success"></i>
                                                    </div>
                                                    <strong><?php echo htmlspecialchars($row['Category']); ?></strong>
                                                </div>
                                            </td>
                                            <td><span class="badge badge-primary"><?php echo $row['product_count']; ?></span></td>
                                            <td><?php echo number_format($row['total_quantity'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['total_sales'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['avg_rate'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['total_cost'], 2); ?></td>
                                            <td class="<?php echo $row['total_profit'] > 0 ? 'text-success' : 'text-danger'; ?>">
                                                ₹<?php echo number_format($row['total_profit'], 2); ?>
                                            </td>
                                            <td class="<?php echo $profit_margin > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo number_format($profit_margin, 1); ?>%
                                            </td>
                                            <td><span class="badge badge-info"><?php echo $row['invoice_count']; ?></span></td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="thead-dark">
                                        <tr>
                                            <th>TOTAL</th>
                                            <th><?php echo $grand_product_count; ?></th>
                                            <th><?php echo number_format($grand_total_qty, 2); ?></th>
                                            <th>₹<?php echo number_format($grand_total_sales, 2); ?></th>
                                            <th>-</th>
                                            <th>₹<?php echo number_format($grand_total_cost, 2); ?></th>
                                            <th class="<?php echo $grand_total_profit > 0 ? 'text-success' : 'text-danger'; ?>">
                                                ₹<?php echo number_format($grand_total_profit, 2); ?>
                                            </th>
                                            <th class="<?php echo $grand_total_profit > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo $grand_total_sales > 0 ? number_format(($grand_total_profit / $grand_total_sales) * 100, 1) : 0; ?>%
                                            </th>
                                            <th>-</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('../includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
    <!-- DataTables JavaScript-->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "pageLength": 25,
                "order": [[ 3, "desc" ]],
                "columnDefs": [
                    { "orderable": false, "targets": [] }
                ]
            });
        });

        // Chart configuration
        const ctx = document.getElementById('categoryChart').getContext('2d');
        const categoryChart = new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: [<?php echo "'" . implode("','", array_column($chart_data, 'Category')) . "'"; ?>],
                datasets: [{
                    data: [<?php echo implode(',', array_column($chart_data, 'total_sales')); ?>],
                    backgroundColor: [
                        '#4e73df',
                        '#1cc88a',
                        '#36b9cc',
                        '#f6c23e',
                        '#e74a3b'
                    ],
                    hoverBorderColor: "rgba(234, 236, 244, 1)",
                }],
            },
            options: {
                maintainAspectRatio: false,
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = data.labels[tooltipItem.index] || '';
                            if (label) {
                                label += ': ';
                            }
                            label += '₹' + Number(data.datasets[0].data[tooltipItem.index]).toLocaleString();
                            return label;
                        }
                    }
                },
                legend: {
                    display: true,
                    position: 'bottom'
                },
                cutoutPercentage: 80,
            },
        });
    </script>
</body>
</html>
