<?php
require_once '../includes/config.php';

// Create the income_expense table
$create_table_sql = "
CREATE TABLE IF NOT EXISTS `income_expense` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `type` enum('income','expense') NOT NULL COMMENT 'Type of transaction',
    `category` varchar(100) NOT NULL COMMENT 'Category of income/expense',
    `description` text NOT NULL COMMENT 'Description of transaction',
    `amount` decimal(10,2) NOT NULL COMMENT 'Amount of transaction',
    `transaction_date` date NOT NULL COMMENT 'Date of transaction',
    `payment_method` enum('cash','bank','upi','card') NOT NULL DEFAULT 'cash' COMMENT 'Payment method',
    `reference_no` varchar(50) DEFAULT NULL COMMENT 'Reference number if any',
    `notes` text DEFAULT NULL COMMENT 'Additional notes',
    `created_by` varchar(50) NOT NULL DEFAULT 'admin' COMMENT 'User who created the record',
    `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_type` (`type`),
    KEY `idx_transaction_date` (`transaction_date`),
    KEY `idx_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
";

$success = true;
$messages = [];

// Execute table creation
if (mysqli_query($con, $create_table_sql)) {
    $messages[] = "✓ Income & Expense table created successfully";
} else {
    $messages[] = "✗ Error creating table: " . mysqli_error($con);
    $success = false;
}

// Insert sample data
$sample_data_sql = "
INSERT INTO `income_expense` (`type`, `category`, `description`, `amount`, `transaction_date`, `payment_method`, `notes`) VALUES
('income', 'Sales Revenue', 'Daily vegetable sales', 5000.00, CURDATE(), 'cash', 'Regular daily sales'),
('income', 'Other Income', 'Miscellaneous income', 500.00, CURDATE(), 'bank', 'Other sources'),
('expense', 'Purchase', 'Vegetable purchase from market', 3000.00, CURDATE(), 'cash', 'Daily vegetable purchase'),
('expense', 'Rent', 'Shop rent for the month', 8000.00, CURDATE(), 'bank', 'Monthly shop rent'),
('expense', 'Electricity', 'Electricity bill', 1200.00, CURDATE(), 'upi', 'Monthly electricity bill'),
('expense', 'Transportation', 'Vehicle fuel and maintenance', 800.00, CURDATE(), 'cash', 'Transportation costs'),
('expense', 'Staff Salary', 'Employee salaries', 15000.00, CURDATE(), 'bank', 'Monthly staff salaries'),
('expense', 'Other Expenses', 'Miscellaneous expenses', 300.00, CURDATE(), 'cash', 'Other operational expenses')
ON DUPLICATE KEY UPDATE id=id;
";

if (mysqli_query($con, $sample_data_sql)) {
    $messages[] = "✓ Sample data inserted successfully";
} else {
    $messages[] = "✗ Error inserting sample data: " . mysqli_error($con);
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Finance Module Setup - Vegetable Shop</title>
    <link href="../vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-<?php echo $success ? 'success' : 'danger'; ?> text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-<?php echo $success ? 'check' : 'times'; ?>-circle mr-2"></i>
                            Finance Module Setup
                        </h5>
                    </div>
                    <div class="card-body">
                        <h6>Setup Results:</h6>
                        <ul class="list-unstyled">
                            <?php foreach($messages as $message): ?>
                                <li class="mb-2"><?php echo $message; ?></li>
                            <?php endforeach; ?>
                        </ul>
                        
                        <?php if($success): ?>
                            <div class="alert alert-success mt-3">
                                <i class="fas fa-check-circle mr-2"></i>
                                <strong>Setup Complete!</strong> Your Finance Management module is ready to use.
                            </div>
                            <div class="text-center">
                                <a href="index.php" class="btn btn-success">
                                    <i class="fas fa-arrow-right mr-1"></i>Go to Finance Module
                                </a>
                                <a href="../dashboard.php" class="btn btn-secondary ml-2">
                                    <i class="fas fa-home mr-1"></i>Back to Dashboard
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-danger mt-3">
                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                <strong>Setup Failed!</strong> Please check the errors above and try again.
                            </div>
                            <div class="text-center">
                                <a href="setup.php" class="btn btn-danger">
                                    <i class="fas fa-redo mr-1"></i>Try Again
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
