<?php
require_once '../includes/config.php';

if(!isset($_SESSION)) {
    session_start();
}

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Sanitize and validate input
    $type = mysqli_real_escape_string($con, $_POST['type']);
    $category = mysqli_real_escape_string($con, $_POST['category']);
    $description = mysqli_real_escape_string($con, $_POST['description']);
    $amount = floatval($_POST['amount']);
    $transaction_date = mysqli_real_escape_string($con, $_POST['transaction_date']);
    $payment_method = mysqli_real_escape_string($con, $_POST['payment_method']);
    $reference_no = isset($_POST['reference_no']) ? mysqli_real_escape_string($con, $_POST['reference_no']) : '';
    $notes = isset($_POST['notes']) ? mysqli_real_escape_string($con, $_POST['notes']) : '';
    $created_by = 'admin'; // You can get this from session
    
    // Validate required fields
    if(empty($type) || empty($category) || empty($description) || $amount <= 0 || empty($transaction_date) || empty($payment_method)) {
        $_SESSION['error'] = "All required fields must be filled and amount must be greater than 0.";
        header("Location: index.php");
        exit();
    }
    
    // Validate type
    if(!in_array($type, ['income', 'expense'])) {
        $_SESSION['error'] = "Invalid transaction type.";
        header("Location: index.php");
        exit();
    }
    
    // Validate payment method
    if(!in_array($payment_method, ['cash', 'bank', 'upi', 'card'])) {
        $_SESSION['error'] = "Invalid payment method.";
        header("Location: index.php");
        exit();
    }
    
    try {
        // Insert transaction into database
        $query = "INSERT INTO income_expense (type, category, description, amount, transaction_date, payment_method, reference_no, notes, created_by) 
                  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt = mysqli_prepare($con, $query);
        mysqli_stmt_bind_param($stmt, "sssdsssss", $type, $category, $description, $amount, $transaction_date, $payment_method, $reference_no, $notes, $created_by);
        
        if(mysqli_stmt_execute($stmt)) {
            $_SESSION['success'] = ucfirst($type) . " of ₹" . number_format($amount, 2) . " has been recorded successfully.";
        } else {
            $_SESSION['error'] = "Error recording transaction: " . mysqli_error($con);
        }
        
        mysqli_stmt_close($stmt);
        
    } catch (Exception $e) {
        $_SESSION['error'] = "Database error: " . $e->getMessage();
    }
    
} else {
    $_SESSION['error'] = "Invalid request method.";
}

header("Location: index.php");
exit();
?>
