<?php
require_once '../includes/config.php';

// Check if user is logged in (basic check)
if(!isset($_SESSION)) {
    session_start();
}

// Page title
$page_title = "Finance Management - Income & Expense";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $page_title; ?> - Vegetable Shop</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div class="container-fluid">

        <!-- Main Content -->
        <div class="content">

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Simple Navigation Header -->
                <nav class="navbar navbar-expand-lg navbar-light bg-light mb-4">
                    <a class="navbar-brand" href="../dashboard.php">
                        <i class="fas fa-carrot text-success mr-2"></i>Vegetable Shop
                    </a>
                    <div class="navbar-nav ml-auto">
                        <a class="nav-link" href="../dashboard.php">
                            <i class="fas fa-home mr-1"></i>Dashboard
                        </a>
                        <a class="nav-link active" href="index.php">
                            <i class="fas fa-money-bill-wave mr-1"></i>Finance
                        </a>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-line mr-1"></i>Reports
                        </a>
                    </div>
                </nav>

                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">
                            <i class="fas fa-money-bill-wave text-primary mr-2"></i>Finance Management
                        </h1>
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#addIncomeModal">
                                <i class="fas fa-plus-circle mr-1"></i>Add Income
                            </button>
                            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#addExpenseModal">
                                <i class="fas fa-minus-circle mr-1"></i>Add Expense
                            </button>
                        </div>
                    </div>

                    <!-- Success/Error Messages -->
                    <?php if(isset($_SESSION['success'])): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle mr-2"></i><?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <?php if(isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle mr-2"></i><?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <!-- Summary Cards Row -->
                    <div class="row mb-4">
                        <?php
                        // Get today's summary
                        $today = date('Y-m-d');
                        
                        // Today's Income
                        $income_query = "SELECT COALESCE(SUM(amount), 0) as total_income FROM income_expense WHERE type='income' AND transaction_date='$today'";
                        $income_result = mysqli_query($con, $income_query);
                        $today_income = mysqli_fetch_assoc($income_result)['total_income'];
                        
                        // Today's Expense
                        $expense_query = "SELECT COALESCE(SUM(amount), 0) as total_expense FROM income_expense WHERE type='expense' AND transaction_date='$today'";
                        $expense_result = mysqli_query($con, $expense_query);
                        $today_expense = mysqli_fetch_assoc($expense_result)['total_expense'];
                        
                        // This Month's Income
                        $month_start = date('Y-m-01');
                        $month_income_query = "SELECT COALESCE(SUM(amount), 0) as total_income FROM income_expense WHERE type='income' AND transaction_date >= '$month_start'";
                        $month_income_result = mysqli_query($con, $month_income_query);
                        $month_income = mysqli_fetch_assoc($month_income_result)['total_income'];
                        
                        // This Month's Expense
                        $month_expense_query = "SELECT COALESCE(SUM(amount), 0) as total_expense FROM income_expense WHERE type='expense' AND transaction_date >= '$month_start'";
                        $month_expense_result = mysqli_query($con, $month_expense_query);
                        $month_expense = mysqli_fetch_assoc($month_expense_result)['total_expense'];
                        
                        $net_today = $today_income - $today_expense;
                        $net_month = $month_income - $month_expense;
                        ?>
                        
                        <!-- Today's Income Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                Today's Income</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($today_income, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-arrow-up fa-2x text-success"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Today's Expense Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-danger shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                                Today's Expense</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($today_expense, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-arrow-down fa-2x text-danger"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Today's Net Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-<?php echo ($net_today >= 0) ? 'success' : 'danger'; ?> shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-<?php echo ($net_today >= 0) ? 'success' : 'danger'; ?> text-uppercase mb-1">
                                                Today's Net</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($net_today, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-balance-scale fa-2x text-<?php echo ($net_today >= 0) ? 'success' : 'danger'; ?>"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- This Month's Net Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-<?php echo ($net_month >= 0) ? 'info' : 'warning'; ?> shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-<?php echo ($net_month >= 0) ? 'info' : 'warning'; ?> text-uppercase mb-1">
                                                This Month's Net</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($net_month, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-calendar-alt fa-2x text-<?php echo ($net_month >= 0) ? 'info' : 'warning'; ?>"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- DataTales -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">Recent Transactions</h6>
                            <div class="dropdown no-arrow">
                                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                    aria-labelledby="dropdownMenuLink">
                                    <div class="dropdown-header">Export Options:</div>
                                    <a class="dropdown-item" href="#">
                                        <i class="fas fa-file-excel fa-sm fa-fw mr-2 text-gray-400"></i>
                                        Export to Excel
                                    </a>
                                    <a class="dropdown-item" href="#">
                                        <i class="fas fa-file-pdf fa-sm fa-fw mr-2 text-gray-400"></i>
                                        Export to PDF
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Type</th>
                                            <th>Category</th>
                                            <th>Description</th>
                                            <th>Amount</th>
                                            <th>Payment Method</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $query = "SELECT * FROM income_expense ORDER BY transaction_date DESC, created_at DESC LIMIT 50";
                                        $result = mysqli_query($con, $query);
                                        
                                        while($row = mysqli_fetch_assoc($result)) {
                                            $badge_class = ($row['type'] == 'income') ? 'success' : 'danger';
                                            $icon = ($row['type'] == 'income') ? 'arrow-up' : 'arrow-down';
                                        ?>
                                        <tr>
                                            <td><?php echo date('d-m-Y', strtotime($row['transaction_date'])); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo $badge_class; ?>">
                                                    <i class="fas fa-<?php echo $icon; ?> mr-1"></i>
                                                    <?php echo ucfirst($row['type']); ?>
                                                </span>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['category']); ?></td>
                                            <td><?php echo htmlspecialchars(substr($row['description'], 0, 50)) . (strlen($row['description']) > 50 ? '...' : ''); ?></td>
                                            <td class="text-right font-weight-bold text-<?php echo ($row['type'] == 'income') ? 'success' : 'danger'; ?>">
                                                ₹<?php echo number_format($row['amount'], 2); ?>
                                            </td>
                                            <td>
                                                <span class="badge badge-secondary"><?php echo strtoupper($row['payment_method']); ?></span>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-info edit-btn" data-id="<?php echo $row['id']; ?>" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button class="btn btn-sm btn-danger delete-btn" data-id="<?php echo $row['id']; ?>" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Add Income Modal -->
    <div class="modal fade" id="addIncomeModal" tabindex="-1" role="dialog" aria-labelledby="addIncomeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="addIncomeModalLabel">
                        <i class="fas fa-plus-circle mr-2"></i>Add Income
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="process_transaction.php" method="POST">
                    <input type="hidden" name="type" value="income">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="income_category">Category *</label>
                            <select class="form-control" name="category" required>
                                <option value="">Select Category</option>
                                <option value="Sales Revenue">Sales Revenue</option>
                                <option value="Other Income">Other Income</option>
                                <option value="Interest Income">Interest Income</option>
                                <option value="Rental Income">Rental Income</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="income_description">Description *</label>
                            <textarea class="form-control" name="description" rows="3" required placeholder="Enter description of income"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="income_amount">Amount *</label>
                            <input type="number" class="form-control" name="amount" step="0.01" required placeholder="0.00">
                        </div>
                        <div class="form-group">
                            <label for="income_date">Date *</label>
                            <input type="date" class="form-control" name="transaction_date" value="<?php echo date('Y-m-d'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="income_payment_method">Payment Method *</label>
                            <select class="form-control" name="payment_method" required>
                                <option value="cash">Cash</option>
                                <option value="bank">Bank Transfer</option>
                                <option value="upi">UPI</option>
                                <option value="card">Card</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="income_reference">Reference No.</label>
                            <input type="text" class="form-control" name="reference_no" placeholder="Transaction reference number">
                        </div>
                        <div class="form-group">
                            <label for="income_notes">Notes</label>
                            <textarea class="form-control" name="notes" rows="2" placeholder="Additional notes (optional)"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save mr-1"></i>Save Income
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Add Expense Modal -->
    <div class="modal fade" id="addExpenseModal" tabindex="-1" role="dialog" aria-labelledby="addExpenseModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="addExpenseModalLabel">
                        <i class="fas fa-minus-circle mr-2"></i>Add Expense
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="process_transaction.php" method="POST">
                    <input type="hidden" name="type" value="expense">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="expense_category">Category *</label>
                            <select class="form-control" name="category" required>
                                <option value="">Select Category</option>
                                <option value="Purchase">Purchase</option>
                                <option value="Rent">Rent</option>
                                <option value="Electricity">Electricity</option>
                                <option value="Transportation">Transportation</option>
                                <option value="Staff Salary">Staff Salary</option>
                                <option value="Marketing">Marketing</option>
                                <option value="Maintenance">Maintenance</option>
                                <option value="Other Expenses">Other Expenses</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="expense_description">Description *</label>
                            <textarea class="form-control" name="description" rows="3" required placeholder="Enter description of expense"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="expense_amount">Amount *</label>
                            <input type="number" class="form-control" name="amount" step="0.01" required placeholder="0.00">
                        </div>
                        <div class="form-group">
                            <label for="expense_date">Date *</label>
                            <input type="date" class="form-control" name="transaction_date" value="<?php echo date('Y-m-d'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="expense_payment_method">Payment Method *</label>
                            <select class="form-control" name="payment_method" required>
                                <option value="cash">Cash</option>
                                <option value="bank">Bank Transfer</option>
                                <option value="upi">UPI</option>
                                <option value="card">Card</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="expense_reference">Reference No.</label>
                            <input type="text" class="form-control" name="reference_no" placeholder="Transaction reference number">
                        </div>
                        <div class="form-group">
                            <label for="expense_notes">Notes</label>
                            <textarea class="form-control" name="notes" rows="2" placeholder="Additional notes (optional)"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-save mr-1"></i>Save Expense
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

    <!-- Page level plugins -->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Page level custom scripts -->
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "order": [[ 0, "desc" ]],
                "pageLength": 25
            });
            
            // Edit button functionality
            $('.edit-btn').click(function() {
                var id = $(this).data('id');
                window.location.href = 'edit_transaction.php?id=' + id;
            });
            
            // Delete button functionality
            $('.delete-btn').click(function() {
                var id = $(this).data('id');
                if(confirm('Are you sure you want to delete this transaction?')) {
                    window.location.href = 'delete_transaction.php?id=' + id;
                }
            });
        });
    </script>

</body>

</html>
