<?php
require_once '../includes/config.php';

if(!isset($_SESSION)) {
    session_start();
}

// Check if ID is provided
if(!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $_SESSION['error'] = "Invalid transaction ID.";
    header("Location: index.php");
    exit();
}

$id = intval($_GET['id']);

// Get transaction details
$query = "SELECT * FROM income_expense WHERE id = ?";
$stmt = mysqli_prepare($con, $query);
mysqli_stmt_bind_param($stmt, "i", $id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if(mysqli_num_rows($result) == 0) {
    $_SESSION['error'] = "Transaction not found.";
    header("Location: index.php");
    exit();
}

$transaction = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

$page_title = "Edit " . ucfirst($transaction['type']);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $page_title; ?> - Vegetable Shop</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div class="container-fluid">

        <!-- Main Content -->
        <div class="content">

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Simple Navigation Header -->
                <nav class="navbar navbar-expand-lg navbar-light bg-light mb-4">
                    <a class="navbar-brand" href="../dashboard.php">
                        <i class="fas fa-carrot text-success mr-2"></i>Vegetable Shop
                    </a>
                    <div class="navbar-nav ml-auto">
                        <a class="nav-link" href="../dashboard.php">
                            <i class="fas fa-home mr-1"></i>Dashboard
                        </a>
                        <a class="nav-link" href="index.php">
                            <i class="fas fa-money-bill-wave mr-1"></i>Finance
                        </a>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-line mr-1"></i>Reports
                        </a>
                    </div>
                </nav>

                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">
                            <i class="fas fa-edit text-primary mr-2"></i><?php echo $page_title; ?>
                        </h1>
                    </div>

                    <!-- Edit Form -->
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 bg-<?php echo ($transaction['type'] == 'income') ? 'success' : 'danger'; ?> text-white">
                                    <h6 class="m-0 font-weight-bold">
                                        <i class="fas fa-<?php echo ($transaction['type'] == 'income') ? 'plus' : 'minus'; ?>-circle mr-2"></i>
                                        Edit <?php echo ucfirst($transaction['type']); ?> Transaction
                                    </h6>
                                </div>
                                <div class="card-body">
                                    
                                    <?php if(isset($_SESSION['error'])): ?>
                                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                            <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                    <?php endif; ?>

                                    <form action="update_transaction.php" method="POST">
                                        <input type="hidden" name="id" value="<?php echo $transaction['id']; ?>">
                                        <input type="hidden" name="type" value="<?php echo $transaction['type']; ?>">
                                        
                                        <div class="form-group">
                                            <label for="category">Category *</label>
                                            <select class="form-control" name="category" required>
                                                <option value="">Select Category</option>
                                                <?php if($transaction['type'] == 'income'): ?>
                                                    <option value="Sales Revenue" <?php echo ($transaction['category'] == 'Sales Revenue') ? 'selected' : ''; ?>>Sales Revenue</option>
                                                    <option value="Other Income" <?php echo ($transaction['category'] == 'Other Income') ? 'selected' : ''; ?>>Other Income</option>
                                                    <option value="Interest Income" <?php echo ($transaction['category'] == 'Interest Income') ? 'selected' : ''; ?>>Interest Income</option>
                                                    <option value="Rental Income" <?php echo ($transaction['category'] == 'Rental Income') ? 'selected' : ''; ?>>Rental Income</option>
                                                <?php else: ?>
                                                    <option value="Purchase" <?php echo ($transaction['category'] == 'Purchase') ? 'selected' : ''; ?>>Purchase</option>
                                                    <option value="Rent" <?php echo ($transaction['category'] == 'Rent') ? 'selected' : ''; ?>>Rent</option>
                                                    <option value="Electricity" <?php echo ($transaction['category'] == 'Electricity') ? 'selected' : ''; ?>>Electricity</option>
                                                    <option value="Transportation" <?php echo ($transaction['category'] == 'Transportation') ? 'selected' : ''; ?>>Transportation</option>
                                                    <option value="Staff Salary" <?php echo ($transaction['category'] == 'Staff Salary') ? 'selected' : ''; ?>>Staff Salary</option>
                                                    <option value="Marketing" <?php echo ($transaction['category'] == 'Marketing') ? 'selected' : ''; ?>>Marketing</option>
                                                    <option value="Maintenance" <?php echo ($transaction['category'] == 'Maintenance') ? 'selected' : ''; ?>>Maintenance</option>
                                                    <option value="Other Expenses" <?php echo ($transaction['category'] == 'Other Expenses') ? 'selected' : ''; ?>>Other Expenses</option>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="description">Description *</label>
                                            <textarea class="form-control" name="description" rows="3" required placeholder="Enter description"><?php echo htmlspecialchars($transaction['description']); ?></textarea>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="amount">Amount *</label>
                                            <input type="number" class="form-control" name="amount" step="0.01" required value="<?php echo $transaction['amount']; ?>" placeholder="0.00">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="transaction_date">Date *</label>
                                            <input type="date" class="form-control" name="transaction_date" value="<?php echo $transaction['transaction_date']; ?>" required>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="payment_method">Payment Method *</label>
                                            <select class="form-control" name="payment_method" required>
                                                <option value="cash" <?php echo ($transaction['payment_method'] == 'cash') ? 'selected' : ''; ?>>Cash</option>
                                                <option value="bank" <?php echo ($transaction['payment_method'] == 'bank') ? 'selected' : ''; ?>>Bank Transfer</option>
                                                <option value="upi" <?php echo ($transaction['payment_method'] == 'upi') ? 'selected' : ''; ?>>UPI</option>
                                                <option value="card" <?php echo ($transaction['payment_method'] == 'card') ? 'selected' : ''; ?>>Card</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="reference_no">Reference No.</label>
                                            <input type="text" class="form-control" name="reference_no" value="<?php echo htmlspecialchars($transaction['reference_no']); ?>" placeholder="Transaction reference number">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="notes">Notes</label>
                                            <textarea class="form-control" name="notes" rows="2" placeholder="Additional notes (optional)"><?php echo htmlspecialchars($transaction['notes']); ?></textarea>
                                        </div>
                                        
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-<?php echo ($transaction['type'] == 'income') ? 'success' : 'danger'; ?>">
                                                <i class="fas fa-save mr-1"></i>Update <?php echo ucfirst($transaction['type']); ?>
                                            </button>
                                            <a href="index.php" class="btn btn-secondary">
                                                <i class="fas fa-times mr-1"></i>Cancel
                                            </a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-4">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Transaction Details</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm">
                                        <tr>
                                            <td><strong>Transaction ID:</strong></td>
                                            <td><?php echo $transaction['id']; ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Type:</strong></td>
                                            <td>
                                                <span class="badge badge-<?php echo ($transaction['type'] == 'income') ? 'success' : 'danger'; ?>">
                                                    <?php echo ucfirst($transaction['type']); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Created By:</strong></td>
                                            <td><?php echo htmlspecialchars($transaction['created_by']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Created At:</strong></td>
                                            <td><?php echo date('d-m-Y H:i', strtotime($transaction['created_at'])); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Last Updated:</strong></td>
                                            <td><?php echo date('d-m-Y H:i', strtotime($transaction['updated_at'])); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>
