-- Income and Expense Management Tables
-- Create this table in your vegetable-shop database

CREATE TABLE IF NOT EXISTS `income_expense` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `type` enum('income','expense') NOT NULL COMMENT 'Type of transaction',
    `category` varchar(100) NOT NULL COMMENT 'Category of income/expense',
    `description` text NOT NULL COMMENT 'Description of transaction',
    `amount` decimal(10,2) NOT NULL COMMENT 'Amount of transaction',
    `transaction_date` date NOT NULL COMMENT 'Date of transaction',
    `payment_method` enum('cash','bank','upi','card') NOT NULL DEFAULT 'cash' COMMENT 'Payment method',
    `reference_no` varchar(50) DEFAULT NULL COMMENT 'Reference number if any',
    `notes` text DEFAULT NULL COMMENT 'Additional notes',
    `created_by` varchar(50) NOT NULL DEFAULT 'admin' COMMENT 'User who created the record',
    `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_type` (`type`),
    KEY `idx_transaction_date` (`transaction_date`),
    KEY `idx_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Insert some sample categories for income
INSERT INTO `income_expense` (`type`, `category`, `description`, `amount`, `transaction_date`, `payment_method`, `notes`) VALUES
('income', 'Sales Revenue', 'Daily vegetable sales', 5000.00, CURDATE(), 'cash', 'Regular daily sales'),
('income', 'Other Income', 'Miscellaneous income', 500.00, CURDATE(), 'bank', 'Other sources'),
('expense', 'Purchase', 'Vegetable purchase from market', 3000.00, CURDATE(), 'cash', 'Daily vegetable purchase'),
('expense', 'Rent', 'Shop rent for the month', 8000.00, CURDATE(), 'bank', 'Monthly shop rent'),
('expense', 'Electricity', 'Electricity bill', 1200.00, CURDATE(), 'upi', 'Monthly electricity bill'),
('expense', 'Transportation', 'Vehicle fuel and maintenance', 800.00, CURDATE(), 'cash', 'Transportation costs'),
('expense', 'Staff Salary', 'Employee salaries', 15000.00, CURDATE(), 'bank', 'Monthly staff salaries'),
('expense', 'Other Expenses', 'Miscellaneous expenses', 300.00, CURDATE(), 'cash', 'Other operational expenses');
