<?php
include_once('includes/config.php');

echo "<h2>Debugging Customer Outstanding Issues</h2>\n";

// 1. Check what invoice types exist
echo "<h3>1. Invoice Types in Sales Invoices</h3>\n";
$query1 = "SELECT DISTINCT invoice_type, COUNT(*) as count FROM sales_invoices GROUP BY invoice_type";
$result1 = mysqli_query($con, $query1);
echo "<table border='1'><tr><th>Invoice Type</th><th>Count</th></tr>";
while ($row = mysqli_fetch_assoc($result1)) {
    echo "<tr><td>{$row['invoice_type']}</td><td>{$row['count']}</td></tr>";
}
echo "</table><br>";

// 2. Check invoices with balance > 0
echo "<h3>2. Invoices with Outstanding Balance</h3>\n";
$query2 = "SELECT invoice_type, payment_status, COUNT(*) as count, SUM(balance_amount) as total_balance 
           FROM sales_invoices 
           WHERE balance_amount > 0 
           GROUP BY invoice_type, payment_status";
$result2 = mysqli_query($con, $query2);
echo "<table border='1'><tr><th>Invoice Type</th><th>Payment Status</th><th>Count</th><th>Total Balance</th></tr>";
while ($row = mysqli_fetch_assoc($result2)) {
    echo "<tr><td>{$row['invoice_type']}</td><td>{$row['payment_status']}</td><td>{$row['count']}</td><td>₹" . number_format($row['total_balance'], 2) . "</td></tr>";
}
echo "</table><br>";

// 3. Check specific customers with outstanding
echo "<h3>3. Sample Customers with Outstanding Balance</h3>\n";
$query3 = "SELECT customer_name, customer_phone, invoice_type, balance_amount, payment_status, invoice_no, invoice_date 
           FROM sales_invoices 
           WHERE balance_amount > 0 
           ORDER BY balance_amount DESC 
           LIMIT 10";
$result3 = mysqli_query($con, $query3);
echo "<table border='1'><tr><th>Customer</th><th>Phone</th><th>Invoice Type</th><th>Balance</th><th>Status</th><th>Invoice No</th><th>Date</th></tr>";
while ($row = mysqli_fetch_assoc($result3)) {
    echo "<tr>";
    echo "<td>{$row['customer_name']}</td>";
    echo "<td>{$row['customer_phone']}</td>";
    echo "<td>{$row['invoice_type']}</td>";
    echo "<td>₹" . number_format($row['balance_amount'], 2) . "</td>";
    echo "<td>{$row['payment_status']}</td>";
    echo "<td>{$row['invoice_no']}</td>";
    echo "<td>{$row['invoice_date']}</td>";
    echo "</tr>";
}
echo "</table><br>";

// 4. Check the current query logic
echo "<h3>4. Current Report Query Results</h3>\n";
$query4 = "SELECT 
            COALESCE(si.customer_id, 0) as customer_id,
            COALESCE(c.customer_name, si.customer_name, 'Walk-in Customer') as customer_name,
            COALESCE(c.phone, si.customer_phone, '') as phone,
            SUM(si.balance_amount) as total_outstanding
          FROM sales_invoices si
          LEFT JOIN customers c ON si.customer_id = c.id
          WHERE si.invoice_type = 'credit' 
          AND si.balance_amount > 0 
          AND si.status = 'active'
          GROUP BY COALESCE(si.customer_id, CONCAT('walk_', si.customer_name))
          ORDER BY total_outstanding DESC
          LIMIT 10";
$result4 = mysqli_query($con, $query4);
echo "<table border='1'><tr><th>Customer ID</th><th>Customer Name</th><th>Phone</th><th>Outstanding</th></tr>";
while ($row = mysqli_fetch_assoc($result4)) {
    echo "<tr>";
    echo "<td>{$row['customer_id']}</td>";
    echo "<td>{$row['customer_name']}</td>";
    echo "<td>{$row['phone']}</td>";
    echo "<td>₹" . number_format($row['total_outstanding'], 2) . "</td>";
    echo "</tr>";
}
echo "</table><br>";

// 5. Check what happens if we remove invoice_type filter
echo "<h3>5. All Outstanding Invoices (No Type Filter)</h3>\n";
$query5 = "SELECT 
            COALESCE(si.customer_id, 0) as customer_id,
            COALESCE(c.customer_name, si.customer_name, 'Walk-in Customer') as customer_name,
            COALESCE(c.phone, si.customer_phone, '') as phone,
            si.invoice_type,
            SUM(si.balance_amount) as total_outstanding
          FROM sales_invoices si
          LEFT JOIN customers c ON si.customer_id = c.id
          WHERE si.balance_amount > 0 
          AND si.status = 'active'
          GROUP BY COALESCE(si.customer_id, CONCAT('walk_', si.customer_name)), si.invoice_type
          ORDER BY total_outstanding DESC
          LIMIT 15";
$result5 = mysqli_query($con, $query5);
echo "<table border='1'><tr><th>Customer ID</th><th>Customer Name</th><th>Phone</th><th>Invoice Type</th><th>Outstanding</th></tr>";
while ($row = mysqli_fetch_assoc($result5)) {
    echo "<tr>";
    echo "<td>{$row['customer_id']}</td>";
    echo "<td>{$row['customer_name']}</td>";
    echo "<td>{$row['phone']}</td>";
    echo "<td>{$row['invoice_type']}</td>";
    echo "<td>₹" . number_format($row['total_outstanding'], 2) . "</td>";
    echo "</tr>";
}
echo "</table><br>";

// 6. Check status field values
echo "<h3>6. Status Field Values</h3>\n";
$query6 = "SELECT DISTINCT status, COUNT(*) as count FROM sales_invoices GROUP BY status";
$result6 = mysqli_query($con, $query6);
echo "<table border='1'><tr><th>Status</th><th>Count</th></tr>";
while ($row = mysqli_fetch_assoc($result6)) {
    echo "<tr><td>{$row['status']}</td><td>{$row['count']}</td></tr>";
}
echo "</table><br>";

mysqli_close($con);
?>
