<?php
include('includes/config.php');

echo "<h2>Database Connection and User Check</h2>";

// Check database connection
if (!$con) {
    echo "<p style='color: red;'>❌ Database connection failed!</p>";
    echo "<p>Error: " . mysqli_connect_error() . "</p>";
    exit;
} else {
    echo "<p style='color: green;'>✅ Database connection successful!</p>";
}

// Check if tblusers table exists
$table_check = mysqli_query($con, "SHOW TABLES LIKE 'tblusers'");
if (mysqli_num_rows($table_check) == 0) {
    echo "<p style='color: red;'>❌ 'tblusers' table doesn't exist!</p>";
    
    // Create the users table
    $create_table = "
    CREATE TABLE IF NOT EXISTS `tblusers` (
        `ID` int(11) NOT NULL AUTO_INCREMENT,
        `FullName` varchar(100) NOT NULL,
        `UserName` varchar(50) NOT NULL,
        `Password` varchar(255) NOT NULL,
        `UserType` varchar(20) NOT NULL DEFAULT 'User',
        `CreationDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`ID`),
        UNIQUE KEY `UserName` (`UserName`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
    ";
    
    if (mysqli_query($con, $create_table)) {
        echo "<p style='color: green;'>✅ 'tblusers' table created successfully!</p>";
    } else {
        echo "<p style='color: red;'>❌ Error creating table: " . mysqli_error($con) . "</p>";
    }
} else {
    echo "<p style='color: green;'>✅ 'tblusers' table exists!</p>";
}

// Check for existing users
$user_query = mysqli_query($con, "SELECT ID, FullName, UserName, UserType FROM tblusers");
$user_count = mysqli_num_rows($user_query);

echo "<p><strong>Total Users in Database:</strong> $user_count</p>";

if ($user_count == 0) {
    echo "<p style='color: orange;'>⚠️ No users found in database!</p>";
    
    // Insert default admin user
    $admin_password = md5('admin123');
    $insert_admin = "INSERT INTO tblusers (FullName, UserName, Password, UserType) VALUES 
                    ('Administrator', 'admin', '$admin_password', 'Admin')";
    
    if (mysqli_query($con, $insert_admin)) {
        echo "<p style='color: green;'>✅ Default admin user created!</p>";
        echo "<p><strong>Login Credentials:</strong><br>";
        echo "Username: <code>admin</code><br>";
        echo "Password: <code>admin123</code></p>";
    } else {
        echo "<p style='color: red;'>❌ Error creating admin user: " . mysqli_error($con) . "</p>";
    }
} else {
    echo "<p style='color: green;'>✅ Users found in database:</p>";
    echo "<table border='1' cellpadding='5' cellspacing='0'>";
    echo "<tr><th>ID</th><th>Full Name</th><th>Username</th><th>User Type</th></tr>";
    
    while ($user = mysqli_fetch_array($user_query)) {
        echo "<tr>";
        echo "<td>" . $user['ID'] . "</td>";
        echo "<td>" . $user['FullName'] . "</td>";
        echo "<td>" . $user['UserName'] . "</td>";
        echo "<td>" . $user['UserType'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<hr>";
echo "<p><a href='login.php'>Go to Login Page</a></p>";
echo "<p><a href='test_session.php'>Test Sessions</a></p>";
?>
