<?php
session_start();
include_once('includes/config.php');

if (!isset($_SESSION['uid'])) {
    header('location:login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Vegetable Shop - Dashboard</title>

    <!-- Custom fonts for this template-->
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/enhanced-admin.css" rel="stylesheet">
</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php include_once('includes/sidebar.php'); ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <?php include_once('includes/topbar.php'); ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-tachometer-alt mr-2"></i>Dashboard Overview
                        </h1>
                        <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
                            <i class="fas fa-download fa-sm text-white-50"></i> Generate Report
                        </a>
                    </div>

                    <!-- Welcome Card -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card stats-card fade-in">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-lg-8">
                                            <h2 class="text-gray-800 mb-3">
                                                Welcome back, <?php echo htmlspecialchars($_SESSION['fullname']); ?>! ✨
                                            </h2>
                                            <p class="text-gray-600 mb-3 lead">
                                                You are logged in as <span class="badge badge-primary"><?php echo htmlspecialchars($_SESSION['usertype']); ?></span>
                                            </p>
                                            <p class="text-gray-500 mb-0">
                                                Here's what's happening with your vegetable business today.
                                            </p>
                                        </div>
                                        <div class="col-lg-4 text-center">
                                            <div class="stats-icon primary">
                                                <i class="fas fa-carrot"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Dashboard Stats Row -->
                    <div class="row">
                        <!-- Total Orders Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card stats-card slide-in-left border-left-primary shadow">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                Total Orders
                                            </div>
                                            <div class="h4 mb-0 font-weight-bold text-gray-800">
                                                1,247
                                            </div>
                                            <div class="text-success text-xs mt-1">
                                                <i class="fas fa-arrow-up"></i> 12% from last month
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <div class="stats-icon primary">
                                                <i class="fas fa-shopping-cart"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Monthly Revenue Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card stats-card slide-in-left border-left-success shadow">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                Monthly Revenue
                                            </div>
                                            <div class="h4 mb-0 font-weight-bold text-gray-800">
                                                $89,540
                                            </div>
                                            <div class="text-success text-xs mt-1">
                                                <i class="fas fa-arrow-up"></i> 8.2% from last month
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <div class="stats-icon success">
                                                <i class="fas fa-dollar-sign"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Active Customers Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card stats-card slide-in-left border-left-info shadow">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                                Active Customers
                                            </div>
                                            <div class="h4 mb-0 font-weight-bold text-gray-800">
                                                892
                                            </div>
                                            <div class="progress progress-sm mt-2">
                                                <div class="progress-bar bg-info" role="progressbar"
                                                    style="width: 78%" aria-valuenow="78" aria-valuemin="0"
                                                    aria-valuemax="100"></div>
                                            </div>
                                            <div class="text-info text-xs mt-1">78% retention rate</div>
                                        </div>
                                        <div class="col-auto">
                                            <div class="stats-icon" style="background: linear-gradient(135deg, var(--info-color) 0%, #0891b2 100%);">
                                                <i class="fas fa-users"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Tasks Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card stats-card slide-in-left border-left-warning shadow">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                Pending Orders
                                            </div>
                                            <div class="h4 mb-0 font-weight-bold text-gray-800">
                                                23
                                            </div>
                                            <div class="text-warning text-xs mt-1">
                                                <i class="fas fa-exclamation-triangle"></i> Needs attention
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <div class="stats-icon warning">
                                                <i class="fas fa-clipboard-list"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modern Analytics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-8">
                            <div class="card glass-card modern-shadow">
                                <div class="card-header bg-gradient-primary text-white">
                                    <h6 class="m-0 font-weight-bold text-white">
                                        <i class="fas fa-chart-line mr-2"></i>Sales Analytics
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4 text-center mb-3">
                                            <div class="stat-metric">
                                                <div class="stat-number text-gradient">₹2.4M</div>
                                                <div class="stat-label">Total Revenue</div>
                                                <div class="stat-change text-success">
                                                    <i class="fas fa-arrow-up"></i> 12.5%
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 text-center mb-3">
                                            <div class="stat-metric">
                                                <div class="stat-number text-gradient-secondary">1,247</div>
                                                <div class="stat-label">Total Orders</div>
                                                <div class="stat-change text-success">
                                                    <i class="fas fa-arrow-up"></i> 8.2%
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 text-center mb-3">
                                            <div class="stat-metric">
                                                <div class="stat-number text-gradient-accent">₹1,924</div>
                                                <div class="stat-label">Avg. Order Value</div>
                                                <div class="stat-change text-info">
                                                    <i class="fas fa-arrow-right"></i> 2.1%
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="chart-placeholder bg-gradient text-center p-4 rounded-xl text-white">
                                        <i class="fas fa-chart-area fa-3x mb-3"></i>
                                        <p class="mb-0">Interactive Charts Coming Soon</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="card glass-card modern-shadow h-100">
                                <div class="card-header bg-gradient-success text-white">
                                    <h6 class="m-0 font-weight-bold text-white">
                                        <i class="fas fa-carrot mr-2"></i>Top Vegetables
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="product-item d-flex align-items-center mb-3 p-2 rounded hover-lift">
                                        <div class="product-icon bg-primary text-white rounded-circle mr-3">
                                            <i class="fas fa-carrot"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="font-weight-bold">Fresh Carrots</div>
                                            <div class="text-muted small">124 kg sold</div>
                                        </div>
                                        <div class="text-success font-weight-bold">₹8.9K</div>
                                    </div>
                                    <div class="product-item d-flex align-items-center mb-3 p-2 rounded hover-lift">
                                        <div class="product-icon bg-warning text-white rounded-circle mr-3">
                                            <i class="fas fa-pepper-hot"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="font-weight-bold">Organic Tomatoes</div>
                                            <div class="text-muted small">89 kg sold</div>
                                        </div>
                                        <div class="text-success font-weight-bold">₹6.7K</div>
                                    </div>
                                    <div class="product-item d-flex align-items-center mb-3 p-2 rounded hover-lift">
                                        <div class="product-icon bg-info text-white rounded-circle mr-3">
                                            <i class="fas fa-leaf"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="font-weight-bold">Fresh Spinach</div>
                                            <div class="text-muted small">76 kg sold</div>
                                        </div>
                                        <div class="text-success font-weight-bold">₹4.5K</div>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a href="products-report.php" class="btn btn-outline-success btn-sm">View Full Report</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions Row -->
                    <div class="row">
                        <div class="col-lg-6 mb-4">
                            <div class="card glass-card modern-shadow">
                                <div class="card-header bg-gradient-primary text-white">
                                    <h6 class="m-0 font-weight-bold text-white">
                                        <i class="fas fa-bolt mr-2"></i>Quick Actions
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <?php if($_SESSION['usertype'] == 'admin'): ?>
                                        <div class="col-md-6 mb-3">
                                            <a href="create-user.php" class="btn btn-primary btn-block hover-lift btn-ripple demo-loading">
                                                <i class="fas fa-user-plus mb-1"></i><br>
                                                <small>Add New User</small>
                                            </a>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <a href="manage-users.php" class="btn btn-success btn-block hover-lift btn-ripple demo-loading">
                                                <i class="fas fa-users-cog mb-1"></i><br>
                                                <small>Manage Users</small>
                                            </a>
                                        </div>
                                        <?php endif; ?>
                                        <div class="col-md-6 mb-3">
                                            <a href="vegetable-master.php" class="btn btn-info btn-block hover-lift btn-ripple demo-loading">
                                                <i class="fas fa-seedling mb-1"></i><br>
                                                <small>Manage Vegetables</small>
                                            </a>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <a href="sales/index.php" class="btn btn-success btn-block hover-lift btn-ripple demo-loading">
                                                <i class="fas fa-cash-register mb-1"></i><br>
                                                <small>New Sale</small>
                                            </a>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <a href="payment_receive.php" class="btn btn-primary btn-block hover-lift btn-ripple demo-loading">
                                                <i class="fas fa-hand-holding-usd mb-1"></i><br>
                                                <small>Receive Payment</small>
                                            </a>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <a href="reports/" class="btn btn-warning btn-block hover-lift btn-ripple demo-loading">
                                                <i class="fas fa-chart-bar mb-1"></i><br>
                                                <small>View Reports</small>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Enhanced Recent Activity -->
                        <div class="col-lg-6 mb-4">
                            <div class="card glass-card modern-shadow">
                                <div class="card-header bg-gradient-success text-white">
                                    <h6 class="m-0 font-weight-bold text-white">
                                        <i class="fas fa-clock mr-2"></i>Recent Activity
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="activity-item d-flex align-items-center mb-3 p-2 rounded hover-scale">
                                        <div class="activity-icon bg-primary text-white rounded-circle mr-3 pulse">
                                            <i class="fas fa-shopping-cart"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="small font-weight-bold">New order #12847</div>
                                            <div class="text-muted small">John Doe - Fresh Vegetables</div>
                                            <div class="text-success small">₹450</div>
                                        </div>
                                        <div class="text-muted small">2m ago</div>
                                    </div>
                                    <div class="activity-item d-flex align-items-center mb-3 p-2 rounded hover-scale">
                                        <div class="activity-icon bg-success text-white rounded-circle mr-3">
                                            <i class="fas fa-user"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="small font-weight-bold">New customer registered</div>
                                            <div class="text-muted small">Sarah Wilson from Mumbai</div>
                                            <div class="text-info small">Premium member</div>
                                        </div>
                                        <div class="text-muted small">15m ago</div>
                                    </div>
                                    <div class="activity-item d-flex align-items-center mb-3 p-2 rounded hover-scale">
                                        <div class="activity-icon bg-warning text-white rounded-circle mr-3">
                                            <i class="fas fa-box"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="small font-weight-bold">Low stock alert</div>
                                            <div class="text-muted small">Fresh Carrots - Only 3 kg left</div>
                                            <div class="text-warning small">Needs restocking</div>
                                        </div>
                                        <div class="text-muted small">1h ago</div>
                                    </div>
                                    <div class="activity-item d-flex align-items-center mb-3 p-2 rounded hover-scale">
                                        <div class="activity-icon bg-info text-white rounded-circle mr-3">
                                            <i class="fas fa-star"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="small font-weight-bold">5-star review received</div>
                                            <div class="text-muted small">Excellent service and quality!</div>
                                            <div class="text-warning small">⭐⭐⭐⭐⭐</div>
                                        </div>
                                        <div class="text-muted small">3h ago</div>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a href="activity-log.php" class="btn btn-outline-success btn-sm btn-ripple">
                                            <i class="fas fa-eye mr-1"></i>View All Activity
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- System Status Row -->
                    <div class="row">
                        <div class="col-lg-12 mb-4">
                            <div class="card shadow">
                                <div class="card-header bg-gradient-dark text-white">
                                    <h6 class="m-0 font-weight-bold">
                                        <i class="fas fa-server mr-2"></i>System Status
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-md-3 mb-3">
                                            <div class="border-left-success p-3">
                                                <div class="text-success font-weight-bold">
                                                    <i class="fas fa-check-circle"></i> Database
                                                </div>
                                                <div class="text-muted small">Connected</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <div class="border-left-success p-3">
                                                <div class="text-success font-weight-bold">
                                                    <i class="fas fa-check-circle"></i> Server
                                                </div>
                                                <div class="text-muted small">Online</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <div class="border-left-success p-3">
                                                <div class="text-success font-weight-bold">
                                                    <i class="fas fa-check-circle"></i> Security
                                                </div>
                                                <div class="text-muted small">Protected</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <div class="border-left-warning p-3">
                                                <div class="text-warning font-weight-bold">
                                                    <i class="fas fa-exclamation-triangle"></i> Backup
                                                </div>
                                                <div class="text-muted small">2 days ago</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include_once('includes/footer.php'); ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Bootstrap core JavaScript-->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="js/sb-admin-2.min.js"></script>
    
    <!-- Enhanced admin panel scripts-->
    <script src="js/enhanced-admin.js"></script>

</body>

</html>
