<?php
include('includes/config.php');

echo "<h2>Create Admin User</h2>";

// Check database connection
if (!$con) {
    die("<p style='color: red;'>❌ Database connection failed: " . mysqli_connect_error() . "</p>");
}

// Create tblusers table if it doesn't exist
$create_table_sql = "
CREATE TABLE IF NOT EXISTS `tblusers` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `FullName` varchar(100) NOT NULL,
  `UserName` varchar(50) NOT NULL,
  `Password` varchar(255) NOT NULL,
  `UserType` varchar(20) NOT NULL DEFAULT 'User',
  `CreationDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UserName` (`UserName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
";

if (mysqli_query($con, $create_table_sql)) {
    echo "<p style='color: green;'>✅ Table 'tblusers' ready!</p>";
} else {
    echo "<p style='color: red;'>❌ Error creating table: " . mysqli_error($con) . "</p>";
}

// Check if admin user already exists
$check_admin = mysqli_query($con, "SELECT * FROM tblusers WHERE UserName = 'admin'");

if (mysqli_num_rows($check_admin) > 0) {
    echo "<p style='color: orange;'>⚠️ Admin user already exists!</p>";
    
    // Update the admin password to ensure it's correct
    $new_password = md5('admin123');
    $update_sql = "UPDATE tblusers SET Password = '$new_password' WHERE UserName = 'admin'";
    
    if (mysqli_query($con, $update_sql)) {
        echo "<p style='color: green;'>✅ Admin password updated!</p>";
    } else {
        echo "<p style='color: red;'>❌ Error updating password: " . mysqli_error($con) . "</p>";
    }
} else {
    // Create admin user
    $admin_password = md5('admin123');
    $insert_sql = "INSERT INTO tblusers (FullName, UserName, Password, UserType) VALUES 
                   ('System Administrator', 'admin', '$admin_password', 'Admin')";
    
    if (mysqli_query($con, $insert_sql)) {
        echo "<p style='color: green;'>✅ Admin user created successfully!</p>";
    } else {
        echo "<p style='color: red;'>❌ Error creating admin user: " . mysqli_error($con) . "</p>";
    }
}

// Display login credentials
echo "<div style='background: #f0f8ff; border: 2px solid #4CAF50; padding: 20px; margin: 20px 0; border-radius: 10px;'>";
echo "<h3 style='color: #2E7D32;'>🔑 Login Credentials</h3>";
echo "<p><strong>Username:</strong> <code style='background: #e8f5e8; padding: 5px;'>admin</code></p>";
echo "<p><strong>Password:</strong> <code style='background: #e8f5e8; padding: 5px;'>admin123</code></p>";
echo "</div>";

// Test the login
echo "<h3>Testing Login...</h3>";
$test_query = "SELECT ID, FullName, UserType FROM tblusers WHERE UserName='admin' AND Password='" . md5('admin123') . "'";
$test_result = mysqli_query($con, $test_query);

if ($test_result && mysqli_num_rows($test_result) > 0) {
    $user_data = mysqli_fetch_array($test_result);
    echo "<p style='color: green;'>✅ Login test successful!</p>";
    echo "<p>User ID: " . $user_data['ID'] . "</p>";
    echo "<p>Full Name: " . $user_data['FullName'] . "</p>";
    echo "<p>User Type: " . $user_data['UserType'] . "</p>";
} else {
    echo "<p style='color: red;'>❌ Login test failed!</p>";
}

echo "<hr>";
echo "<div style='text-align: center; margin: 20px 0;'>";
echo "<a href='login.php' style='background: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin: 5px;'>🔐 Go to Login Page</a>";
echo "<a href='test_session.php' style='background: #2196F3; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin: 5px;'>🧪 Test Sessions</a>";
echo "</div>";
?>
