-- Minimal Working Sample Data for Ramom School Management System
-- Simple data that works with the actual table structures

-- Insert Sample Classes
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 1', '1', 1),
('Grade 2', '2', 1),
('Grade 3', '3', 1);

-- Insert Sample Sections (no class_id field)
INSERT INTO `section` (`name`, `capacity`, `branch_id`) VALUES 
('A', '30', 1),
('B', '30', 1),
('C', '30', 1);

-- Insert Sample Student Categories
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('SC/ST', 1),
('OBC', 1);

-- Insert Sample School Years
INSERT INTO `schoolyear` (`school_year`, `branch_id`) VALUES 
('2024-2025', 1);

-- Insert Sample Parents (basic info)
INSERT INTO `parent` (`father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_phone`, `guardian_email`, `guardian_address`, `branch_id`) VALUES 
('Robert Wilson', '+1-555-2001', 'Engineer', 'Lisa Wilson', '+1-555-2002', 'Teacher', 'Robert Wilson', '+1-555-2001', 'robert@email.com', '123 Main St, NY', 1),
('Carlos Garcia', '+1-555-2003', 'Business', 'Maria Garcia', '+1-555-2004', 'Nurse', 'Carlos Garcia', '+1-555-2003', 'carlos@email.com', '456 Oak Ave, NY', 1),
('James Smith', '+1-555-2005', 'Doctor', 'Sarah Smith', '+1-555-2006', 'Lawyer', 'James Smith', '+1-555-2005', 'james@email.com', '789 Pine St, NY', 1);

-- Insert Sample Students
INSERT INTO `student` (`register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `blood_group`, `current_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`) VALUES 
('RIS001', '2024-09-01', 'Emma', 'Wilson', 'Female', '2018-05-15', 'O+', '123 Main St, NY', 'New York', 'NY', '+1-555-1001', 1, 'emma@email.com', 1),
('RIS002', '2024-09-01', 'Oliver', 'Garcia', 'Male', '2018-03-22', 'A+', '456 Oak Ave, NY', 'New York', 'NY', '+1-555-1002', 1, 'oliver@email.com', 2),
('RIS003', '2024-09-01', 'Sophia', 'Smith', 'Female', '2018-07-10', 'B+', '789 Pine St, NY', 'New York', 'NY', '+1-555-1003', 1, 'sophia@email.com', 3);

-- Insert Sample Staff
INSERT INTO `staff` (`name`, `staff_id`, `designation`, `joining_date`, `phone`, `email`, `branch_id`, `status`) VALUES 
('John Smith', 'TCH001', 'Principal', '2020-01-15', '+1-555-0124', 'john@school.com', 1, 1),
('Sarah Johnson', 'TCH002', 'Math Teacher', '2021-08-01', '+1-555-0125', 'sarah@school.com', 1, 1),
('Mike Brown', 'TCH003', 'English Teacher', '2022-01-10', '+1-555-0126', 'mike@school.com', 1, 1);

-- Insert Sample Events
INSERT INTO `event` (`title`, `event_for`, `date`, `note`, `branch_id`) VALUES 
('First Day of School', 'all', '2024-09-01', 'Welcome to new academic year!', 1),
('Parent Meeting', 'parent', '2024-09-15', 'Monthly parent-teacher meeting', 1),
('Sports Day', 'all', '2024-11-20', 'Annual sports day event', 1);

-- Insert Sample Library Books
INSERT INTO `book` (`name`, `author`, `subject`, `qty`, `available`, `branch_id`) VALUES 
('Mathematics Grade 1', 'Dr. Math', 'Mathematics', 25, 25, 1),
('English Stories', 'Jane Author', 'English', 20, 20, 1),
('Science Fun', 'Prof. Science', 'Science', 15, 15, 1);

-- Success Messages
SELECT '✅ SUCCESS: Sample data inserted successfully!' as STATUS;
SELECT '🏫 School: Ramom International School (Branch ID: 1)' as SCHOOL;
SELECT '👨‍🎓 Students: 3 students added (Emma, Oliver, Sophia)' as STUDENTS;
SELECT '👨‍🏫 Teachers: 3 staff members added' as STAFF;
SELECT '📚 Classes: 3 grades with sections created' as CLASSES;
SELECT '📅 Events: 3 sample events added' as EVENTS;
SELECT '📖 Books: 3 library books added' as LIBRARY;
SELECT '' as SEPARATOR;
SELECT '🔐 LOGIN INFORMATION:' as LOGIN_HEADER;
SELECT 'Admin: superadmin@ramom.com / Password: 1234' as ADMIN_LOGIN;
SELECT 'URL: http://localhost/New/main_script_v6.6/main_script_v6.6/' as ACCESS_URL;
