-- WORKING Sample Data for Ramom School Management System
-- Simple version that matches actual table structures

-- Clear any existing test data first
DELETE FROM event WHERE branch_id = 1 AND id > 0;
DELETE FROM book WHERE branch_id = 1 AND id > 0;
DELETE FROM book_category WHERE branch_id = 1 AND id > 0;
DELETE FROM student WHERE id > 0 AND register_no LIKE 'RIS%';
DELETE FROM parent WHERE branch_id = 1 AND name LIKE '%Wilson%';
DELETE FROM student_category WHERE branch_id = 1 AND name IN ('General', 'Scholarship');
DELETE FROM section WHERE branch_id = 1 AND name IN ('A', 'B', 'C');
DELETE FROM class WHERE branch_id = 1 AND name LIKE 'Grade%';

-- Insert Sample Classes
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 1', '1', 1),
('Grade 2', '2', 1),
('Grade 3', '3', 1);

-- Insert Sample Sections (only name, capacity, branch_id fields exist)
INSERT INTO `section` (`name`, `capacity`, `branch_id`) VALUES 
('A', '30', 1),
('B', '30', 1),
('C', '30', 1);

-- Insert Sample Student Categories
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('Scholarship', 1);

-- Insert Sample Parents (using only existing fields)
INSERT INTO `parent` (`name`, `father_name`, `mother_name`, `occupation`, `email`, `mobileno`, `address`, `city`, `state`, `branch_id`, `active`) VALUES 
('Robert Wilson', 'Robert Wilson', 'Lisa Wilson', 'Software Engineer', 'robert.wilson@email.com', '+1-555-2001', '123 Main Street', 'New York', 'NY', 1, 1),
('Carlos Garcia', 'Carlos Garcia', 'Maria Garcia', 'Business Owner', 'carlos.garcia@email.com', '+1-555-2003', '456 Oak Avenue', 'New York', 'NY', 1, 1),
('James Smith', 'James Smith', 'Sarah Smith', 'Doctor', 'james.smith@email.com', '+1-555-2005', '789 Pine Street', 'New York', 'NY', 1, 1);

-- Insert Sample Students (using only existing fields)
INSERT INTO `student` (`register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `blood_group`, `current_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`) VALUES 
('RIS001', '2024-09-01', 'Emma', 'Wilson', 'Female', '2018-05-15', 'O+', '123 Main Street', 'New York', 'NY', '+1-555-1001', 1, 'emma.wilson@student.com', 1),
('RIS002', '2024-09-01', 'Oliver', 'Garcia', 'Male', '2018-03-22', 'A+', '456 Oak Avenue', 'New York', 'NY', '+1-555-1002', 1, 'oliver.garcia@student.com', 2),
('RIS003', '2024-09-01', 'Sophia', 'Smith', 'Female', '2018-07-10', 'B+', '789 Pine Street', 'New York', 'NY', '+1-555-1003', 2, 'sophia.smith@student.com', 3);

-- Insert Sample Events (using actual event table fields)
INSERT INTO `event` (`title`, `remark`, `status`, `type`, `audition`, `selected_list`, `start_date`, `end_date`, `image`, `created_by`, `session_id`, `branch_id`, `show_web`) VALUES 
('First Day of School', 'Welcome to new academic year 2024-2025', 1, 'school', '', '', '2024-09-01', '2024-09-01', '', 'Admin', 1, 1, 1),
('Parent-Teacher Meeting', 'Monthly meeting with parents to discuss student progress', 1, 'meeting', '', '', '2024-09-15', '2024-09-15', '', 'Admin', 1, 1, 1),
('Annual Science Fair', 'Students showcase their science projects', 1, 'academic', '', '', '2024-10-15', '2024-10-15', '', 'Admin', 1, 1, 1),
('Sports Day', 'Inter-class sports competition and activities', 1, 'sports', '', '', '2024-11-20', '2024-11-20', '', 'Admin', 1, 1, 1);

-- Insert Sample Library Books
INSERT INTO `book` (`name`, `author`, `subject`, `qty`, `available`, `branch_id`) VALUES 
('Elementary Mathematics', 'Dr. Sarah Johnson', 'Mathematics', 25, 25, 1),
('English Grammar & Stories', 'Prof. Michael Brown', 'English', 20, 20, 1),
('Basic Science Experiments', 'Dr. Emily Davis', 'Science', 15, 15, 1),
('World Atlas for Kids', 'Geography Team', 'Social Studies', 18, 18, 1);

-- Insert Book Categories
INSERT INTO `book_category` (`name`, `branch_id`) VALUES 
('Textbooks', 1),
('Reference Books', 1),
('Story Books', 1);

-- Display Success Information
SELECT '🎉 SUCCESS! Sample data inserted successfully!' as '✅ STATUS';
SELECT '' as ' ';
SELECT '📊 SAMPLE DATA SUMMARY' as '📈 OVERVIEW';
SELECT '────────────────────────────────────────────────' as ' ';
SELECT '🏫 School: Ramom International School' as 'INSTITUTION';
SELECT '📚 Classes: 3 grades (Grade 1, 2, 3)' as 'ACADEMICS';  
SELECT '🏛️ Sections: 3 sections (A, B, C)' as 'ORGANIZATION';
SELECT '👨‍🎓 Students: 3 sample students' as 'ENROLLMENT';
SELECT '👨‍👩‍👧‍👦 Parents: 3 parent records' as 'GUARDIANS';
SELECT '📅 Events: 4 school events' as 'ACTIVITIES';
SELECT '📖 Books: 4 library books' as 'LIBRARY';
SELECT '📂 Categories: 2 student categories' as 'CLASSIFICATION';
SELECT '' as '  ';
SELECT '🔐 LOGIN INFORMATION' as '🗝️ ACCESS';
SELECT '────────────────────────────────────────────────' as '  ';
SELECT 'Username: superadmin@ramom.com' as 'ADMIN LOGIN';
SELECT 'Password: 1234' as 'CREDENTIALS';
SELECT '' as '   ';
SELECT '🌐 WEBSITE ACCESS' as '💻 URL';
SELECT '────────────────────────────────────────────────' as '   ';
SELECT 'Local URL: http://localhost/New/main_script_v6.6/main_script_v6.6/' as 'WEBSITE';
SELECT '' as '    ';
SELECT '✅ Your Ramom School Management System is ready!' as '🎓 READY';
