-- SIMPLE WORKING Sample Data for Ramom School Management System

-- Insert school year first (required for foreign key)
INSERT INTO `schoolyear` (`school_year`, `created_by`) VALUES ('2024-2025', 1);

-- Get the session ID we just created
SET @session_id = LAST_INSERT_ID();

-- Insert Sample Classes
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 1', '1', 1),
('Grade 2', '2', 1),
('Grade 3', '3', 1);

-- Insert Sample Sections
INSERT INTO `section` (`name`, `capacity`, `branch_id`) VALUES 
('Section A', '30', 1),
('Section B', '30', 1);

-- Insert Sample Student Categories  
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('Scholarship', 1);

-- Insert Sample Parents
INSERT INTO `parent` (`name`, `father_name`, `mother_name`, `email`, `mobileno`, `address`, `branch_id`, `active`) VALUES 
('Wilson Family', 'Robert Wilson', 'Lisa Wilson', 'wilson@email.com', '+1-555-2001', '123 Main St, NY', 1, 1),
('Garcia Family', 'Carlos Garcia', 'Maria Garcia', 'garcia@email.com', '+1-555-2003', '456 Oak Ave, NY', 1, 1);

-- Insert Sample Students
INSERT INTO `student` (`register_no`, `first_name`, `last_name`, `gender`, `email`, `parent_id`, `category_id`) VALUES 
('RIS001', 'Emma', 'Wilson', 'Female', 'emma@email.com', 1, 1),
('RIS002', 'Oliver', 'Garcia', 'Male', 'oliver@email.com', 2, 1);

-- Insert Sample Library Books
INSERT INTO `book` (`name`, `author`, `subject`, `qty`, `available`, `branch_id`) VALUES 
('Math Basics', 'Dr. Smith', 'Mathematics', 20, 20, 1),
('English Stories', 'Jane Doe', 'English', 15, 15, 1);

-- Success!
SELECT '✅ SUCCESS! Sample data has been added to your Ramom School!' as RESULT;
SELECT '🏫 School: Ramom International School' as SCHOOL;  
SELECT '👨‍🎓 Students: 2 students added' as STUDENTS;
SELECT '👨‍👩‍👧‍👦 Parents: 2 families added' as PARENTS;
SELECT '📚 Classes: Grade 1-3 created' as CLASSES;
SELECT '📖 Books: 2 library books added' as BOOKS;
SELECT '🔑 Login: superadmin@ramom.com / 1234' as LOGIN;
