-- CORRECTED Sample Data for Ramom School Management System
-- Created: August 18, 2025
-- This file contains sample data based on actual table structures

-- Insert Sample Classes
INSERT INTO `class` (`id`, `name`, `name_numeric`, `branch_id`) VALUES 
(1, 'Grade 1', '1', 1),
(2, 'Grade 2', '2', 1),
(3, 'Grade 3', '3', 1),
(4, 'Grade 4', '4', 1),
(5, 'Grade 5', '5', 1);

-- Insert Sample Sections
INSERT INTO `section` (`id`, `name`, `capacity`, `class_id`, `branch_id`) VALUES 
(1, 'A', 30, 1, 1),
(2, 'B', 30, 1, 1),
(3, 'A', 30, 2, 1),
(4, 'B', 30, 2, 1),
(5, 'A', 30, 3, 1);

-- Insert Sample Student Categories
INSERT INTO `student_category` (`id`, `name`, `branch_id`) VALUES 
(1, 'General', 1),
(2, 'SC/ST', 1),
(3, 'OBC', 1);

-- Insert Sample School Years
INSERT INTO `schoolyear` (`id`, `school_year`, `branch_id`) VALUES 
(1, '2024-2025', 1),
(2, '2025-2026', 1);

-- Insert Sample Parents
INSERT INTO `parent` (`id`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_phone`, `guardian_occupation`, `guardian_relation`, `father_photo`, `mother_photo`, `guardian_photo`, `guardian_email`, `guardian_address`, `branch_id`, `created_at`) VALUES 
(1, 'Robert Wilson', '+1-555-2001', 'Software Engineer', 'Lisa Wilson', '+1-555-2002', 'Teacher', 'Robert Wilson', '+1-555-2001', 'Software Engineer', 'Father', 'default.png', 'default.png', 'default.png', 'robert.wilson@email.com', '123 Student St, NY 10001', 1, NOW()),
(2, 'Carlos Garcia', '+1-555-2003', 'Business Owner', 'Maria Garcia', '+1-555-2004', 'Nurse', 'Carlos Garcia', '+1-555-2003', 'Business Owner', 'Father', 'default.png', 'default.png', 'default.png', 'carlos.garcia@email.com', '456 Family Ave, NY 10002', 1, NOW()),
(3, 'Diego Martinez', '+1-555-2005', 'Architect', 'Ana Martinez', '+1-555-2006', 'Doctor', 'Diego Martinez', '+1-555-2005', 'Architect', 'Father', 'default.png', 'default.png', 'default.png', 'diego.martinez@email.com', '789 Learning Ln, NY 10003', 1, NOW());

-- Insert Sample Students
INSERT INTO `student` (`id`, `register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `photo`) VALUES 
(1, 'RIS001', '2024-09-01', 'Emma', 'Wilson', 'Female', '2018-05-15', 'Christianity', 'General', 'O+', 'English', '123 Student St, NY 10001', '123 Student St, NY 10001', 'New York', 'NY', '+1-555-1001', 1, 'emma.wilson@email.com', 1, 'default.png'),
(2, 'RIS002', '2024-09-01', 'Oliver', 'Garcia', 'Male', '2018-03-22', 'Christianity', 'General', 'A+', 'English', '456 Family Ave, NY 10002', '456 Family Ave, NY 10002', 'New York', 'NY', '+1-555-1002', 1, 'oliver.garcia@email.com', 2, 'default.png'),
(3, 'RIS003', '2024-09-01', 'Sophia', 'Martinez', 'Female', '2018-07-10', 'Christianity', 'General', 'B+', 'English', '789 Learning Ln, NY 10003', '789 Learning Ln, NY 10003', 'New York', 'NY', '+1-555-1003', 1, 'sophia.martinez@email.com', 3, 'default.png'),
(4, 'RIS004', '2024-09-01', 'William', 'Anderson', 'Male', '2017-12-01', 'Christianity', 'General', 'AB+', 'English', '321 Education Rd, NY 10004', '321 Education Rd, NY 10004', 'New York', 'NY', '+1-555-1004', 1, 'william.anderson@email.com', 1, 'default.png'),
(5, 'RIS005', '2024-09-01', 'Ava', 'Taylor', 'Female', '2017-09-18', 'Christianity', 'General', 'O-', 'English', '654 Scholar St, NY 10005', '654 Scholar St, NY 10005', 'New York', 'NY', '+1-555-1005', 1, 'ava.taylor@email.com', 2, 'default.png');

-- Insert Sample Student Enrollments
INSERT INTO `enroll` (`id`, `student_id`, `class_id`, `section_id`, `roll`, `subject_id`, `school_year_id`, `branch_id`, `created_at`, `updated_at`) VALUES 
(1, 1, 1, 1, '001', 0, 1, 1, NOW(), NOW()),
(2, 2, 1, 1, '002', 0, 1, 1, NOW(), NOW()),
(3, 3, 1, 2, '003', 0, 1, 1, NOW(), NOW()),
(4, 4, 2, 3, '001', 0, 1, 1, NOW(), NOW()),
(5, 5, 2, 3, '002', 0, 1, 1, NOW(), NOW());

-- Insert Sample Staff/Teachers
INSERT INTO `staff` (`id`, `name`, `staff_id`, `role`, `designation`, `department`, `joining_date`, `phone`, `emergency_contact`, `marital_status`, `photo`, `address`, `qualification`, `experience`, `username`, `password`, `email`, `facebook`, `twitter`, `linkedin`, `resume`, `other_info`, `branch_id`, `status`) VALUES 
(1, 'John Smith', 'TCH001', 'Teacher', 'Principal', 'Administration', '2020-01-15', '+1-555-0124', '+1-555-0124', 'Married', 'default.png', '456 Teacher Lane, NY 10002', 'M.Ed, Ph.D in Education', '15 years', 'john.smith', '$2y$10$OPHOjSFqJvKCZ5RuQJBYJu', 'john.smith@ramomschool.com', '', '', '', '', 'Experienced Principal with strong leadership skills', 1, 1),
(2, 'Sarah Johnson', 'TCH002', 'Teacher', 'Mathematics Teacher', 'Academic', '2021-08-01', '+1-555-0125', '+1-555-0125', 'Single', 'default.png', '789 Academic St, NY 10003', 'M.Sc in Mathematics', '8 years', 'sarah.johnson', '$2y$10$OPHOjSFqJvKCZ5RuQJBYJu', 'sarah.johnson@ramomschool.com', '', '', '', '', 'Passionate Mathematics teacher', 1, 1),
(3, 'Michael Brown', 'TCH003', 'Teacher', 'English Teacher', 'Academic', '2022-01-10', '+1-555-0126', '+1-555-0126', 'Married', 'default.png', '321 Literature Ave, NY 10004', 'M.A in English Literature', '6 years', 'michael.brown', '$2y$10$OPHOjSFqJvKCZ5RuQJBYJu', 'michael.brown@ramomschool.com', '', '', '', '', 'Creative English teacher', 1, 1);

-- Insert Sample Subjects
INSERT INTO `subject` (`id`, `name`, `code`, `type`, `pass_mark`, `final_mark`, `teacher_id`, `branch_id`, `created_at`) VALUES 
(1, 'Mathematics', 'MATH101', 'theory', 40, 100, 2, 1, NOW()),
(2, 'English Language', 'ENG101', 'theory', 40, 100, 3, 1, NOW()),
(3, 'Science', 'SCI101', 'theory', 40, 100, 2, 1, NOW()),
(4, 'Social Studies', 'SS101', 'theory', 40, 100, 3, 1, NOW()),
(5, 'Physical Education', 'PE101', 'practical', 40, 100, 1, 1, NOW());

-- Insert Subject Assignments to Classes
INSERT INTO `subject_assign` (`id`, `class_id`, `section_id`, `subject_id`, `teacher_id`, `school_year_id`, `branch_id`) VALUES 
(1, 1, 1, 1, 2, 1, 1),
(2, 1, 1, 2, 3, 1, 1),
(3, 1, 1, 3, 2, 1, 1),
(4, 1, 2, 1, 2, 1, 1),
(5, 1, 2, 2, 3, 1, 1),
(6, 2, 3, 1, 2, 1, 1),
(7, 2, 3, 2, 3, 1, 1);

-- Insert Sample Events
INSERT INTO `event` (`id`, `title`, `event_for`, `class_id`, `section_id`, `date`, `note`, `branch_id`, `show_web`) VALUES 
(1, 'First Day of School', 'all', NULL, NULL, '2024-09-01', 'Welcome back to school! New academic year begins.', 1, 1),
(2, 'Parent-Teacher Meeting', 'all', NULL, NULL, '2024-09-15', 'Monthly parent-teacher conference.', 1, 1),
(3, 'Science Fair', 'student', NULL, NULL, '2024-10-15', 'Annual science fair for all students.', 1, 1),
(4, 'Sports Day', 'all', NULL, NULL, '2024-11-20', 'Annual sports day with competitions.', 1, 1);

-- Insert Sample Exams
INSERT INTO `exam` (`id`, `name`, `note`, `date_from`, `date_to`, `branch_id`, `created_at`, `updated_at`) VALUES 
(1, 'First Term Exam', 'First term examination for all classes', '2024-11-01', '2024-11-15', 1, NOW(), NOW()),
(2, 'Mid Term Exam', 'Mid term assessment', '2024-12-01', '2024-12-10', 1, NOW(), NOW()),
(3, 'Final Exam', 'Annual final examination', '2025-03-01', '2025-03-20', 1, NOW(), NOW());

-- Insert Sample Fee Groups
INSERT INTO `fee_groups` (`id`, `name`, `description`, `branch_id`, `created_at`) VALUES 
(1, 'Grade 1-2 Fees', 'Fee structure for Grade 1 and 2 students', 1, NOW()),
(2, 'Grade 3-5 Fees', 'Fee structure for Grade 3 to 5 students', 1, NOW());

-- Insert Sample Fee Types
INSERT INTO `fees_type` (`id`, `name`, `description`, `branch_id`, `created_at`) VALUES 
(1, 'Tuition Fee', 'Monthly tuition fee', 1, NOW()),
(2, 'Admission Fee', 'One-time admission fee', 1, NOW()),
(3, 'Transport Fee', 'Monthly transport fee', 1, NOW()),
(4, 'Library Fee', 'Annual library fee', 1, NOW());

-- Insert Sample Fee Groups Details
INSERT INTO `fee_groups_details` (`id`, `fee_groups_id`, `fees_type_id`, `amount`, `due_date`, `created_at`) VALUES 
(1, 1, 1, 500.00, '2024-09-05', NOW()),
(2, 1, 2, 200.00, '2024-09-01', NOW()),
(3, 1, 3, 100.00, '2024-09-05', NOW()),
(4, 1, 4, 50.00, '2024-09-01', NOW()),
(5, 2, 1, 600.00, '2024-09-05', NOW()),
(6, 2, 2, 250.00, '2024-09-01', NOW());

-- Insert Sample Library Books
INSERT INTO `book` (`id`, `name`, `isbn_no`, `author`, `publisher`, `subject`, `rack_no`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `branch_id`) VALUES 
(1, 'Mathematics Grade 1', '978-0123456789', 'Dr. Sarah Math', 'Education Publishers', 'Mathematics', 'A1', 25, 15.99, '2024-08-01', 'Mathematics textbook for Grade 1 students', 25, 1),
(2, 'English Stories for Kids', '978-0123456790', 'Jane Story', 'Kids Books Inc', 'English', 'B1', 20, 12.50, '2024-08-01', 'Collection of short stories for young readers', 20, 1),
(3, 'Science Experiments', '978-0123456791', 'Prof. Mike Science', 'Science World', 'Science', 'C1', 15, 18.75, '2024-08-01', 'Fun science experiments for elementary students', 15, 1);

-- Insert Sample Book Categories
INSERT INTO `book_category` (`id`, `name`, `branch_id`) VALUES 
(1, 'Textbooks', 1),
(2, 'Reference Books', 1),
(3, 'Story Books', 1);

-- Insert Sample Homework
INSERT INTO `homework` (`id`, `class_id`, `section_id`, `subject_id`, `homework_date`, `submit_date`, `marks`, `note`, `branch_id`, `created_at`) VALUES 
(1, 1, 1, 1, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 3 DAY), 10, 'Complete exercises 1-10 from chapter 2', 1, NOW()),
(2, 1, 1, 2, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 2 DAY), 10, 'Write a short essay about your favorite book', 1, NOW());

-- Insert Basic Settings
INSERT INTO `global_settings` (`id`, `academic_year`, `school_name`, `school_title`, `address`, `phone`, `email`, `currency`, `currency_symbol`, `is_rtl`, `theme`, `date_format`, `time_format`, `language`, `timezone`, `session_id`, `is_active`, `updated_at`) VALUES 
(1, '2024-2025', 'Ramom International School', 'Excellence in Education', '123 Education Avenue, Manhattan, NY 10001', '+1-555-0123', 'admin@ramomschool.com', 'USD', '$', 0, 'default', 'd-m-Y', 'g:i A', 'english', 'America/New_York', 1, 1, NOW())
ON DUPLICATE KEY UPDATE 
school_name = 'Ramom International School',
school_title = 'Excellence in Education',
address = '123 Education Avenue, Manhattan, NY 10001',
phone = '+1-555-0123',
email = 'admin@ramomschool.com';

-- Success Messages
SELECT 'Sample data insertion completed successfully!' AS MESSAGE;
SELECT 'Branch: Ramom International School has been created' AS BRANCH_INFO;
SELECT 'Students: 5 sample students added (Emma, Oliver, Sophia, William, Ava)' AS STUDENTS_INFO;
SELECT 'Teachers: 3 sample teachers added (John Smith, Sarah Johnson, Michael Brown)' AS TEACHERS_INFO;
SELECT 'Classes: Grade 1-5 with sections created' AS CLASSES_INFO;
SELECT 'Login with: superadmin@ramom.com / Password: 1234' AS LOGIN_INFO;
