-- Sample Data for Ramom School Management System
-- Created: August 18, 2025
-- This file contains sample data for testing and demonstration purposes

-- First, let's ensure we have a clean branch setup
DELETE FROM branch WHERE id = 1;

-- Insert Sample Branch
INSERT INTO `branch` (`id`, `name`, `school_name`, `email`, `mobileno`, `currency`, `symbol`, `currency_formats`, `symbol_position`, `city`, `state`, `address`, `stu_generate`, `stu_username_prefix`, `stu_default_password`, `grd_generate`, `grd_username_prefix`, `grd_default_password`, `teacher_restricted`, `due_days`, `due_with_fine`, `translation`, `timezone`, `weekends`, `reg_prefix_enable`, `student_login`, `parent_login`, `teacher_mobile_visible`, `teacher_email_visible`, `reg_start_from`, `institution_code`, `reg_prefix_digit`, `offline_payments`, `attendance_type`, `show_own_question`, `status`, `unique_roll`, `created_at`, `updated_at`) VALUES 
(1, 'Main Branch', 'Ramom International School', 'admin@ramomschool.com', '+1-555-0123', 'USD', '$', 1, 1, 'New York', 'New York', '123 Education Avenue, Manhattan, NY 10001', 1, 'STU', '123456', 1, 'TCH', '123456', 1, 30, 1, 'english', 'America/New_York', '1', 1, 1, 1, 1, 1, 1, 'RIS', 4, 1, 0, 0, 1, 1, NOW(), NOW());

-- Insert Sample Classes
INSERT INTO `class` (`id`, `name`, `name_numeric`, `branch_id`) VALUES 
(1, 'Grade 1', '1', 1),
(2, 'Grade 2', '2', 1),
(3, 'Grade 3', '3', 1),
(4, 'Grade 4', '4', 1),
(5, 'Grade 5', '5', 1),
(6, 'Grade 6', '6', 1),
(7, 'Grade 7', '7', 1),
(8, 'Grade 8', '8', 1),
(9, 'Grade 9', '9', 1),
(10, 'Grade 10', '10', 1);

-- Insert Sample Sections
INSERT INTO `section` (`id`, `name`, `class_id`, `capacity`, `branch_id`) VALUES 
(1, 'A', 1, 30, 1),
(2, 'B', 1, 30, 1),
(3, 'A', 2, 30, 1),
(4, 'B', 2, 30, 1),
(5, 'A', 3, 30, 1),
(6, 'A', 4, 30, 1),
(7, 'A', 5, 30, 1),
(8, 'A', 6, 30, 1),
(9, 'A', 7, 30, 1),
(10, 'A', 8, 30, 1),
(11, 'A', 9, 30, 1),
(12, 'A', 10, 30, 1);

-- Insert Sample Subjects
INSERT INTO `subject` (`id`, `name`, `code`, `type`, `pass_mark`, `final_mark`, `class_id`, `branch_id`, `teacher_id`, `created_at`) VALUES 
(1, 'Mathematics', 'MATH101', 'theory', 40, 100, 1, 1, 0, NOW()),
(2, 'English Language', 'ENG101', 'theory', 40, 100, 1, 1, 0, NOW()),
(3, 'Science', 'SCI101', 'theory', 40, 100, 1, 1, 0, NOW()),
(4, 'Social Studies', 'SS101', 'theory', 40, 100, 1, 1, 0, NOW()),
(5, 'Physical Education', 'PE101', 'practical', 40, 100, 1, 1, 0, NOW()),
(6, 'Mathematics', 'MATH201', 'theory', 40, 100, 2, 1, 0, NOW()),
(7, 'English Language', 'ENG201', 'theory', 40, 100, 2, 1, 0, NOW()),
(8, 'Science', 'SCI201', 'theory', 40, 100, 2, 1, 0, NOW()),
(9, 'Social Studies', 'SS201', 'theory', 40, 100, 2, 1, 0, NOW()),
(10, 'Physical Education', 'PE201', 'practical', 40, 100, 2, 1, 0, NOW());

-- Insert Sample Teachers/Staff
INSERT INTO `teacher` (`id`, `name`, `designation`, `qualification`, `experience`, `username`, `password`, `email`, `phone`, `address`, `joining_date`, `photo`, `sex`, `branch_id`, `salary`, `salary_type`, `facebook_url`, `twitter_url`, `linkedin_url`, `resume`, `other_info`, `is_active`, `login_active`, `created_at`, `updated_at`) VALUES 
(1, 'John Smith', 'Principal', 'M.Ed, Ph.D in Education', '15 years', 'john.smith', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 'john.smith@ramomschool.com', '+1-555-0124', '456 Teacher Lane, NY 10002', '2020-01-15', 'default.png', 'male', 1, 5000, 'monthly', '', '', '', '', 'Experienced Principal with strong leadership skills', 1, 1, NOW(), NOW()),
(2, 'Sarah Johnson', 'Mathematics Teacher', 'M.Sc in Mathematics', '8 years', 'sarah.johnson', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 'sarah.johnson@ramomschool.com', '+1-555-0125', '789 Academic St, NY 10003', '2021-08-01', 'default.png', 'female', 1, 3500, 'monthly', '', '', '', '', 'Passionate Mathematics teacher', 1, 1, NOW(), NOW()),
(3, 'Michael Brown', 'English Teacher', 'M.A in English Literature', '6 years', 'michael.brown', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 'michael.brown@ramomschool.com', '+1-555-0126', '321 Literature Ave, NY 10004', '2022-01-10', 'default.png', 'male', 1, 3200, 'monthly', '', '', '', '', 'Creative English teacher with innovative teaching methods', 1, 1, NOW(), NOW()),
(4, 'Emily Davis', 'Science Teacher', 'M.Sc in Biology', '5 years', 'emily.davis', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 'emily.davis@ramomschool.com', '+1-555-0127', '654 Science Blvd, NY 10005', '2022-06-15', 'default.png', 'female', 1, 3300, 'monthly', '', '', '', '', 'Enthusiastic Science teacher', 1, 1, NOW(), NOW());

-- Update subjects to assign teachers
UPDATE `subject` SET `teacher_id` = 2 WHERE `name` LIKE '%Mathematics%';
UPDATE `subject` SET `teacher_id` = 3 WHERE `name` LIKE '%English%';
UPDATE `subject` SET `teacher_id` = 4 WHERE `name` LIKE '%Science%';

-- Insert Sample Students
INSERT INTO `student` (`id`, `admission_no`, `roll`, `admission_date`, `firstname`, `lastname`, `rte`, `category_id`, `class_id`, `section_id`, `parent_id`, `route_id`, `hostel_room_id`, `academic_year`, `reg_no`, `email`, `phone`, `mobileno`, `state`, `city`, `pincode`, `religion`, `cast`, `blood_group`, `student_photo`, `birthday`, `sex`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `is_active`, `previous_school`, `note`, `branch_id`, `is_sibling`, `father_pic`, `mother_pic`, `guardian_pic`, `created_at`, `updated_at`) VALUES 
(1, 'RIS0001', '001', '2024-09-01', 'Emma', 'Wilson', 'No', 1, 1, 1, 1, NULL, NULL, '2024', 'REG001', 'emma.wilson@email.com', '', '+1-555-1001', 'New York', 'Manhattan', '10001', 'Christianity', 'General', 'O+', 'default.png', '2018-05-15', 'female', 'Robert Wilson', '+1-555-2001', 'Software Engineer', 'Lisa Wilson', '+1-555-2002', 'Teacher', 'Robert Wilson', 'Father', '+1-555-2001', 'Software Engineer', '123 Student St, NY 10001', 'robert.wilson@email.com', 1, 'Little Angels Kindergarten', 'Bright and active student', 1, 0, 'default.png', 'default.png', 'default.png', NOW(), NOW()),

(2, 'RIS0002', '002', '2024-09-01', 'Oliver', 'Garcia', 'No', 1, 1, 1, 2, NULL, NULL, '2024', 'REG002', 'oliver.garcia@email.com', '', '+1-555-1002', 'New York', 'Manhattan', '10002', 'Christianity', 'General', 'A+', 'default.png', '2018-03-22', 'male', 'Carlos Garcia', '+1-555-2003', 'Business Owner', 'Maria Garcia', '+1-555-2004', 'Nurse', 'Carlos Garcia', 'Father', '+1-555-2003', 'Business Owner', '456 Family Ave, NY 10002', 'carlos.garcia@email.com', 1, 'Sunshine Preschool', 'Enthusiastic learner', 1, 0, 'default.png', 'default.png', 'default.png', NOW(), NOW()),

(3, 'RIS0003', '003', '2024-09-01', 'Sophia', 'Martinez', 'No', 1, 1, 2, 3, NULL, NULL, '2024', 'REG003', 'sophia.martinez@email.com', '', '+1-555-1003', 'New York', 'Manhattan', '10003', 'Christianity', 'General', 'B+', 'default.png', '2018-07-10', 'female', 'Diego Martinez', '+1-555-2005', 'Architect', 'Ana Martinez', '+1-555-2006', 'Doctor', 'Diego Martinez', 'Father', '+1-555-2005', 'Architect', '789 Learning Ln, NY 10003', 'diego.martinez@email.com', 1, 'Rainbow Kids School', 'Creative and artistic', 1, 0, 'default.png', 'default.png', 'default.png', NOW(), NOW()),

(4, 'RIS0004', '001', '2024-09-01', 'William', 'Anderson', 'No', 1, 2, 3, 4, NULL, NULL, '2024', 'REG004', 'william.anderson@email.com', '', '+1-555-1004', 'New York', 'Manhattan', '10004', 'Christianity', 'General', 'AB+', 'default.png', '2017-12-01', 'male', 'James Anderson', '+1-555-2007', 'Manager', 'Jennifer Anderson', '+1-555-2008', 'Pharmacist', 'James Anderson', 'Father', '+1-555-2007', 'Manager', '321 Education Rd, NY 10004', 'james.anderson@email.com', 1, 'Bright Minds Elementary', 'Good in sports and academics', 1, 0, 'default.png', 'default.png', 'default.png', NOW(), NOW()),

(5, 'RIS0005', '002', '2024-09-01', 'Ava', 'Taylor', 'No', 1, 2, 3, 5, NULL, NULL, '2024', 'REG005', 'ava.taylor@email.com', '', '+1-555-1005', 'New York', 'Manhattan', '10005', 'Christianity', 'General', 'O-', 'default.png', '2017-09-18', 'female', 'David Taylor', '+1-555-2009', 'Engineer', 'Michelle Taylor', '+1-555-2010', 'Lawyer', 'David Taylor', 'Father', '+1-555-2009', 'Engineer', '654 Scholar St, NY 10005', 'david.taylor@email.com', 1, 'Little Scholars Academy', 'Excellent in mathematics', 1, 0, 'default.png', 'default.png', 'default.png', NOW(), NOW());

-- Insert Sample Parents/Guardians
INSERT INTO `guardian` (`id`, `firstname`, `lastname`, `relation`, `email`, `mobileno`, `address`, `profession`, `username`, `password`, `branch_id`, `is_active`, `login_active`, `created_at`, `updated_at`) VALUES 
(1, 'Robert', 'Wilson', 'Father', 'robert.wilson@email.com', '+1-555-2001', '123 Student St, NY 10001', 'Software Engineer', 'robert.wilson', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 1, 1, 1, NOW(), NOW()),
(2, 'Carlos', 'Garcia', 'Father', 'carlos.garcia@email.com', '+1-555-2003', '456 Family Ave, NY 10002', 'Business Owner', 'carlos.garcia', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 1, 1, 1, NOW(), NOW()),
(3, 'Diego', 'Martinez', 'Father', 'diego.martinez@email.com', '+1-555-2005', '789 Learning Ln, NY 10003', 'Architect', 'diego.martinez', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 1, 1, 1, NOW(), NOW()),
(4, 'James', 'Anderson', 'Father', 'james.anderson@email.com', '+1-555-2007', '321 Education Rd, NY 10004', 'Manager', 'james.anderson', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 1, 1, 1, NOW(), NOW()),
(5, 'David', 'Taylor', 'Father', 'david.taylor@email.com', '+1-555-2009', '654 Scholar St, NY 10005', 'Engineer', 'david.taylor', '$2y$10$8nCZdv5B0wr5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5', 1, 1, 1, NOW(), NOW());

-- Insert Sample Categories
INSERT INTO `student_category` (`id`, `name`, `branch_id`) VALUES 
(1, 'General', 1),
(2, 'SC/ST', 1),
(3, 'OBC', 1),
(4, 'Minority', 1);

-- Insert Sample Fee Groups
INSERT INTO `fee_groups` (`id`, `name`, `description`, `branch_id`, `created_at`) VALUES 
(1, 'Grade 1-2 Fees', 'Fee structure for Grade 1 and 2 students', 1, NOW()),
(2, 'Grade 3-5 Fees', 'Fee structure for Grade 3 to 5 students', 1, NOW()),
(3, 'Grade 6-8 Fees', 'Fee structure for Grade 6 to 8 students', 1, NOW()),
(4, 'Grade 9-10 Fees', 'Fee structure for Grade 9 to 10 students', 1, NOW());

-- Insert Sample Fee Types
INSERT INTO `fees_type` (`id`, `name`, `description`, `branch_id`, `created_at`) VALUES 
(1, 'Tuition Fee', 'Monthly tuition fee', 1, NOW()),
(2, 'Admission Fee', 'One-time admission fee', 1, NOW()),
(3, 'Transport Fee', 'Monthly transport fee', 1, NOW()),
(4, 'Library Fee', 'Annual library fee', 1, NOW()),
(5, 'Lab Fee', 'Annual laboratory fee', 1, NOW()),
(6, 'Sports Fee', 'Annual sports fee', 1, NOW());

-- Insert Sample Fee Groups Details
INSERT INTO `fee_groups_details` (`id`, `fee_groups_id`, `fees_type_id`, `amount`, `due_date`, `created_at`) VALUES 
(1, 1, 1, 500.00, '2024-09-05', NOW()),
(2, 1, 2, 200.00, '2024-09-01', NOW()),
(3, 1, 3, 100.00, '2024-09-05', NOW()),
(4, 1, 4, 50.00, '2024-09-01', NOW()),
(5, 2, 1, 600.00, '2024-09-05', NOW()),
(6, 2, 2, 250.00, '2024-09-01', NOW()),
(7, 2, 3, 100.00, '2024-09-05', NOW()),
(8, 2, 4, 50.00, '2024-09-01', NOW()),
(9, 2, 5, 75.00, '2024-09-01', NOW());

-- Insert Sample Fee Allocation (Assign fee groups to students)
INSERT INTO `fee_allocation` (`id`, `student_id`, `fee_groups_id`, `branch_id`, `created_at`) VALUES 
(1, 1, 1, 1, NOW()),
(2, 2, 1, 1, NOW()),
(3, 3, 1, 1, NOW()),
(4, 4, 2, 1, NOW()),
(5, 5, 2, 1, NOW());

-- Insert Sample Events
INSERT INTO `event` (`id`, `title`, `event_for`, `class_id`, `section_id`, `date`, `note`, `branch_id`, `show_web`) VALUES 
(1, 'First Day of School', 'all', NULL, NULL, '2024-09-01', 'Welcome back to school! New academic year begins.', 1, 1),
(2, 'Parent-Teacher Meeting', 'all', NULL, NULL, '2024-09-15', 'Monthly parent-teacher conference to discuss student progress.', 1, 1),
(3, 'Science Fair', 'student', NULL, NULL, '2024-10-15', 'Annual science fair - students will showcase their projects.', 1, 1),
(4, 'Sports Day', 'all', NULL, NULL, '2024-11-20', 'Annual sports day with various competitions and activities.', 1, 1),
(5, 'Winter Break', 'all', NULL, NULL, '2024-12-20', 'Winter holidays begin. School reopens on January 8, 2025.', 1, 1);

-- Insert Sample Exams
INSERT INTO `exam` (`id`, `name`, `note`, `date_from`, `date_to`, `branch_id`, `created_at`, `updated_at`) VALUES 
(1, 'First Term Exam', 'First term examination for all classes', '2024-11-01', '2024-11-15', 1, NOW(), NOW()),
(2, 'Mid Term Exam', 'Mid term assessment', '2024-12-01', '2024-12-10', 1, NOW(), NOW()),
(3, 'Final Exam', 'Annual final examination', '2025-03-01', '2025-03-20', 1, NOW(), NOW());

-- Insert Sample Exam Terms
INSERT INTO `exam_term` (`id`, `name`, `session_id`, `branch_id`) VALUES 
(1, 'First Term', 1, 1),
(2, 'Second Term', 1, 1),
(3, 'Final Term', 1, 1);

-- Insert Sample Attendance Records (for today)
INSERT INTO `student_attendance` (`id`, `student_id`, `class_id`, `section_id`, `subject_id`, `attendance_type_id`, `date`, `branch_id`, `created_at`) VALUES 
(1, 1, 1, 1, 1, 1, CURDATE(), 1, NOW()),
(2, 2, 1, 1, 1, 1, CURDATE(), 1, NOW()),
(3, 3, 1, 2, 1, 1, CURDATE(), 1, NOW()),
(4, 4, 2, 3, 6, 1, CURDATE(), 1, NOW()),
(5, 5, 2, 3, 6, 1, CURDATE(), 1, NOW());

-- Insert Sample Homework/Assignments
INSERT INTO `homework` (`id`, `class_id`, `section_id`, `subject_id`, `homework_date`, `submit_date`, `marks`, `note`, `branch_id`, `created_at`) VALUES 
(1, 1, 1, 1, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 3 DAY), 10, 'Complete exercises 1-10 from chapter 2', 1, NOW()),
(2, 1, 1, 2, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 2 DAY), 10, 'Write a short essay about your favorite book', 1, NOW()),
(3, 2, 3, 6, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 5 DAY), 15, 'Solve word problems from page 45-50', 1, NOW());

-- Insert Sample Library Books
INSERT INTO `book` (`id`, `name`, `isbn_no`, `author`, `publisher`, `subject`, `rack_no`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `branch_id`) VALUES 
(1, 'Mathematics Grade 1', '978-0123456789', 'Dr. Sarah Math', 'Education Publishers', 'Mathematics', 'A1', 25, 15.99, '2024-08-01', 'Mathematics textbook for Grade 1 students', 25, 1),
(2, 'English Stories for Kids', '978-0123456790', 'Jane Story', 'Kids Books Inc', 'English', 'B1', 20, 12.50, '2024-08-01', 'Collection of short stories for young readers', 20, 1),
(3, 'Science Experiments', '978-0123456791', 'Prof. Mike Science', 'Science World', 'Science', 'C1', 15, 18.75, '2024-08-01', 'Fun science experiments for elementary students', 15, 1),
(4, 'World Atlas for Children', '978-0123456792', 'Geography Team', 'Atlas Publishers', 'Geography', 'D1', 10, 22.99, '2024-08-01', 'Colorful world atlas with maps and facts', 10, 1);

-- Insert Sample Book Categories
INSERT INTO `book_category` (`id`, `name`, `branch_id`) VALUES 
(1, 'Textbooks', 1),
(2, 'Reference Books', 1),
(3, 'Story Books', 1),
(4, 'Activity Books', 1);

-- Update books with categories
UPDATE `book` SET `category_id` = 1 WHERE `id` IN (1);
UPDATE `book` SET `category_id` = 3 WHERE `id` IN (2);
UPDATE `book` SET `category_id` = 4 WHERE `id` IN (3);
UPDATE `book` SET `category_id` = 2 WHERE `id` IN (4);

-- Insert Sample User Roles and Permissions
INSERT INTO `role` (`id`, `name`, `branch_id`, `is_default`, `created_at`) VALUES 
(1, 'Administrator', 1, 1, NOW()),
(2, 'Teacher', 1, 1, NOW()),
(3, 'Accountant', 1, 1, NOW()),
(4, 'Librarian', 1, 1, NOW()),
(5, 'Receptionist', 1, 1, NOW());

-- Create default admin user if not exists
INSERT INTO `login_credential` (`id`, `username`, `password`, `role`, `user_id`, `is_active`, `branch_id`, `created_at`, `updated_at`) VALUES 
(1, 'admin', '$2y$10$OPHOjSFqJvKCZ5RuQJBYJuHgJhEZQGILdwLf8b1WQKVHlm1K2g6GC', 'admin', 1, 1, 1, NOW(), NOW());

-- Insert some basic settings
INSERT INTO `global_settings` (`id`, `academic_year`, `school_name`, `school_title`, `address`, `phone`, `email`, `currency`, `currency_symbol`, `is_rtl`, `theme`, `date_format`, `time_format`, `language`, `timezone`, `session_id`, `is_active`, `updated_at`) VALUES 
(1, '2024-2025', 'Ramom International School', 'Excellence in Education', '123 Education Avenue, Manhattan, NY 10001', '+1-555-0123', 'admin@ramomschool.com', 'USD', '$', 0, 'default', 'd-m-Y', 'g:i A', 'english', 'America/New_York', 1, 1, NOW());

-- Success message
SELECT 'Sample data has been successfully inserted!' AS MESSAGE;
SELECT 'You can now log in with username: admin and password: 123456' AS LOGIN_INFO;
SELECT 'Default student login format: STU + roll number (e.g., STU001) with password: 123456' AS STUDENT_LOGIN;
SELECT 'Default parent login format: robert.wilson (parent username) with password: 123456' AS PARENT_LOGIN;
