-- Clean and Fresh Sample Data for Ramom School Management System
-- This will clean existing sample data and insert fresh data

-- Clean existing sample data (keeping the branch we created)
DELETE FROM enroll WHERE branch_id = 1;
DELETE FROM student WHERE id BETWEEN 1 AND 10;
DELETE FROM parent WHERE id BETWEEN 1 AND 10;
DELETE FROM staff WHERE id BETWEEN 1 AND 10;
DELETE FROM subject WHERE id BETWEEN 1 AND 10;
DELETE FROM subject_assign WHERE branch_id = 1;
DELETE FROM class WHERE id BETWEEN 1 AND 10;
DELETE FROM section WHERE id BETWEEN 1 AND 10;
DELETE FROM student_category WHERE id BETWEEN 1 AND 10;
DELETE FROM schoolyear WHERE id BETWEEN 1 AND 10;
DELETE FROM event WHERE id BETWEEN 1 AND 10;
DELETE FROM exam WHERE id BETWEEN 1 AND 10;
DELETE FROM fee_groups WHERE id BETWEEN 1 AND 10;
DELETE FROM fees_type WHERE id BETWEEN 1 AND 10;
DELETE FROM fee_groups_details WHERE id BETWEEN 1 AND 10;
DELETE FROM book WHERE id BETWEEN 1 AND 10;
DELETE FROM book_category WHERE id BETWEEN 1 AND 10;
DELETE FROM homework WHERE id BETWEEN 1 AND 10;

-- Reset auto increment
ALTER TABLE class AUTO_INCREMENT = 1;
ALTER TABLE section AUTO_INCREMENT = 1;
ALTER TABLE student AUTO_INCREMENT = 1;
ALTER TABLE parent AUTO_INCREMENT = 1;
ALTER TABLE staff AUTO_INCREMENT = 1;
ALTER TABLE subject AUTO_INCREMENT = 1;
ALTER TABLE subject_assign AUTO_INCREMENT = 1;
ALTER TABLE student_category AUTO_INCREMENT = 1;
ALTER TABLE schoolyear AUTO_INCREMENT = 1;
ALTER TABLE event AUTO_INCREMENT = 1;
ALTER TABLE exam AUTO_INCREMENT = 1;
ALTER TABLE fee_groups AUTO_INCREMENT = 1;
ALTER TABLE fees_type AUTO_INCREMENT = 1;
ALTER TABLE fee_groups_details AUTO_INCREMENT = 1;
ALTER TABLE book AUTO_INCREMENT = 1;
ALTER TABLE book_category AUTO_INCREMENT = 1;
ALTER TABLE homework AUTO_INCREMENT = 1;
ALTER TABLE enroll AUTO_INCREMENT = 1;

-- Now insert fresh sample data
-- Insert Sample Classes
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 1', '1', 1),
('Grade 2', '2', 1),
('Grade 3', '3', 1),
('Grade 4', '4', 1),
('Grade 5', '5', 1);

-- Insert Sample Sections
INSERT INTO `section` (`name`, `capacity`, `class_id`, `branch_id`) VALUES 
('A', 30, 1, 1),
('B', 30, 1, 1),
('A', 30, 2, 1),
('B', 30, 2, 1),
('A', 30, 3, 1);

-- Insert Sample Student Categories
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('SC/ST', 1),
('OBC', 1);

-- Insert Sample School Years
INSERT INTO `schoolyear` (`school_year`, `branch_id`) VALUES 
('2024-2025', 1),
('2025-2026', 1);

-- Insert Sample Parents
INSERT INTO `parent` (`father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_phone`, `guardian_occupation`, `guardian_relation`, `father_photo`, `mother_photo`, `guardian_photo`, `guardian_email`, `guardian_address`, `branch_id`) VALUES 
('Robert Wilson', '+1-555-2001', 'Software Engineer', 'Lisa Wilson', '+1-555-2002', 'Teacher', 'Robert Wilson', '+1-555-2001', 'Software Engineer', 'Father', 'default.png', 'default.png', 'default.png', 'robert.wilson@email.com', '123 Student St, NY 10001', 1),
('Carlos Garcia', '+1-555-2003', 'Business Owner', 'Maria Garcia', '+1-555-2004', 'Nurse', 'Carlos Garcia', '+1-555-2003', 'Business Owner', 'Father', 'default.png', 'default.png', 'default.png', 'carlos.garcia@email.com', '456 Family Ave, NY 10002', 1),
('Diego Martinez', '+1-555-2005', 'Architect', 'Ana Martinez', '+1-555-2006', 'Doctor', 'Diego Martinez', '+1-555-2005', 'Architect', 'Father', 'default.png', 'default.png', 'default.png', 'diego.martinez@email.com', '789 Learning Ln, NY 10003', 1);

-- Insert Sample Students
INSERT INTO `student` (`register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `religion`, `caste`, `blood_group`, `mother_tongue`, `current_address`, `permanent_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`, `photo`) VALUES 
('RIS001', '2024-09-01', 'Emma', 'Wilson', 'Female', '2018-05-15', 'Christianity', 'General', 'O+', 'English', '123 Student St, NY 10001', '123 Student St, NY 10001', 'New York', 'NY', '+1-555-1001', 1, 'emma.wilson@email.com', 1, 'default.png'),
('RIS002', '2024-09-01', 'Oliver', 'Garcia', 'Male', '2018-03-22', 'Christianity', 'General', 'A+', 'English', '456 Family Ave, NY 10002', '456 Family Ave, NY 10002', 'New York', 'NY', '+1-555-1002', 1, 'oliver.garcia@email.com', 2, 'default.png'),
('RIS003', '2024-09-01', 'Sophia', 'Martinez', 'Female', '2018-07-10', 'Christianity', 'General', 'B+', 'English', '789 Learning Ln, NY 10003', '789 Learning Ln, NY 10003', 'New York', 'NY', '+1-555-1003', 1, 'sophia.martinez@email.com', 3, 'default.png'),
('RIS004', '2024-09-01', 'William', 'Anderson', 'Male', '2017-12-01', 'Christianity', 'General', 'AB+', 'English', '321 Education Rd, NY 10004', '321 Education Rd, NY 10004', 'New York', 'NY', '+1-555-1004', 1, 'william.anderson@email.com', 1, 'default.png'),
('RIS005', '2024-09-01', 'Ava', 'Taylor', 'Female', '2017-09-18', 'Christianity', 'General', 'O-', 'English', '654 Scholar St, NY 10005', '654 Scholar St, NY 10005', 'New York', 'NY', '+1-555-1005', 1, 'ava.taylor@email.com', 2, 'default.png');

-- Insert Sample Staff/Teachers
INSERT INTO `staff` (`name`, `staff_id`, `role`, `designation`, `department`, `joining_date`, `phone`, `emergency_contact`, `marital_status`, `photo`, `address`, `qualification`, `experience`, `username`, `password`, `email`, `facebook`, `twitter`, `linkedin`, `resume`, `other_info`, `branch_id`, `status`) VALUES 
('John Smith', 'TCH001', 'Teacher', 'Principal', 'Administration', '2020-01-15', '+1-555-0124', '+1-555-0124', 'Married', 'default.png', '456 Teacher Lane, NY 10002', 'M.Ed, Ph.D in Education', '15 years', 'john.smith', '$2y$10$OPHOjSFqJvKCZ5RuQJBYJu', 'john.smith@ramomschool.com', '', '', '', '', 'Experienced Principal', 1, 1),
('Sarah Johnson', 'TCH002', 'Teacher', 'Mathematics Teacher', 'Academic', '2021-08-01', '+1-555-0125', '+1-555-0125', 'Single', 'default.png', '789 Academic St, NY 10003', 'M.Sc in Mathematics', '8 years', 'sarah.johnson', '$2y$10$OPHOjSFqJvKCZ5RuQJBYJu', 'sarah.johnson@ramomschool.com', '', '', '', '', 'Math Teacher', 1, 1),
('Michael Brown', 'TCH003', 'Teacher', 'English Teacher', 'Academic', '2022-01-10', '+1-555-0126', '+1-555-0126', 'Married', 'default.png', '321 Literature Ave, NY 10004', 'M.A in English Literature', '6 years', 'michael.brown', '$2y$10$OPHOjSFqJvKCZ5RuQJBYJu', 'michael.brown@ramomschool.com', '', '', '', '', 'English Teacher', 1, 1);

-- Insert Sample Subjects
INSERT INTO `subject` (`name`, `code`, `type`, `pass_mark`, `final_mark`, `teacher_id`, `branch_id`) VALUES 
('Mathematics', 'MATH101', 'theory', 40, 100, 2, 1),
('English Language', 'ENG101', 'theory', 40, 100, 3, 1),
('Science', 'SCI101', 'theory', 40, 100, 2, 1),
('Social Studies', 'SS101', 'theory', 40, 100, 3, 1),
('Physical Education', 'PE101', 'practical', 40, 100, 1, 1);

-- Insert Student Enrollments
INSERT INTO `enroll` (`student_id`, `class_id`, `section_id`, `roll`, `subject_id`, `school_year_id`, `branch_id`) VALUES 
(1, 1, 1, '001', 0, 1, 1),
(2, 1, 1, '002', 0, 1, 1),
(3, 1, 2, '003', 0, 1, 1),
(4, 2, 3, '001', 0, 1, 1),
(5, 2, 3, '002', 0, 1, 1);

-- Insert Sample Events
INSERT INTO `event` (`title`, `event_for`, `class_id`, `section_id`, `date`, `note`, `branch_id`, `show_web`) VALUES 
('First Day of School', 'all', NULL, NULL, '2024-09-01', 'Welcome back! New academic year begins.', 1, 1),
('Parent-Teacher Meeting', 'all', NULL, NULL, '2024-09-15', 'Monthly parent-teacher conference.', 1, 1),
('Science Fair', 'student', NULL, NULL, '2024-10-15', 'Annual science fair.', 1, 1),
('Sports Day', 'all', NULL, NULL, '2024-11-20', 'Annual sports day.', 1, 1);

-- Insert Sample Fee Types
INSERT INTO `fees_type` (`name`, `description`, `branch_id`) VALUES 
('Tuition Fee', 'Monthly tuition fee', 1),
('Admission Fee', 'One-time admission fee', 1),
('Transport Fee', 'Monthly transport fee', 1),
('Library Fee', 'Annual library fee', 1);

-- Insert Sample Fee Groups
INSERT INTO `fee_groups` (`name`, `description`, `branch_id`) VALUES 
('Grade 1-2 Fees', 'Fee structure for Grade 1-2', 1),
('Grade 3-5 Fees', 'Fee structure for Grade 3-5', 1);

-- Insert Sample Library Books
INSERT INTO `book` (`name`, `isbn_no`, `author`, `publisher`, `subject`, `rack_no`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `branch_id`) VALUES 
('Mathematics Grade 1', '978-0123456789', 'Dr. Sarah Math', 'Education Publishers', 'Mathematics', 'A1', 25, 15.99, '2024-08-01', 'Math textbook for Grade 1', 25, 1),
('English Stories', '978-0123456790', 'Jane Story', 'Kids Books Inc', 'English', 'B1', 20, 12.50, '2024-08-01', 'Story collection', 20, 1),
('Science Experiments', '978-0123456791', 'Prof. Science', 'Science World', 'Science', 'C1', 15, 18.75, '2024-08-01', 'Science experiments book', 15, 1);

-- Insert Sample Book Categories
INSERT INTO `book_category` (`name`, `branch_id`) VALUES 
('Textbooks', 1),
('Story Books', 1),
('Reference Books', 1);

-- Success message
SELECT '✅ Fresh sample data has been successfully inserted!' AS MESSAGE;
SELECT '🏫 School: Ramom International School' AS SCHOOL_INFO;
SELECT '👨‍🎓 Students: 5 students added (Emma, Oliver, Sophia, William, Ava)' AS STUDENTS_INFO;
SELECT '👨‍🏫 Teachers: 3 teachers added (John, Sarah, Michael)' AS TEACHERS_INFO;
SELECT '📚 Classes: Grade 1-5 with sections A & B' AS CLASSES_INFO;
SELECT '🔑 Login: superadmin@ramom.com / Password: 1234' AS LOGIN_INFO;
