-- FINAL WORKING Sample Data for Ramom School Management System

-- Add more classes
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 2', '2', 1),
('Grade 3', '3', 1),
('Grade 4', '4', 1);

-- Add sections  
INSERT INTO `section` (`name`, `capacity`, `branch_id`) VALUES 
('A', '30', 1),
('B', '30', 1),
('C', '25', 1);

-- Add student categories
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('Scholarship', 1);

-- Add academic year
INSERT INTO `schoolyear` (`school_year`, `created_by`) VALUES ('2024-2025', 1);

-- Add parents (using correct column names)
INSERT INTO `parent` (`name`, `father_name`, `mother_name`, `email`, `mobileno`, `address`, `city`, `state`, `branch_id`, `active`) VALUES 
('Wilson Family', 'Robert Wilson', 'Lisa Wilson', 'wilson@email.com', '+1-555-2001', '123 Main Street', 'New York', 'NY', 1, 1),
('Garcia Family', 'Carlos Garcia', 'Maria Garcia', 'garcia@email.com', '+1-555-2003', '456 Oak Avenue', 'New York', 'NY', 1, 1),
('Smith Family', 'James Smith', 'Sarah Smith', 'smith@email.com', '+1-555-2005', '789 Pine Street', 'New York', 'NY', 1, 1);

-- Add students
INSERT INTO `student` (`register_no`, `first_name`, `last_name`, `gender`, `email`, `parent_id`, `category_id`, `current_address`, `city`, `state`) VALUES 
('RIS001', 'Emma', 'Wilson', 'Female', 'emma.wilson@email.com', 1, 1, '123 Main Street', 'New York', 'NY'),
('RIS002', 'Oliver', 'Garcia', 'Male', 'oliver.garcia@email.com', 2, 1, '456 Oak Avenue', 'New York', 'NY'),
('RIS003', 'Sophia', 'Smith', 'Female', 'sophia.smith@email.com', 3, 2, '789 Pine Street', 'New York', 'NY');

-- Add library books
INSERT INTO `book` (`name`, `author`, `subject`, `qty`, `available`, `branch_id`) VALUES 
('Elementary Mathematics', 'Dr. Sarah Johnson', 'Mathematics', 25, 25, 1),
('English Grammar & Stories', 'Prof. Michael Brown', 'English', 20, 20, 1),
('Science Experiments', 'Dr. Emily Davis', 'Science', 18, 18, 1),
('World Atlas', 'Geography Team', 'Social Studies', 15, 15, 1);

-- Add book categories
INSERT INTO `book_category` (`name`, `branch_id`) VALUES 
('Textbooks', 1),
('Reference Books', 1),
('Story Books', 1);

-- Success Messages
SELECT '🎉 EXCELLENT! Sample data successfully added!' as '✅ SUCCESS';
SELECT '' as ' ';
SELECT '📋 SAMPLE DATA CREATED:' as '📊 SUMMARY';
SELECT '────────────────────────────────────────' as ' ';
SELECT '🏫 Ramom International School' as 'SCHOOL NAME';
SELECT '📚 4 Classes (Grade 1, 2, 3, 4)' as 'CLASSES';
SELECT '🏛️ 3 Sections (A, B, C)' as 'SECTIONS';
SELECT '👨‍🎓 3 Students (Emma, Oliver, Sophia)' as 'STUDENTS';
SELECT '👨‍👩‍👧‍👦 3 Parent families' as 'PARENTS';
SELECT '📖 4 Library books' as 'BOOKS';
SELECT '📂 2 Student categories' as 'CATEGORIES';
SELECT '🗓️ Academic Year: 2024-2025' as 'SESSION';
SELECT '' as '  ';
SELECT '🔐 ADMIN ACCESS:' as '🗝️ LOGIN';
SELECT '────────────────────────────────────────' as '  ';
SELECT 'Email: superadmin@ramom.com' as 'USERNAME';
SELECT 'Password: 1234' as 'PASSWORD';
SELECT '' as '   ';
SELECT '🌐 WEBSITE URL:' as '💻 ACCESS';
SELECT '────────────────────────────────────────' as '   ';
SELECT 'http://localhost/New/main_script_v6.6/main_script_v6.6/' as 'WEBSITE';
SELECT '' as '    ';
SELECT '✅ Your school management system is now ready!' as '🚀 STATUS';
SELECT 'Start managing students, classes, and school activities!' as '🎓 FEATURES';
