-- Final Simple Sample Data for Ramom School Management System

-- Insert Sample Classes
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 1', '1', 1),
('Grade 2', '2', 1),
('Grade 3', '3', 1);

-- Insert Sample Sections  
INSERT INTO `section` (`name`, `capacity`, `branch_id`) VALUES 
('A', '30', 1),
('B', '30', 1),
('C', '30', 1);

-- Insert Sample Student Categories
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('Scholarship', 1);

-- Insert Sample Parents
INSERT INTO `parent` (`name`, `father_name`, `mother_name`, `occupation`, `email`, `mobileno`, `address`, `city`, `state`, `branch_id`, `active`) VALUES 
('Robert Wilson', 'Robert Wilson', 'Lisa Wilson', 'Engineer', 'robert@email.com', '+1-555-2001', '123 Main St', 'New York', 'NY', 1, 1),
('Carlos Garcia', 'Carlos Garcia', 'Maria Garcia', 'Business Owner', 'carlos@email.com', '+1-555-2003', '456 Oak Ave', 'New York', 'NY', 1, 1),
('James Smith', 'James Smith', 'Sarah Smith', 'Doctor', 'james@email.com', '+1-555-2005', '789 Pine St', 'New York', 'NY', 1, 1);

-- Insert Sample Students
INSERT INTO `student` (`register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `blood_group`, `current_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`) VALUES 
('RIS001', '2024-09-01', 'Emma', 'Wilson', 'Female', '2018-05-15', 'O+', '123 Main St', 'New York', 'NY', '+1-555-1001', 1, 'emma@email.com', 1),
('RIS002', '2024-09-01', 'Oliver', 'Garcia', 'Male', '2018-03-22', 'A+', '456 Oak Ave', 'New York', 'NY', '+1-555-1002', 1, 'oliver@email.com', 2),
('RIS003', '2024-09-01', 'Sophia', 'Smith', 'Female', '2018-07-10', 'B+', '789 Pine St', 'New York', 'NY', '+1-555-1003', 2, 'sophia@email.com', 3);

-- Insert Sample Events
INSERT INTO `event` (`title`, `event_for`, `date`, `note`, `branch_id`) VALUES 
('Welcome Day', 'all', '2024-09-01', 'First day of school - Welcome students!', 1),
('Parent Meeting', 'parent', '2024-09-15', 'Monthly parent-teacher conference', 1),
('Science Fair', 'student', '2024-10-15', 'Annual science project exhibition', 1),
('Sports Day', 'all', '2024-11-20', 'Inter-class sports competition', 1);

-- Insert Sample Library Books
INSERT INTO `book` (`name`, `author`, `subject`, `qty`, `available`, `branch_id`) VALUES 
('Elementary Mathematics', 'Dr. Sarah Math', 'Mathematics', 25, 25, 1),
('Fun with English', 'Jane Writer', 'English', 20, 20, 1),
('Science Wonders', 'Prof. Science', 'Science', 15, 15, 1),
('World Geography', 'Map Explorer', 'Geography', 18, 18, 1);

-- Insert Book Categories
INSERT INTO `book_category` (`name`, `branch_id`) VALUES 
('Textbooks', 1),
('Reference', 1),
('Fiction', 1);

-- Success Messages
SELECT '🎉 SUCCESS! Sample data has been inserted successfully!' as MESSAGE;
SELECT '' as SEPARATOR1;
SELECT '📊 DATA SUMMARY:' as SUMMARY_HEADER;
SELECT '🏫 School Branch: Ramom International School (ID: 1)' as SCHOOL_INFO;
SELECT '👨‍🎓 Students: 3 students (Emma Wilson, Oliver Garcia, Sophia Smith)' as STUDENTS_INFO;
SELECT '👨‍👩‍👧‍👦 Parents: 3 parent records' as PARENTS_INFO;
SELECT '🏛️ Classes: Grade 1, 2, 3 with sections A, B, C' as CLASSES_INFO;
SELECT '📅 Events: 4 school events scheduled' as EVENTS_INFO;
SELECT '📚 Library: 4 books in different subjects' as LIBRARY_INFO;
SELECT '' as SEPARATOR2;
SELECT '🔐 LOGIN CREDENTIALS:' as LOGIN_HEADER;
SELECT 'Superadmin: superadmin@ramom.com' as ADMIN_USERNAME;
SELECT 'Password: 1234' as ADMIN_PASSWORD;
SELECT '' as SEPARATOR3;
SELECT '🌐 ACCESS YOUR SCHOOL:' as ACCESS_HEADER;
SELECT 'URL: http://localhost/New/main_script_v6.6/main_script_v6.6/' as WEBSITE_URL;
SELECT '' as SEPARATOR4;
SELECT '✅ Your school management system is ready to use!' as FINAL_MESSAGE;
