-- WORKING Sample Data with Correct Column Names

-- Add more classes (we know this works)
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 2', '2', 1),
('Grade 3', '3', 1),
('Grade 4', '4', 1);

-- Add sections
INSERT INTO `section` (`name`, `capacity`, `branch_id`) VALUES 
('Section A', '30', 1),
('Section B', '30', 1);

-- Add student categories
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('Scholarship', 1);

-- Add academic year
INSERT INTO `schoolyear` (`school_year`, `created_by`) VALUES ('2024-2025', 1);

-- Add library books with correct column name 'title'
INSERT INTO `book` (`title`, `author`, `total_stock`, `branch_id`) VALUES 
('Elementary Mathematics', 'Dr. Johnson', 25, 1),
('English Grammar', 'Prof. Smith', 20, 1),
('Science Basics', 'Dr. Brown', 18, 1);

-- Add book categories
INSERT INTO `book_category` (`name`, `branch_id`) VALUES 
('Textbooks', 1),
('Reference', 1);

-- Display success
SELECT '🎉 SUCCESS! Sample data added successfully!' as '✅ STATUS';
SELECT '' as ' ';
SELECT '📊 Sample Data Summary:' as 'SUMMARY';
SELECT '• Classes: Grade 1, 2, 3, 4 ✅' as 'CLASSES';
SELECT '• Sections: A & B ✅' as 'SECTIONS';
SELECT '• Categories: General & Scholarship ✅' as 'CATEGORIES';
SELECT '• Books: 3 library books ✅' as 'BOOKS';
SELECT '• Academic Year: 2024-2025 ✅' as 'YEAR';
SELECT '' as '  ';
SELECT '🔐 Login Credentials:' as 'LOGIN';
SELECT 'Username: superadmin@ramom.com' as 'USER';
SELECT 'Password: 1234' as 'PASS';
SELECT '' as '   ';
SELECT '🌐 Access URL:' as 'URL';
SELECT 'http://localhost/New/main_script_v6.6/main_script_v6.6/' as 'LINK';
SELECT '' as '    ';
SELECT '✅ Your Ramom School Management System is ready!' as 'READY';
