-- FINAL Working Sample Data for Ramom School Management System

-- First, insert school year (required for events)
INSERT INTO `schoolyear` (`school_year`, `branch_id`) VALUES ('2024-2025', 1);

-- Insert Sample Classes
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 1', '1', 1),
('Grade 2', '2', 1),
('Grade 3', '3', 1);

-- Insert Sample Sections
INSERT INTO `section` (`name`, `capacity`, `branch_id`) VALUES 
('A', '30', 1),
('B', '30', 1),
('C', '30', 1);

-- Insert Sample Student Categories
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('Scholarship', 1);

-- Insert Sample Parents
INSERT INTO `parent` (`name`, `father_name`, `mother_name`, `occupation`, `email`, `mobileno`, `address`, `city`, `state`, `branch_id`, `active`) VALUES 
('Robert Wilson', 'Robert Wilson', 'Lisa Wilson', 'Software Engineer', 'robert.wilson@email.com', '+1-555-2001', '123 Main Street', 'New York', 'NY', 1, 1),
('Carlos Garcia', 'Carlos Garcia', 'Maria Garcia', 'Business Owner', 'carlos.garcia@email.com', '+1-555-2003', '456 Oak Avenue', 'New York', 'NY', 1, 1),
('James Smith', 'James Smith', 'Sarah Smith', 'Doctor', 'james.smith@email.com', '+1-555-2005', '789 Pine Street', 'New York', 'NY', 1, 1);

-- Insert Sample Students
INSERT INTO `student` (`register_no`, `admission_date`, `first_name`, `last_name`, `gender`, `birthday`, `blood_group`, `current_address`, `city`, `state`, `mobileno`, `category_id`, `email`, `parent_id`) VALUES 
('RIS001', '2024-09-01', 'Emma', 'Wilson', 'Female', '2018-05-15', 'O+', '123 Main Street', 'New York', 'NY', '+1-555-1001', 1, 'emma.wilson@student.com', 1),
('RIS002', '2024-09-01', 'Oliver', 'Garcia', 'Male', '2018-03-22', 'A+', '456 Oak Avenue', 'New York', 'NY', '+1-555-1002', 1, 'oliver.garcia@student.com', 2),
('RIS003', '2024-09-01', 'Sophia', 'Smith', 'Female', '2018-07-10', 'B+', '789 Pine Street', 'New York', 'NY', '+1-555-1003', 2, 'sophia.smith@student.com', 3);

-- Insert Sample Events (using session_id = 1 which we just created)
INSERT INTO `event` (`title`, `remark`, `status`, `type`, `audition`, `selected_list`, `start_date`, `end_date`, `image`, `created_by`, `session_id`, `branch_id`, `show_web`) VALUES 
('Welcome Day', 'First day of school - Welcome to new academic year', 1, 'school', '', '', '2024-09-01', '2024-09-01', '', 'Admin', 1, 1, 1),
('Parent Meeting', 'Monthly parent-teacher conference', 1, 'meeting', '', '', '2024-09-15', '2024-09-15', '', 'Admin', 1, 1, 1),
('Science Fair', 'Annual science project exhibition', 1, 'academic', '', '', '2024-10-15', '2024-10-15', '', 'Admin', 1, 1, 1),
('Sports Day', 'Inter-class sports and games competition', 1, 'sports', '', '', '2024-11-20', '2024-11-20', '', 'Admin', 1, 1, 1);

-- Insert Sample Library Books
INSERT INTO `book` (`name`, `author`, `subject`, `qty`, `available`, `branch_id`) VALUES 
('Elementary Mathematics', 'Dr. Sarah Johnson', 'Mathematics', 25, 25, 1),
('English Stories', 'Prof. Michael Brown', 'English', 20, 20, 1),
('Science Fun', 'Dr. Emily Davis', 'Science', 15, 15, 1),
('World Geography', 'Atlas Team', 'Social Studies', 18, 18, 1);

-- Insert Book Categories
INSERT INTO `book_category` (`name`, `branch_id`) VALUES 
('Textbooks', 1),
('Reference', 1),
('Fiction', 1);

-- Success Messages
SELECT '🎉 CONGRATULATIONS! Sample data inserted successfully!' as '✅ SUCCESS STATUS';
SELECT '' as ' ';
SELECT '📋 DATA SUMMARY:' as '📊 OVERVIEW';
SELECT '──────────────────────────────────────────' as ' ';
SELECT '🏫 School Branch: Ramom International School (ID: 1)' as 'INSTITUTION';
SELECT '📚 Classes: Grade 1, 2, 3' as 'ACADEMICS';
SELECT '🏛️ Sections: A, B, C (30 students each)' as 'SECTIONS';
SELECT '👨‍🎓 Students: 3 students (Emma, Oliver, Sophia)' as 'STUDENTS';
SELECT '👨‍👩‍👧‍👦 Parents: 3 parent records' as 'PARENTS';
SELECT '📅 Events: 4 school events scheduled' as 'EVENTS';
SELECT '📖 Library: 4 books across different subjects' as 'LIBRARY';
SELECT '📂 Categories: General & Scholarship' as 'STUDENT TYPES';
SELECT '🗓️ Academic Year: 2024-2025' as 'SESSION';
SELECT '' as '  ';
SELECT '🔐 ADMIN LOGIN CREDENTIALS:' as '🗝️ ACCESS INFO';
SELECT '──────────────────────────────────────────' as '  ';
SELECT 'Email: superadmin@ramom.com' as 'USERNAME';
SELECT 'Password: 1234' as 'PASSWORD';
SELECT '' as '   ';
SELECT '🌐 ACCESS YOUR SCHOOL SYSTEM:' as '💻 WEBSITE';
SELECT '──────────────────────────────────────────' as '   ';
SELECT 'http://localhost/New/main_script_v6.6/main_script_v6.6/' as 'URL';
SELECT '' as '    ';
SELECT '✅ Your Ramom School Management System is now ready!' as '🚀 FINAL STATUS';
SELECT 'You can now manage students, teachers, classes, and more!' as '🎓 FEATURES';
