-- Basic Sample Data that WORKS!

-- Add more classes
INSERT INTO `class` (`name`, `name_numeric`, `branch_id`) VALUES 
('Grade 2', '2', 1),
('Grade 3', '3', 1),
('Grade 4', '4', 1),
('Grade 5', '5', 1);

-- Add sections
INSERT INTO `section` (`name`, `capacity`, `branch_id`) VALUES 
('A', '30', 1),
('B', '30', 1),
('C', '25', 1);

-- Add student categories
INSERT INTO `student_category` (`name`, `branch_id`) VALUES 
('General', 1),
('Scholarship', 1),
('Special Needs', 1);

-- Add academic year
INSERT INTO `schoolyear` (`school_year`, `created_by`) VALUES ('2024-2025', 1);

-- Add some basic parent records (using minimal fields)
INSERT INTO `parent` (`father_name`, `mother_name`, `email`, `mobileno`, `branch_id`, `active`) VALUES 
('John Wilson', 'Mary Wilson', 'wilson@email.com', '+1-555-1001', 1, 1),
('Mike Garcia', 'Ana Garcia', 'garcia@email.com', '+1-555-1002', 1, 1),
('David Smith', 'Lisa Smith', 'smith@email.com', '+1-555-1003', 1, 1);

-- Add students (using minimal required fields)
INSERT INTO `student` (`register_no`, `first_name`, `last_name`, `gender`, `email`, `parent_id`, `category_id`) VALUES 
('STU001', 'Emma', 'Wilson', 'Female', 'emma.wilson@email.com', 1, 1),
('STU002', 'Oliver', 'Garcia', 'Male', 'oliver.garcia@email.com', 2, 1),
('STU003', 'Sophia', 'Smith', 'Female', 'sophia.smith@email.com', 3, 2);

-- Add library books
INSERT INTO `book` (`name`, `author`, `subject`, `qty`, `available`, `branch_id`) VALUES 
('Elementary Mathematics', 'Dr. Johnson', 'Mathematics', 25, 25, 1),
('Fun with English', 'Prof. Brown', 'English', 20, 20, 1),
('Science Discovery', 'Dr. Davis', 'Science', 18, 18, 1),
('World Geography', 'Map Team', 'Geography', 15, 15, 1);

-- Add book categories
INSERT INTO `book_category` (`name`, `branch_id`) VALUES 
('Textbooks', 1),
('Reference', 1),
('Fiction', 1),
('Educational', 1);

-- Show success message
SELECT '🎉 SUCCESS! Your Ramom School now has sample data!' as '✅ STATUS';
SELECT '' as ' ';
SELECT '📊 What was added:' as 'SUMMARY';
SELECT '• 5 Classes (Grade 1-5)' as 'CLASSES';
SELECT '• 3 Sections (A, B, C)' as 'SECTIONS';  
SELECT '• 3 Student categories' as 'CATEGORIES';
SELECT '• 3 Students (Emma, Oliver, Sophia)' as 'STUDENTS';
SELECT '• 3 Parent records' as 'PARENTS';
SELECT '• 4 Library books' as 'LIBRARY';
SELECT '• 1 Academic year (2024-2025)' as 'SESSION';
SELECT '' as '  ';
SELECT '🔐 Login Information:' as 'LOGIN';
SELECT 'Username: superadmin@ramom.com' as 'USER';
SELECT 'Password: 1234' as 'PASS';
SELECT '' as '   ';
SELECT '🌐 Access your school at:' as 'URL';
SELECT 'http://localhost/New/main_script_v6.6/main_script_v6.6/' as 'LINK';
SELECT '' as '    ';
SELECT '✅ Your school management system is ready to use!' as '🚀 READY';
