<?php
/**
 * Simple test script to verify image upload functionality
 * This script checks if the upload directories are writable and accessible
 */

echo "<h2>Customer Image Upload System Test</h2>";

// Check upload directories
$baseUploadDir = 'uploads/';
$customerUploadDir = $baseUploadDir . 'customers/';
$photoUploadDir = $customerUploadDir . 'photos/';
$idProofUploadDir = $customerUploadDir . 'idproofs/';

$directories = [
    'Base Upload' => $baseUploadDir,
    'Customer Upload' => $customerUploadDir,
    'Photos' => $photoUploadDir,
    'ID Proofs' => $idProofUploadDir
];

echo "<h3>Directory Status:</h3>";
echo "<table border='1' cellpadding='5' cellspacing='0'>";
echo "<tr><th>Directory</th><th>Path</th><th>Exists</th><th>Writable</th><th>Status</th></tr>";

foreach ($directories as $name => $path) {
    $exists = is_dir($path);
    $writable = $exists ? is_writable($path) : false;
    $status = ($exists && $writable) ? "✅ OK" : "❌ Issue";
    
    echo "<tr>";
    echo "<td>$name</td>";
    echo "<td>$path</td>";
    echo "<td>" . ($exists ? "Yes" : "No") . "</td>";
    echo "<td>" . ($writable ? "Yes" : "No") . "</td>";
    echo "<td>$status</td>";
    echo "</tr>";
    
    // Try to create directory if it doesn't exist
    if (!$exists) {
        if (mkdir($path, 0755, true)) {
            echo "<tr><td colspan='5' style='color: green;'>✅ Created directory: $path</td></tr>";
        } else {
            echo "<tr><td colspan='5' style='color: red;'>❌ Failed to create directory: $path</td></tr>";
        }
    }
}

echo "</table>";

// Check PHP upload settings
echo "<h3>PHP Upload Configuration:</h3>";
echo "<table border='1' cellpadding='5' cellspacing='0'>";
echo "<tr><th>Setting</th><th>Value</th><th>Recommended</th></tr>";

$settings = [
    'file_uploads' => ['current' => ini_get('file_uploads') ? 'On' : 'Off', 'recommended' => 'On'],
    'upload_max_filesize' => ['current' => ini_get('upload_max_filesize'), 'recommended' => '≥5M'],
    'post_max_size' => ['current' => ini_get('post_max_size'), 'recommended' => '≥10M'],
    'max_file_uploads' => ['current' => ini_get('max_file_uploads'), 'recommended' => '≥20'],
    'memory_limit' => ['current' => ini_get('memory_limit'), 'recommended' => '≥128M']
];

foreach ($settings as $setting => $values) {
    echo "<tr>";
    echo "<td>$setting</td>";
    echo "<td>{$values['current']}</td>";
    echo "<td>{$values['recommended']}</td>";
    echo "</tr>";
}

echo "</table>";

// Test sample image creation
echo "<h3>Sample Test:</h3>";
echo "<p>You can use this form to test image upload:</p>";

if ($_POST && isset($_FILES['test_image'])) {
    echo "<div style='background: #f0f0f0; padding: 10px; margin: 10px 0;'>";
    echo "<h4>Upload Test Result:</h4>";
    
    $file = $_FILES['test_image'];
    echo "<p><strong>File Name:</strong> " . htmlspecialchars($file['name']) . "</p>";
    echo "<p><strong>File Size:</strong> " . number_format($file['size'] / 1024, 2) . " KB</p>";
    echo "<p><strong>File Type:</strong> " . htmlspecialchars($file['type']) . "</p>";
    echo "<p><strong>Error Code:</strong> " . $file['error'] . "</p>";
    
    if ($file['error'] === 0) {
        $targetDir = $photoUploadDir;
        $targetFile = $targetDir . 'test_' . time() . '_' . basename($file['name']);
        
        if (move_uploaded_file($file['tmp_name'], $targetFile)) {
            echo "<p style='color: green;'>✅ <strong>Success!</strong> File uploaded to: $targetFile</p>";
            if (in_array(strtolower(pathinfo($targetFile, PATHINFO_EXTENSION)), ['jpg', 'jpeg', 'png', 'gif'])) {
                echo "<p>Preview: <br><img src='$targetFile' style='max-width: 200px; max-height: 200px; border: 1px solid #ccc;'></p>";
            }
        } else {
            echo "<p style='color: red;'>❌ <strong>Failed!</strong> Could not move uploaded file.</p>";
        }
    } else {
        echo "<p style='color: red;'>❌ <strong>Upload Error:</strong> " . $file['error'] . "</p>";
    }
    echo "</div>";
}

?>

<form method="POST" enctype="multipart/form-data" style="background: #f9f9f9; padding: 15px; border: 1px solid #ddd;">
    <h4>Test Image Upload:</h4>
    <p>
        <label>Select an image file (max 5MB):</label><br>
        <input type="file" name="test_image" accept="image/*" required>
    </p>
    <p>
        <button type="submit" style="background: #007bff; color: white; padding: 8px 16px; border: none; border-radius: 4px;">
            Upload Test Image
        </button>
    </p>
</form>

<hr>
<p><a href="customers.php">← Back to Customer Management</a></p>