<?php
session_start();

// Check if config file exists
$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found. Please create includes/config.php");
}

include_once($configPath);
include_once(__DIR__ . '/includes/brand.php');

// Check if database connection exists
if (!isset($con) || !$con) {
    die("Error: Database connection failed. Please check your database configuration.");
}

if (!isset($_SESSION['uid']) || $_SESSION['usertype'] != 'admin') {
    header('location:logout.php');
    exit();
}

$msg = "";

// Create uploads directory for logo
$logoUploadDir = 'uploads/shop/';
if (!file_exists($logoUploadDir)) {
    mkdir($logoUploadDir, 0777, true);
}

// Function to handle logo upload
function handleLogoUpload($file, $uploadDir) {
    if (!isset($file) || $file['error'] != 0) {
        return '';
    }
    
    // Validate file size (2MB max)
    if ($file['size'] > 2 * 1024 * 1024) {
        return false;
    }
    
    $fileExtension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif'];
    
    if (!in_array($fileExtension, $allowedExtensions)) {
        return false;
    }
    
    $fileName = 'shop_logo_' . time() . '.' . $fileExtension;
    $filePath = $uploadDir . $fileName;
    
    if (move_uploaded_file($file['tmp_name'], $filePath)) {
        return $filePath;
    }
    
    return false;
}

// Handle form submission
if ($_POST) {
    if (isset($_POST['save_shop_details'])) {
        $shopName = mysqli_real_escape_string($con, $_POST['shop_name']);
        $shopNameTamil = mysqli_real_escape_string($con, $_POST['shop_name_tamil']);
        $address = mysqli_real_escape_string($con, $_POST['address']);
        $addressTamil = mysqli_real_escape_string($con, $_POST['address_tamil']);
        $mobileNumber = mysqli_real_escape_string($con, $_POST['mobile_number']);
        $phoneNumber = mysqli_real_escape_string($con, $_POST['phone_number']);
        $email = mysqli_real_escape_string($con, $_POST['email']);
        $website = mysqli_real_escape_string($con, $_POST['website']);
        $licenseNumber = mysqli_real_escape_string($con, $_POST['license_number']);
        $gstNumber = mysqli_real_escape_string($con, $_POST['gst_number']);
        $footerNote = mysqli_real_escape_string($con, $_POST['footer_note']);
        $footerNoteTamil = mysqli_real_escape_string($con, $_POST['footer_note_tamil']);
        
        // Check if shop details exist
        $checkQuery = mysqli_query($con, "SELECT ID, LogoPath FROM tblshopdetails WHERE IsActive = 1 LIMIT 1");
        $existingShop = mysqli_fetch_assoc($checkQuery);
        
        $logoPath = $existingShop ? $existingShop['LogoPath'] : '';
        
        // Handle logo upload
        if (isset($_FILES['logo']) && $_FILES['logo']['error'] == 0) {
            $newLogoPath = handleLogoUpload($_FILES['logo'], $logoUploadDir);
            if ($newLogoPath === false) {
                $msg = "Error uploading logo. Please check file size (max 2MB) and format (jpg, png, gif).";
            } else {
                // Delete old logo
                if ($logoPath && file_exists($logoPath)) {
                    unlink($logoPath);
                }
                $logoPath = $newLogoPath;
            }
        }
        
        if (!$msg) {
            if ($existingShop) {
                // Update existing
                $query = "UPDATE tblshopdetails SET 
                          ShopName='$shopName', ShopNameTamil='$shopNameTamil', 
                          Address='$address', AddressTamil='$addressTamil',
                          MobileNumber='$mobileNumber', PhoneNumber='$phoneNumber',
                          Email='$email', Website='$website',
                          LicenseNumber='$licenseNumber', GSTNumber='$gstNumber',
                          LogoPath='$logoPath', FooterNote='$footerNote', FooterNoteTamil='$footerNoteTamil'
                          WHERE ID=" . $existingShop['ID'];
            } else {
                // Insert new
                $query = "INSERT INTO tblshopdetails (ShopName, ShopNameTamil, Address, AddressTamil, MobileNumber, PhoneNumber, Email, Website, LicenseNumber, GSTNumber, LogoPath, FooterNote, FooterNoteTamil) 
                          VALUES ('$shopName', '$shopNameTamil', '$address', '$addressTamil', '$mobileNumber', '$phoneNumber', '$email', '$website', '$licenseNumber', '$gstNumber', '$logoPath', '$footerNote', '$footerNoteTamil')";
            }
            
            if (mysqli_query($con, $query)) {
                $msg = "Shop details saved successfully!";
            } else {
                $msg = "Error saving shop details: " . mysqli_error($con);
            }
        }
    }
}

// Get current shop details
$shopQuery = mysqli_query($con, "SELECT * FROM tblshopdetails WHERE IsActive = 1 LIMIT 1");
$shopDetails = mysqli_fetch_assoc($shopQuery);

// Helper function to safely output values
function safeOutput($value) {
    return htmlspecialchars($value ?? '');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Shop Details'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/compact.css" rel="stylesheet">
    <style>
        .form-section {
            background: #f8f9fc;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .section-title {
            color: #5a5c69;
            font-weight: bold;
            margin-bottom: 15px;
            border-bottom: 2px solid #e3e6f0;
            padding-bottom: 5px;
        }
        .logo-preview {
            max-width: 150px;
            max-height: 150px;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 5px;
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid">
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Shop Details Management</h1>
                    </div>
                    
                    <?php if($msg) { ?>
                        <div class="alert alert-info"><?php echo $msg; ?></div>
                    <?php } ?>
                    
                    <!-- Shop Details Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="fas fa-store"></i> Shop Information
                            </h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" enctype="multipart/form-data">
                                <!-- Basic Information -->
                                <div class="form-section">
                                    <h5 class="section-title"><i class="fas fa-info-circle"></i> Basic Information</h5>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Shop Name (English) <span class="text-danger">*</span></label>
                                                <input type="text" name="shop_name" class="form-control" required
                                                       value="<?php echo safeOutput($shopDetails['ShopName'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Shop Name (Tamil)</label>
                                                <input type="text" name="shop_name_tamil" class="form-control"
                                                       value="<?php echo safeOutput($shopDetails['ShopNameTamil'] ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Address (English)</label>
                                                <textarea name="address" class="form-control" rows="3"><?php echo safeOutput($shopDetails['Address'] ?? ''); ?></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Address (Tamil)</label>
                                                <textarea name="address_tamil" class="form-control" rows="3"><?php echo safeOutput($shopDetails['AddressTamil'] ?? ''); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Contact Information -->
                                <div class="form-section">
                                    <h5 class="section-title"><i class="fas fa-phone"></i> Contact Information</h5>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Mobile Number <span class="text-danger">*</span></label>
                                                <input type="text" name="mobile_number" class="form-control" required
                                                       value="<?php echo safeOutput($shopDetails['MobileNumber'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Phone Number</label>
                                                <input type="text" name="phone_number" class="form-control"
                                                       value="<?php echo safeOutput($shopDetails['PhoneNumber'] ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Email</label>
                                                <input type="email" name="email" class="form-control"
                                                       value="<?php echo safeOutput($shopDetails['Email'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Website</label>
                                                <input type="url" name="website" class="form-control"
                                                       value="<?php echo safeOutput($shopDetails['Website'] ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Legal Information -->
                                <div class="form-section">
                                    <h5 class="section-title"><i class="fas fa-certificate"></i> Legal Information</h5>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>License Number</label>
                                                <input type="text" name="license_number" class="form-control"
                                                       value="<?php echo safeOutput($shopDetails['LicenseNumber'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>GST Number</label>
                                                <input type="text" name="gst_number" class="form-control"
                                                       value="<?php echo safeOutput($shopDetails['GSTNumber'] ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Logo and Footer -->
                                <div class="form-section">
                                    <h5 class="section-title"><i class="fas fa-image"></i> Logo & Footer</h5>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Shop Logo</label>
                                                <input type="file" name="logo" class="form-control-file" accept="image/*">
                                                <small class="form-text text-muted">Max file size: 2MB. Allowed: JPG, PNG, GIF</small>
                                                <?php if($shopDetails && !empty($shopDetails['LogoPath'])) { ?>
                                                    <br><img src="<?php echo safeOutput($shopDetails['LogoPath']); ?>" class="logo-preview mt-2" alt="Current Logo">
                                                    <br><small class="text-muted">Current Logo</small>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Footer Note (English)</label>
                                                <textarea name="footer_note" class="form-control" rows="3"><?php echo safeOutput($shopDetails['FooterNote'] ?? ''); ?></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label>Footer Note (Tamil)</label>
                                                <textarea name="footer_note_tamil" class="form-control" rows="3"><?php echo safeOutput($shopDetails['FooterNoteTamil'] ?? ''); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <button type="submit" name="save_shop_details" class="btn btn-primary btn-lg">
                                    <i class="fas fa-save"></i> Save Shop Details
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
