<?php
session_start();

$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found.");
}

include_once($configPath);
include_once(__DIR__ . '/includes/brand.php');

if (!isset($con) || !$con) {
    die("Error: Database connection failed.");
}

if (!isset($_GET['id'])) {
    die("Error: Collection ID not provided.");
}

$collectionId = (int)$_GET['id'];

// Get shop details
$shopQuery = mysqli_query($con, "SELECT * FROM tblshopdetails WHERE IsActive = 1 LIMIT 1");
$shopDetails = mysqli_fetch_assoc($shopQuery);

// Get collection details with related data
$query = "SELECT pc.*, p.PawnCode, p.ItemDescription, p.ItemWeight, p.ItemType, p.LoanAmount, p.InterestRate, p.LoanDate, p.DueDate, p.ItemPhotoPath,
          c.Name, c.MobileNumber, c.CustomerCode, c.Address, c.PhotoPath as CustomerPhotoPath,
          COALESCE(u.FullName, u.UserName, 'System User') as CollectedBy
          FROM tblpaymentcollections pc
          JOIN tblpawntransactions p ON pc.PawnTransactionID = p.ID
          JOIN tblcustomers c ON pc.CustomerID = c.ID
          LEFT JOIN tblusers u ON pc.CreatedBy = u.ID
          WHERE pc.ID = $collectionId";

$result = mysqli_query($con, $query);
$collection = mysqli_fetch_assoc($result);

if (!$collection) {
    die("Error: Collection record not found.");
}

// Mark receipt as printed
mysqli_query($con, "UPDATE tblpaymentcollections SET ReceiptPrinted = 1 WHERE ID = $collectionId");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Payment Receipt - <?php echo $collection['CollectionCode']; ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        @page {
            size: A4;
            margin: 20mm 20mm 20mm 20mm;
            margin-top: 50mm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 14pt;
            line-height: 1.6;
            color: #333;
            margin-top: 5cm;
        }
        
        .receipt-container {
            width: 100%;
            max-width: 210mm;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
        }
        
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .receipt-title {
            font-size: 18pt;
            font-weight: bold;
            background: #f8f9fa;
            padding: 10px;
            border: 1px solid #dee2e6;
            color: #495057;
        }
        
        .customer-photo {
            max-height: 120px;
            max-width: 100px;
            border: 1px solid #ccc;
            padding: 2px;
            border-radius: 4px;
        }
        
        .receipt-info {
            display: flex;
            justify-content: space-between;
            margin: 8px 0;
            font-size: 10px;
        }
        
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin: 8px 0;
        }
        
        .info-table td {
            padding: 2px 3px;
            border-bottom: 1px dotted #666;
            font-size: 10px;
        }
        
        .info-table .label {
            font-weight: bold;
            width: 55%;
        }
        
        .amount-section {
            border: 2px solid #333;
            padding: 8px;
            margin: 12px 0;
            background: #f9f9f9;
        }
        
        .amount-row {
            display: flex;
            justify-content: space-between;
            margin: 3px 0;
            font-size: 10px;
        }
        
        .total-row {
            font-weight: bold;
            font-size: 12px;
            border-top: 1px solid #333;
            padding-top: 4px;
        }
        
        .footer {
            margin-top: 15px;
            text-align: center;
            font-size: 9px;
            border-top: 1px dotted #666;
            padding-top: 8px;
        }
        
        .signature-section {
            display: flex;
            justify-content: space-between;
            margin-top: 15px;
            font-size: 10px;
        }
        
        .signature-box {
            text-align: center;
            width: 48%;
        }
        
        .signature-line {
            border-bottom: 1px solid #333;
            height: 25px;
            margin-bottom: 3px;
        }
        
        .back-button {
            position: fixed;
            top: 10px;
            left: 10px;
            padding: 8px 15px;
            background: #6c757d;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            font-size: 12px;
        }
        
        .print-button {
            position: fixed;
            top: 10px;
            right: 10px;
            padding: 8px 15px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
        }
        
        @media print {
            .no-print { 
                display: none; 
            }
            
            body {
                margin: 0;
                padding: 0;
            }
            
            .receipt-container {
                border: none;
                margin: 0;
                padding: 3mm;
            }
        }
    </style>
</head>
<body>
    <a href="due_collection.php" class="back-button no-print">← Back</a>
    <button class="print-button no-print" onclick="window.print()">🖨️ Print</button>
    
    <div class="receipt-container">
        <!-- Header -->
        <div class="header">
            <div class="receipt-title">Payment Receipt</div>
        </div>
        
        <!-- Receipt Info -->
        <div class="receipt-info">
            <div><strong>Receipt No:</strong> <?php echo htmlspecialchars($collection['CollectionCode']); ?></div>
            <div><strong>Date:</strong> <?php echo date('d/m/Y', strtotime($collection['CollectionDate'])); ?></div>
        </div>
        
        <!-- Customer Details -->
        <table class="info-table">
            <tr>
                <td class="label">Customer Name:</td>
                <td><?php echo htmlspecialchars($collection['Name']); ?></td>
            </tr>
            <tr>
                <td class="label">Mobile Number:</td>
                <td><?php echo htmlspecialchars($collection['MobileNumber']); ?></td>
            </tr>
            <tr>
                <td class="label">Customer Code:</td>
                <td><?php echo htmlspecialchars($collection['CustomerCode']); ?></td>
            </tr>
            <?php if (!empty($collection['CustomerPhotoPath'])) { 
                $customerPhotoPath = ltrim($collection['CustomerPhotoPath'], '/');
            ?>
            <tr>
                <td class="label">Customer Photo:</td>
                <td>
                    <?php if (file_exists(__DIR__ . '/' . $customerPhotoPath)) { ?>
                        <img src="<?php echo $customerPhotoPath; ?>" alt="Customer Photo" class="customer-photo">
                    <?php } else { ?>
                        <span class="text-muted">Photo not available</span>
                    <?php } ?>
                </td>
            </tr>
            <?php } ?>
        </table>
        
        <!-- Pawn Details -->
        <table class="info-table">
            <tr>
                <td class="label">Pawn Code:</td>
                <td><?php echo htmlspecialchars($collection['PawnCode']); ?></td>
            </tr>
            <tr>
                <td class="label">Item Description:</td>
                <td><?php echo htmlspecialchars($collection['ItemDescription']); ?></td>
            </tr>
            <tr>
                <td class="label">Weight:</td>
                <td><?php echo $collection['ItemWeight']; ?> g</td>
            </tr>
            <?php if (!empty($collection['ItemPhotoPath'])) { 
                $itemPhotoPath = ltrim($collection['ItemPhotoPath'], '/');
            ?>
            <tr>
                <td class="label">Item Photo:</td>
                <td>
                    <?php if (file_exists(__DIR__ . '/' . $itemPhotoPath)) { ?>
                        <img src="<?php echo $itemPhotoPath; ?>" alt="Item Photo" class="customer-photo">
                    <?php } else { ?>
                        <span class="text-muted">Photo not available</span>
                    <?php } ?>
                </td>
            </tr>
            <?php } ?>
            <tr>
                <td class="label">Loan Amount:</td>
                <td>₹<?php echo number_format($collection['LoanAmount'], 2); ?></td>
            </tr>
            <tr>
                <td class="label">Interest Rate:</td>
                <td>15% per year (<?php echo number_format((0.15/365)*100, 4); ?>% per day)</td>
            </tr>
        </table>
        
        <!-- Payment Calculation -->
        <div class="amount-section">
            <div class="amount-row">
                <span>Loan Date:</span>
                <span><?php echo date('d/m/Y', strtotime($collection['LoanDate'])); ?></span>
            </div>
            <div class="amount-row">
                <span>Due Date:</span>
                <span><?php echo date('d/m/Y', strtotime($collection['DueDate'])); ?></span>
            </div>
            <div class="amount-row">
                <span>Interest Days:</span>
                <span><?php echo $collection['InterestDays']; ?> days</span>
            </div>
            <?php if ($collection['DaysOverdue'] > 0) { ?>
            <div class="amount-row">
                <span>Days Overdue:</span>
                <span style="color: red;"><?php echo $collection['DaysOverdue']; ?> days</span>
            </div>
            <?php } ?>
            <div class="amount-row">
                <span>Interest Amount:</span>
                <span>₹<?php echo number_format($collection['InterestAmount'], 2); ?></span>
            </div>
            <div class="amount-row">
                <span>Total Amount Due:</span>
                <span>₹<?php echo number_format($collection['TotalAmountDue'], 2); ?></span>
            </div>
            <div class="amount-row total-row">
                <span>Amount Paid:</span>
                <span>₹<?php echo number_format($collection['AmountPaid'], 2); ?></span>
            </div>
            <div class="amount-row">
                <span>Balance Amount:</span>
                <span>₹<?php echo number_format($collection['BalanceAmount'], 2); ?></span>
            </div>
        </div>
        
        <!-- Payment Details -->
        <table class="info-table">
            <tr>
                <td class="label">Payment Method:</td>
                <td><?php echo htmlspecialchars($collection['PaymentMethod']); ?></td>
            </tr>
            <?php if ($collection['ReferenceNumber']) { ?>
            <tr>
                <td class="label">Reference Number:</td>
                <td><?php echo htmlspecialchars($collection['ReferenceNumber']); ?></td>
            </tr>
            <?php } ?>
            <tr>
                <td class="label">Collected By:</td>
                <td><?php echo htmlspecialchars($collection['CollectedBy']); ?></td>
            </tr>
        </table>
        
        <?php if ($collection['Notes']) { ?>
        <table class="info-table">
            <tr>
                <td class="label">Notes:</td>
                <td><?php echo htmlspecialchars($collection['Notes']); ?></td>
            </tr>
        </table>
        <?php } ?>
        
        <!-- Signatures -->
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line"></div>
                <div>Customer Signature</div>
            </div>
            <div class="signature-box">
                <div class="signature-line"></div>
                <div>Authorized Signature</div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <p><strong><?php echo $shopDetails && ($shopDetails['FooterNote'] || $shopDetails['FooterNoteTamil']) ? htmlspecialchars($shopDetails['FooterNote'] ?: $shopDetails['FooterNoteTamil']) : 'Thank you for your business!'; ?></strong></p>
            <p>This receipt is computer generated. Please verify and retain for your records.</p>
        </div>
    </div>
    
    <script>
        // Auto print when page loads
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>
